/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.util.Vector;
import javax.vecmath.Vector3d;
import squirrel.JaliceFrame;
import squirrel.Plane;
import squirrel.Squirrel;
import squirrel.Util;

public class Ground {
    final Color GROUND_COLOR0 = new Color(0.35, 0.93, 0.35);
    final Color GROUND_COLOR1 = new Color(0.15, 0.73, 0.15);
    final Vector3 GROUND_POSITION = new Vector3(0.0, -0.5, 0.0);
    final int size = 1;
    Transformable groundVehicle;
    Visual groundVisual;
    IndexedTriangleArray groundITA;
    Appearance groundAppearance;
    public Plane groundPlane;
    public Vector tileVisuals;
    Transformable tileVehicle;
    int[][] ground_data;
    Transformable dammyVehicle;
    public double d;
    public Vector3[] camera_positions;
    public int current_camera;

    Ground(Container parent) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.ground_data = nArrayArray;
        this.d = 5.74;
        this.camera_positions = new Vector3[]{new Vector3(4.0, 1.0, -4.0), new Vector3(0.0, 0.0, -this.d), new Vector3(this.d, 0.0, 0.0), new Vector3(0.0, this.d, 0.0)};
        this.current_camera = -1;
        this.groundVehicle = new Transformable();
        this.groundVehicle.setParent(parent);
        IndexedTriangleArray tileITA = this.createGeometry();
        Appearance[] tileAppearance = new Appearance[2];
        tileAppearance[0] = new Appearance();
        tileAppearance[0].setDiffuseColor(this.GROUND_COLOR0);
        tileAppearance[0].setFillingStyle(FillingStyle.SOLID);
        tileAppearance[0].setShadingStyle(ShadingStyle.SMOOTH);
        tileAppearance[1] = new Appearance();
        tileAppearance[1].setDiffuseColor(this.GROUND_COLOR1);
        tileAppearance[1].setFillingStyle(FillingStyle.SOLID);
        tileAppearance[1].setShadingStyle(ShadingStyle.SMOOTH);
        this.tileVehicle = new Transformable();
        this.tileVehicle.setParent((Container)this.groundVehicle);
        this.tileVisuals = new Vector();
        int x = -5;
        while (x <= 5) {
            int y = -5;
            while (y <= 5) {
                this.setGroundTile(x, y, tileITA, tileAppearance[Util.mod(x + y, 2)]);
                ++y;
            }
            ++x;
        }
        this.groundVehicle.setPosition((Vector3d)this.GROUND_POSITION, null);
        this.groundPlane = new Plane(this.GROUND_POSITION, new Vector3(0.0, 1.0, 0.0));
    }

    public void hide() {
    }

    public void rotate(Point prev_p, Point p) {
        JaliceFrame jaliceFrame = Squirrel.jaliceFrame;
        jaliceFrame.cameraVehicle.rotate((Vector3d)Vector3.Y_AXIS, (double)(p.x - prev_p.x) / 100.0, (ReferenceFrame)this.groundVehicle);
        if (this.dammyVehicle == null) {
            this.dammyVehicle = new Transformable();
        }
        this.dammyVehicle.setParent((Container)jaliceFrame.scene);
        this.dammyVehicle.setPosition((Vector3d)new Vector3(0.0, 0.0, 0.0), (ReferenceFrame)jaliceFrame.scene);
        this.dammyVehicle.setOrientation((Vector3d)new Vector3(0.0, 0.0, 1.0), (Vector3d)Vector3.Y_AXIS, (ReferenceFrame)jaliceFrame.cameraVehicle);
        jaliceFrame.cameraVehicle.rotate((Vector3d)Vector3.X_AXIS, (double)(p.y - prev_p.y) / 100.0, (ReferenceFrame)this.dammyVehicle);
        this.dammyVehicle.setParent(null);
        prev_p.setLocation(p);
        this.current_camera = -1;
    }

    public void setGroundTile(int x, int y, IndexedTriangleArray tileITA, Appearance tileAppearance) {
        Transformable tile = new Transformable();
        tile.setParent((Container)this.tileVehicle);
        tile.setPosition((Vector3d)new Vector3((double)(x * 2), 0.0, (double)(y * 2)), null);
        Visual tileVisual = new Visual();
        tileVisual.setParent((Container)tile);
        tileVisual.setGeometry((Geometry)tileITA);
        tileVisual.setFrontFacingAppearance(tileAppearance);
        this.tileVisuals.addElement(tileVisual);
    }

    public void switch_camera() {
        JaliceFrame jaliceFrame = Squirrel.jaliceFrame;
        Vector3 pos = jaliceFrame.cameraVehicle.getPosition(null);
        Vector3 up = Vector3.Y_AXIS;
        if (this.current_camera == 0) {
            jaliceFrame.cameraVehicle.setPosition((Vector3d)this.camera_positions[1], null);
            this.current_camera = 1;
        } else if (this.current_camera == 1) {
            jaliceFrame.cameraVehicle.setPosition((Vector3d)this.camera_positions[2], null);
            this.current_camera = 2;
        } else if (this.current_camera == 2) {
            jaliceFrame.cameraVehicle.setPosition((Vector3d)this.camera_positions[3], null);
            up = Vector3.multiply((Vector3d)Vector3.Z_AXIS, (double)-1.0);
            this.current_camera = 3;
        } else {
            jaliceFrame.cameraVehicle.setPosition((Vector3d)this.camera_positions[0], null);
            this.current_camera = 0;
        }
        jaliceFrame.cameraVehicle.pointAt((ReferenceFrame)jaliceFrame.scene, (Vector3d)new Vector3(), (Vector3d)up, (ReferenceFrame)jaliceFrame.scene);
    }

    public void show() {
    }

    public IndexedTriangleArray createGeometry() {
        IndexedTriangleArray groundITA = new IndexedTriangleArray();
        Vertex3d[] groundVertices = new Vertex3d[12];
        int i = 0;
        while (i < 6) {
            double vx = this.ground_data[i][0] * 1;
            double vy = this.ground_data[i][1] * 1;
            double vz = this.ground_data[i][2] * 1;
            groundVertices[i] = Util.getVertex3d(new Vector3(vx, vy, vz), new Vector3(0.0, 1.0, 0.0));
            groundVertices[i + 6] = Util.getVertex3d(new Vector3(vx, vy, vz), new Vector3(0.0, -1.0, 0.0));
            ++i;
        }
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 8;
        nArray[8] = 7;
        nArray[9] = 9;
        nArray[10] = 11;
        nArray[11] = 10;
        int[] groundIndices = nArray;
        groundITA.setVertices(groundVertices);
        groundITA.setIndices(groundIndices);
        return groundITA;
    }
}

