/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;
import squirrel.CursorBall;
import squirrel.SpatialKeyframing;

public abstract class Filter {
    Vector3 position;
    Color COLOR = new Color(0.4, 0.4, 0.4, 1.0);
    Transformable filterVehicle;
    Visual filterVisual;
    IndexedTriangleArray filterITA;
    Appearance filterAppearance;
    Transformable parent;

    public abstract Vector3 pickFilter(Vector3 var1);

    public abstract Matrix44[] get_parameters(Vector3 var1, SpatialKeyframing var2);

    Filter() {
    }

    public void hide() {
        this.filterVehicle.setParent(null);
    }

    public abstract void update_keyFraming(SpatialKeyframing var1);

    public abstract void prepare_for_warp_cursor(CursorBall var1);

    public abstract Vector3 warp(Vector3 var1);

    public void show() {
        this.filterVehicle.setParent((Container)this.parent);
    }

    public void setPosition(Vector3 pos) {
        this.filterVehicle.setPosition((Vector3d)pos, (ReferenceFrame)this.parent);
    }

    public void setPosition(Vector3 pos, ReferenceFrame reference) {
        this.filterVehicle.setPosition((Vector3d)pos, reference);
    }

    public Vector3 getPosition() {
        return this.filterVehicle.getPosition((ReferenceFrame)this.parent);
    }

    public Vector3 getPosition(ReferenceFrame reference) {
        return this.filterVehicle.getPosition(reference);
    }

    public void init(Transformable parent, Color color, double radius) {
        this.parent = parent;
        this.COLOR = color;
        this.filterVehicle = new Transformable();
        this.filterVehicle.setParent((Container)parent);
        this.filterVisual = new Visual();
        this.filterVisual.setParent((Container)this.filterVehicle);
        this.filterITA = new IndexedTriangleArray();
        this.filterVisual.setGeometry((Geometry)this.filterITA);
        this.filterAppearance = new Appearance();
        this.filterVisual.setFrontFacingAppearance(this.filterAppearance);
        this.filterAppearance.setDiffuseColor(this.COLOR);
        this.filterAppearance.setFillingStyle(FillingStyle.SOLID);
        this.filterAppearance.setShadingStyle(ShadingStyle.SMOOTH);
    }

    public void delete() {
        this.filterVehicle.setParent(null);
    }
}

