/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import squirrel.AnchorBall;
import squirrel.BallShadow;
import squirrel.Base;
import squirrel.CursorBall;
import squirrel.Filter;
import squirrel.GhostBall;
import squirrel.Ground;
import squirrel.JaliceFrame;
import squirrel.KeyBall;
import squirrel.LockBall;
import squirrel.Locomotion;
import squirrel.Part;
import squirrel.Ring;
import squirrel.Squirrel;
import squirrel.TickListener;
import squirrel.TrajectoryEventHandler;

public class EventHandler
implements MouseListener,
MouseMotionListener,
KeyListener,
TickListener {
    Squirrel squirrel;
    Component target;
    JaliceFrame jaliceFrame;
    KeyBall draggedKeyBall = null;
    BallShadow draggedKeyBallShadow = null;
    Vector events = new Vector();
    Part pickedPart;
    int drag_count;
    int operation_status;
    boolean right_button;
    final int NONE = 0;
    final int ROTATING = 2;
    final int SLIDING = 3;
    final int DRAG_SHADOW = 4;
    final int ROTATE_SHADOW = 5;
    final int ROTATE_RING = 6;
    final int DRAG_CURSOR = 7;
    final int DRAG_CURSOR_SHADOW = 8;
    final int DRAG_KEYBALL = 9;
    final int DRAG_KEYBALL_SHADOW = 10;
    final int ROTATE_GROUND = 11;
    final int DRAG_FILTER = 12;
    final int DRAG_LOCKBALL = 13;
    final int DRAG_GHOSTBALL = 14;
    final int ZOOMING = 15;
    Point prev_p;
    public Vector3 pickedPosition;
    public Visual pickedVisual;

    public void disactivate() {
        this.removeListenders();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.addElement(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.events.addElement(mouseEvent);
    }

    EventHandler() {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.addElement(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    EventHandler(Squirrel squirrel) {
        this.squirrel = squirrel;
        this.jaliceFrame = Squirrel.jaliceFrame;
        this.target = Squirrel.jaliceFrame.awtComponent;
    }

    public void tick() {
        int i = 0;
        while (i < this.events.size()) {
            MouseEvent event = (MouseEvent)this.events.elementAt(i);
            if (event.getID() == 501) {
                this.process_mousePressed(event);
            } else if (event.getID() == 506) {
                if (i >= this.events.size() - 1 || ((MouseEvent)this.events.elementAt(i + 1)).getID() != 506) {
                    this.process_mouseDragged(event);
                }
            } else if (event.getID() == 502) {
                this.process_mouseReleased(event);
            }
            ++i;
        }
        this.events = new Vector();
    }

    public void activate() {
        this.addListenders();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void process_mousePressed(MouseEvent mouseEvent) {
        Point p;
        mouseEvent.getComponent().requestFocus();
        if (this.pickedPart != null) {
            this.pickedPart.disactivate();
        }
        this.pickedPart = null;
        this.operation_status = 0;
        this.drag_count = 0;
        this.prev_p = p = mouseEvent.getPoint();
        boolean bl = this.right_button = (mouseEvent.getModifiers() & 4) != 0 || (mouseEvent.getModifiers() & 1) != 0;
        if (p.x > this.jaliceFrame.awtComponent.getSize().width - 20) {
            this.operation_status = 15;
            return;
        }
        this.pickedVisual = this.pickVisual(mouseEvent.getX(), mouseEvent.getY());
        if (this.pickedVisual == null) {
            this.squirrel.ring.hide();
            return;
        }
        Object pickedObject = this.squirrel.visual_list.get(this.pickedVisual);
        if (pickedObject instanceof Ring) {
            this.operation_status = 6;
            return;
        }
        this.squirrel.ring.hide();
        if (pickedObject instanceof Ground) {
            this.operation_status = 11;
        } else if (pickedObject instanceof Filter) {
            this.operation_status = 12;
        } else if (pickedObject instanceof CursorBall) {
            this.squirrel.releaseAttachedCursor();
            this.squirrel.draggedCursor = (CursorBall)pickedObject;
            this.operation_status = 7;
            this.squirrel.selectedKeyBall = null;
        } else if (pickedObject instanceof BallShadow) {
            BallShadow shadow = (BallShadow)pickedObject;
            if (shadow.ball instanceof CursorBall) {
                this.squirrel.draggedCursorBase = (BallShadow)pickedObject;
                this.operation_status = 8;
                this.squirrel.selectedKeyBall = null;
            } else {
                this.draggedKeyBallShadow = (BallShadow)pickedObject;
                this.operation_status = 10;
            }
        } else if (pickedObject instanceof GhostBall) {
            this.operation_status = 14;
        } else if (pickedObject instanceof LockBall) {
            this.operation_status = 13;
        } else if (pickedObject instanceof AnchorBall) {
            Locomotion.remove_anchor((AnchorBall)pickedObject);
        } else if (pickedObject instanceof KeyBall) {
            this.draggedKeyBall = (KeyBall)pickedObject;
            this.operation_status = 9;
        } else if (pickedObject instanceof Base) {
            this.squirrel.draggedBase = (Base)pickedObject;
            this.operation_status = this.right_button ? 5 : 4;
        } else if (pickedObject instanceof Part) {
            if (this.right_button) {
                this.pickedPart = (Part)pickedObject;
                this.operation_status = 2;
                if (this.pickedPart.temporary_parent_vehicle != null) {
                    LockBall.swap_parent(this.pickedPart.partVehicle, this.pickedPart.temporary_parent_vehicle, this.pickedPart.get_model());
                }
            } else {
                this.pickedPart = ((Part)pickedObject).getRootPart();
                this.operation_status = 3;
            }
        } else {
            this.operation_status = 0;
        }
        if (this.pickedPart != null) {
            this.pickedPart.activate();
        }
    }

    public void process_mouseDragged(MouseEvent mouseEvent) {
        ++this.drag_count;
        Point p = mouseEvent.getPoint();
        Vector3 goal = null;
        switch (this.operation_status) {
            case 2: {
                this.squirrel.rotate(p, this.prev_p, this.pickedPart);
                break;
            }
            case 3: {
                goal = this.squirrel.screen_slide(p, this.prev_p, this.pickedPart.partVehicle);
                this.pickedPart.partVehicle.setPosition((Vector3d)goal, (ReferenceFrame)this.jaliceFrame.scene);
                if (this.squirrel.lockBall != null) {
                    this.squirrel.lockBall.pull_back();
                }
                this.squirrel.updateAttachedCursor();
                break;
            }
            case 15: {
                this.jaliceFrame.scale *= Math.pow(1.02, this.prev_p.y - p.y);
                this.jaliceFrame.set_camera_parameters();
                break;
            }
            case 4: {
                goal = this.squirrel.ground_slide(p, this.prev_p, this.squirrel.draggedBase.baseVehicle);
                this.squirrel.draggedBase.baseVehicle.setPosition((Vector3d)goal, (ReferenceFrame)this.jaliceFrame.scene);
                Locomotion.last_drag_location = this.squirrel.draggedBase.baseVehicle.getPosition(null);
                break;
            }
            case 5: {
                this.squirrel.rotate_base(p, this.prev_p);
                break;
            }
            case 6: {
                this.squirrel.rotate_ring(p, this.prev_p);
                break;
            }
            case 7: {
                goal = this.squirrel.screen_slide(p, this.prev_p, this.squirrel.draggedCursor.ballVehicle);
                this.squirrel.draggedCursor.setPosition(goal, (ReferenceFrame)this.jaliceFrame.scene);
                if (this.right_button || this instanceof TrajectoryEventHandler) {
                    this.squirrel.update_pose_based_on_cursor();
                }
                this.squirrel.perform_IK();
                break;
            }
            case 8: {
                goal = this.squirrel.ground_slide(p, this.prev_p, this.squirrel.draggedCursorBase.shadowVehicle);
                this.squirrel.draggedCursorBase.setPosition(goal, (ReferenceFrame)this.jaliceFrame.scene);
                this.squirrel.cursor.update_ghost();
                if (this.right_button) {
                    this.squirrel.update_pose_based_on_cursor();
                }
                this.squirrel.perform_IK();
                break;
            }
            case 14: {
                goal = this.squirrel.screen_project(p, this.squirrel.cursor.ballVehicle);
                this.squirrel.cursor.drag_ghost(goal, (ReferenceFrame)this.jaliceFrame.scene);
                if (!this.right_button) break;
                this.squirrel.update_pose_based_on_cursor();
                break;
            }
            case 9: {
                goal = this.squirrel.screen_slide(p, this.prev_p, this.draggedKeyBall.ballVehicle);
                this.draggedKeyBall.setPosition(goal, (ReferenceFrame)this.jaliceFrame.scene);
                break;
            }
            case 10: {
                goal = this.squirrel.ground_slide(p, this.prev_p, this.draggedKeyBallShadow.shadowVehicle);
                this.draggedKeyBallShadow.setPosition(goal, (ReferenceFrame)this.jaliceFrame.scene);
                break;
            }
            case 13: {
                this.squirrel.drag_lockBall(p, this.prev_p);
                if (this.right_button) {
                    this.squirrel.update_pose_based_on_cursor();
                }
                this.squirrel.perform_IK();
                break;
            }
            case 11: {
                this.squirrel.ground.rotate(this.prev_p, p);
                break;
            }
            case 12: {
                this.squirrel.drag_filter(p, this.prev_p);
                break;
            }
        }
        this.prev_p = p;
    }

    public void click_KeyBall(KeyBall keyBall, boolean right_button) {
        this.squirrel.cursor.jump_to_keyBall(keyBall);
        if (right_button) {
            keyBall.spatialKeyframing.get_model().set_parameters(keyBall.parameters);
            Vector3 local_position = keyBall.getPosition((ReferenceFrame)keyBall.attachedParent);
            this.squirrel.setAttachedCursor(keyBall.attachedParent, local_position);
        }
        this.squirrel.selectedKeyBall = keyBall;
    }

    public void removeListenders() {
        this.target.removeMouseListener(this);
        this.target.removeMouseMotionListener(this);
        this.target.removeKeyListener(this);
        this.squirrel.tickListeners.removeElement(this);
    }

    public void process_mouseReleased(MouseEvent mouseEvent) {
        if (this.pickedPart != null) {
            this.pickedPart.disactivate();
        }
        boolean click = this.drag_count < 2;
        Point p = mouseEvent.getPoint();
        switch (this.operation_status) {
            case 2: 
            case 3: {
                if (this.pickedPart.temporary_parent_vehicle != null) {
                    LockBall.restore_hierarchy(this.pickedPart.get_model());
                }
                if (!click) break;
                if ((mouseEvent.getModifiers() & 8) != 0) {
                    Transformable vehicle = (Transformable)this.pickedVisual.getParent();
                    Locomotion.anchor(vehicle, this.pickedPosition);
                    break;
                }
                if (!this.right_button) break;
                this.squirrel.ring.set(this.pickedPart);
                break;
            }
            case 9: {
                this.operation_status = 0;
                if (click) {
                    this.click_KeyBall(this.draggedKeyBall, this.right_button);
                }
                if (Squirrel.trash_bin != null && Squirrel.trash_bin.contains(p)) {
                    this.draggedKeyBall.delete();
                    this.squirrel.spatialKeyframing.keyBalls.removeElement(this.draggedKeyBall);
                    this.squirrel.update_keyFraming();
                }
                this.squirrel.repaint();
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                if (!click) break;
                this.squirrel.setCursorPosition(this.squirrel.filter.pickFilter(this.pickedPosition), this.pickedVisual, this.right_button);
                this.squirrel.selectedKeyBall = null;
            }
        }
        this.operation_status = 0;
        System.gc();
    }

    public void addListenders() {
        this.target.addMouseListener(this);
        this.target.addMouseMotionListener(this);
        this.target.addKeyListener(this);
        this.squirrel.tickListeners.addElement(this);
    }

    public Visual pickVisual(int x, int y) {
        PickInfo pickInfo = this.jaliceFrame.renderTarget.pick(x, y, true, true);
        if (pickInfo == null) {
            return null;
        }
        if (pickInfo.getCount() == 0) {
            return null;
        }
        this.pickedPosition = new Vector3((Tuple3d)pickInfo.getLocalPosition(0));
        return pickInfo.getVisual(0);
    }
}

