/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.math.Vector3;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.vecmath.Vector3d;
import squirrel.Ball;
import squirrel.GhostBall;
import squirrel.KeyBall;
import squirrel.Knot;
import squirrel.Model;
import squirrel.RingBuffer;

public class CursorBall
extends Ball {
    double CURSOR_RADIUS = 0.06;
    Color CURSOR_COLOR = new Color(0.8, 0.2, 0.6, 1.0);
    Model model;
    Ball ghost;
    RingBuffer prev_positions;
    Vector3 orientation;

    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
    }

    public CursorBall(Transformable parent, Model model) {
        this.model = model;
        this.init(parent, this.CURSOR_COLOR, this.CURSOR_RADIUS);
    }

    public void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
    }

    public void jump_to_keyBall(KeyBall keyBall) {
        this.setPosition(keyBall.getPosition());
        if (this.ghost != null) {
            this.orientation = keyBall.orientation;
            Vector3 position = Vector3.add((Vector3d)keyBall.getPosition(), (Vector3d)Vector3.multiply((Vector3d)this.orientation, (double)0.1));
            this.ghost.setPosition(position);
            int i = 0;
            while (i < 5) {
                this.prev_positions.push(position);
                ++i;
            }
        }
    }

    public void update_ghost() {
        if (this.ghost == null) {
            return;
        }
        Vector3 new_position = this.getPosition();
        Vector3 prev_position = (Vector3)this.prev_positions.push(new_position);
        Vector3 vec = Vector3.subtract((Vector3d)prev_position, (Vector3d)new_position);
        this.orientation = Vector3.normalizeV((Vector3d)vec);
        this.ghost.setPosition(Vector3.add((Vector3d)new_position, (Vector3d)Vector3.multiply((Vector3d)this.orientation, (double)0.1)));
    }

    public void drag_ghost(Vector3 goal, ReferenceFrame reference) {
        this.ghost.setPosition(goal, reference);
        Vector3 ghost_position = this.ghost.getPosition();
        Vector3 cursor_position = this.getPosition();
        this.orientation = Vector3.subtract((Vector3d)ghost_position, (Vector3d)cursor_position);
        this.orientation = Vector3.normalizeV((Vector3d)this.orientation);
        this.ghost.setPosition(Vector3.add((Vector3d)cursor_position, (Vector3d)Vector3.multiply((Vector3d)this.orientation, (double)0.1)));
    }

    public void init_ghost() {
        this.ghost = new GhostBall(this.parent, 0.05, new Color(0.4, 0.1, 0.3, 0.5));
        this.ghost.setPosition(this.getPosition());
        Vector3 prev_position = this.getPosition();
        this.prev_positions = new RingBuffer(5);
        int i = 0;
        while (i < 5) {
            this.prev_positions.push(prev_position);
            ++i;
        }
    }

    public void setPosition(Vector3 pos) {
        super.setPosition(pos);
        this.update_ghost();
    }

    public void setPosition(Vector3 pos, ReferenceFrame reference) {
        super.setPosition(pos, reference);
        this.update_ghost();
    }

    public Knot getKnot() {
        if (this.ghost == null) {
            return new Knot(this.getPosition(), null);
        }
        return new Knot(this.getPosition(), this.orientation);
    }
}

