/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import squirrel.Buttons;
import squirrel.JaliceFrame;
import squirrel.Squirrel;
import squirrel.Trajectory;

public class CreateMovie
extends Frame {
    TextField text0 = new TextField("0,0,0", 8);
    TextField text1 = new TextField("10", 8);
    TextField text2 = new TextField("128", 8);
    TextField text3 = new TextField("128", 8);
    TextField text5 = new TextField("image", 8);
    Label label0 = new Label("Background Color");
    Label label1 = new Label("Frame per Second");
    Label label2 = new Label("Width  (pixels)");
    Label label3 = new Label("Height (pixels)");
    Label label5 = new Label("File Name");
    Squirrel squirrel;

    public void hide_all() {
        this.squirrel.spatialKeyframing.hide_keyBalls();
        this.squirrel.cursor.hide();
        this.squirrel.getModel().base.hide();
    }

    public CreateMovie() {
        this.setWidgets();
        ((Component)this).setSize(320, 200);
        this.show();
    }

    public void create_movie() {
        int time;
        JaliceFrame jaliceFrame = Squirrel.jaliceFrame;
        this.squirrel = Squirrel.squirrel;
        Trajectory trajectory = this.squirrel.trajectory;
        int FPS = new Integer(this.text1.getText());
        int WIDTH = new Integer(this.text2.getText());
        int HEIGHT = new Integer(this.text3.getText());
        int LENGTH = trajectory.get_end_time();
        String filename = this.text5.getText();
        filename = "movie\\" + filename;
        jaliceFrame.renderTarget.setUpdateIsAutomatic(false);
        jaliceFrame.scene.getBackground().setColor(this.get_color(this.text0.getText()));
        this.hide_all();
        OffscreenRenderTarget offscreenRenderTarget = jaliceFrame.renderer.createOffscreenRenderTarget();
        offscreenRenderTarget.addCamera(jaliceFrame.camera);
        offscreenRenderTarget.setSize(WIDTH, HEIGHT);
        BufferedImage bufferedImage = new BufferedImage(WIDTH, HEIGHT, 1);
        int i = 0;
        while ((time = i * 1000 / FPS) <= LENGTH) {
            System.out.println("time " + (double)time / 1000.0);
            this.squirrel.cursor.setPosition(trajectory.get_position(time));
            this.squirrel.update_pose_based_on_cursor();
            offscreenRenderTarget.clearAndRenderOffscreen();
            Image offscreenImage = offscreenRenderTarget.getOffscreenImage();
            Graphics g = bufferedImage.getGraphics();
            g.drawImage(offscreenImage, 0, 0, null);
            g.dispose();
            String count = "0000" + i;
            count = count.substring(count.length() - 4);
            File file = new File(filename + count + ".png");
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
            catch (IOException e) {
                System.out.println("" + e);
            }
            ++i;
        }
        this.show_all();
        Squirrel.jaliceFrame.renderTarget.setUpdateIsAutomatic(true);
    }

    public void buttonPressed(String name) {
        if (name.equals("cancel")) {
            this.hide();
        } else if (name.equals("GO")) {
            this.create_movie();
            this.hide();
        }
    }

    public Color get_color(String string) {
        StringTokenizer st = new StringTokenizer(string, ",");
        double r = (double)new Integer(st.nextToken()).intValue() / 255.0;
        double g = (double)new Integer(st.nextToken()).intValue() / 255.0;
        double b = (double)new Integer(st.nextToken()).intValue() / 255.0;
        return new Color(r, g, b);
    }

    public void show_all() {
        this.squirrel.spatialKeyframing.show_keyBalls();
        this.squirrel.cursor.show();
        this.squirrel.getModel().base.show();
    }

    public void setWidgets() {
        this.label0.setAlignment(1);
        this.label1.setAlignment(1);
        this.label2.setAlignment(1);
        this.label3.setAlignment(1);
        this.label5.setAlignment(1);
        this.setLayout(new GridLayout(6, 2));
        this.add(this.label0);
        this.add(this.text0);
        this.add(this.label1);
        this.add(this.text1);
        this.add(this.label2);
        this.add(this.text2);
        this.add(this.label3);
        this.add(this.text3);
        this.add(this.label5);
        this.add(this.text5);
        MyButton button = new MyButton("GO");
        this.add(button);
        MyButton cancelButton = new MyButton("cancel");
        this.add(cancelButton);
    }

    class MyButton
    extends Button {
        MyButton(String label) {
            CreateMovie.this.getClass();
            this.setFont(Buttons.font);
            this.setLabel(label);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    CreateMovie.this.buttonPressed(MyButton.this.getLabel());
                }
                {
                    MyButton.this.getClass();
                }
            });
        }
    }
}

