/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;
import squirrel.Model;
import squirrel.Squirrel;
import squirrel.Util;

public class Base {
    final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f);
    final double size = 0.1;
    Model model;
    Transformable baseVehicle;
    Visual baseVisual;
    IndexedTriangleArray baseITA;
    Appearance baseAppearance;
    Container parent;
    Matrix44[] defaultModelPosition;
    Visual arrowVisual;
    Appearance arrowAppearance;

    public void resetModelPosition() {
        this.model.set_parameters(this.defaultModelPosition);
    }

    Base(Model model) {
        this.model = model;
        this.parent = Squirrel.squirrel.ground.groundVehicle;
        this.baseVehicle = new Transformable();
        this.baseVehicle.setParent(this.parent);
        this.baseVisual = new Visual();
        this.baseVisual.setParent((Container)this.baseVehicle);
        this.baseITA = new IndexedTriangleArray();
        this.baseVisual.setGeometry((Geometry)this.baseITA);
        this.setGeometry();
        this.baseAppearance = new Appearance();
        this.baseVisual.setFrontFacingAppearance(this.baseAppearance);
        this.baseAppearance.setDiffuseColor(this.SHADOW_COLOR);
        this.baseAppearance.setFillingStyle(FillingStyle.SOLID);
        this.baseAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.set_arrow();
        this.defaultModelPosition = model.get_parameters();
        this.resetPosition();
    }

    public void hide() {
        this.baseVisual.setParent(null);
        this.arrowVisual.setParent(null);
    }

    public void set_arrow() {
        this.arrowVisual = new Visual();
        this.arrowVisual.setParent((Container)this.baseVehicle);
        IndexedTriangleArray arrowITA = new IndexedTriangleArray();
        this.arrowVisual.setGeometry((Geometry)arrowITA);
        this.arrowAppearance = new Appearance();
        this.arrowVisual.setFrontFacingAppearance(this.arrowAppearance);
        this.arrowAppearance.setDiffuseColor(Color.WHITE);
        this.arrowAppearance.setFillingStyle(FillingStyle.SOLID);
        this.arrowAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        Vertex3d[] arrowVertices = new Vertex3d[7];
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 5;
        nArray[8] = 6;
        int[] arrowIndices = nArray;
        double h = 0.06666666666666667;
        double w1 = 0.05;
        double w2 = 0.013333333333333334;
        double[][] dArrayArray = new double[7][];
        double[] dArray = new double[2];
        dArray[1] = -h;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[2];
        dArray2[0] = -w1;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[2];
        dArray3[0] = w1;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[2];
        dArray4[0] = -w2;
        dArrayArray[3] = dArray4;
        double[] dArray5 = new double[2];
        dArray5[0] = w2;
        dArrayArray[4] = dArray5;
        dArrayArray[5] = new double[]{-w2, h};
        dArrayArray[6] = new double[]{w2, h};
        double[][] XY = dArrayArray;
        int i = 0;
        while (i < 7) {
            arrowVertices[i] = Util.getVertex3d(new Vector3(XY[i][0], 0.0, XY[i][1]), new Vector3(0.0, 1.0, 0.0));
            ++i;
        }
        arrowITA.setVertices(arrowVertices);
        arrowITA.setIndices(arrowIndices);
    }

    public void setGeometry() {
        int n = 12;
        Vertex3d[] baseVertices = new Vertex3d[n * 2 + 2];
        baseVertices[0] = Util.getVertex3d(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
        baseVertices[1] = Util.getVertex3d(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, -1.0, 0.0));
        int i = 0;
        while (i < n) {
            double vx = Math.cos(Math.PI * 2 * (double)i / (double)n) * 0.1;
            double vy = 0.0;
            double vz = Math.sin(Math.PI * 2 * (double)i / (double)n) * 0.1;
            baseVertices[2 + i] = Util.getVertex3d(new Vector3(vx, vy, vz), new Vector3(0.0, 1.0, 0.0));
            baseVertices[2 + i + n] = Util.getVertex3d(new Vector3(vx, vy, vz), new Vector3(0.0, -1.0, 0.0));
            ++i;
        }
        int[] baseIndices = new int[n * 2 * 3];
        int i2 = 0;
        while (i2 < n) {
            baseIndices[i2 * 3] = 0;
            baseIndices[i2 * 3 + 1] = 2 + i2;
            baseIndices[i2 * 3 + 2] = 2 + Util.mod(i2 + 1, n);
            baseIndices[n * 3 + i2 * 3] = 1;
            baseIndices[n * 3 + i2 * 3 + 2] = 2 + n + i2;
            baseIndices[n * 3 + i2 * 3 + 1] = 2 + n + Util.mod(i2 + 1, n);
            ++i2;
        }
        this.baseITA.setVertices(baseVertices);
        this.baseITA.setIndices(baseIndices);
    }

    public void show() {
        this.baseVisual.setParent((Container)this.baseVehicle);
        this.arrowVisual.setParent((Container)this.baseVehicle);
    }

    public void resetPosition() {
        this.baseVehicle.setPosition((Vector3d)new Vector3(0.0, 0.001, 0.0), (ReferenceFrame)this.parent);
    }

    public void delete() {
        this.baseVehicle.setParent(null);
    }
}

