/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;
import squirrel.Ball;
import squirrel.Util;

public class BallShadow {
    final Color SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f);
    Transformable shadowVehicle;
    Visual shadowVisual;
    IndexedTriangleArray shadowITA;
    Appearance shadowAppearance;
    Ball ball;
    Container parent;
    Transformable ground;

    public void updatePosition() {
        if (this.parent == null) {
            return;
        }
        Vector3 pos = this.ball.ballVehicle.getPosition((ReferenceFrame)this.ground);
        this.shadowVehicle.setPosition((Vector3d)new Vector3(pos.x, 0.001, pos.z), (ReferenceFrame)this.ground);
    }

    BallShadow(Ball ball, Transformable ground) {
        this.ball = ball;
        this.parent = ball.parent;
        this.shadowVehicle = new Transformable();
        this.shadowVehicle.setParent(this.parent);
        this.shadowVisual = new Visual();
        this.shadowVisual.setParent((Container)this.shadowVehicle);
        this.shadowITA = new IndexedTriangleArray();
        this.shadowVisual.setGeometry((Geometry)this.shadowITA);
        this.setGeometry(ball.RADIUS);
        this.shadowAppearance = new Appearance();
        this.shadowVisual.setFrontFacingAppearance(this.shadowAppearance);
        this.shadowAppearance.setDiffuseColor(this.SHADOW_COLOR);
        this.shadowAppearance.setFillingStyle(FillingStyle.SOLID);
        this.shadowAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.updatePosition();
    }

    public void setGeometry(double size) {
        int n = 12;
        Vertex3d[] shadowVertices = new Vertex3d[n * 2 + 2];
        shadowVertices[0] = this.newVertex(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
        shadowVertices[1] = this.newVertex(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, -1.0, 0.0));
        int i = 0;
        while (i < n) {
            double vx = Math.cos(Math.PI * 2 * (double)i / (double)n) * size;
            double vy = 0.0;
            double vz = Math.sin(Math.PI * 2 * (double)i / (double)n) * size;
            shadowVertices[2 + i] = this.newVertex(new Vector3(vx, vy, vz), new Vector3(0.0, 1.0, 0.0));
            shadowVertices[2 + i + n] = this.newVertex(new Vector3(vx, vy, vz), new Vector3(0.0, -1.0, 0.0));
            ++i;
        }
        int[] shadowIndices = new int[n * 2 * 3];
        int i2 = 0;
        while (i2 < n) {
            shadowIndices[i2 * 3] = 0;
            shadowIndices[i2 * 3 + 1] = 2 + i2;
            shadowIndices[i2 * 3 + 2] = 2 + Util.mod(i2 + 1, n);
            shadowIndices[n * 3 + i2 * 3] = 1;
            shadowIndices[n * 3 + i2 * 3 + 2] = 2 + n + i2;
            shadowIndices[n * 3 + i2 * 3 + 1] = 2 + n + Util.mod(i2 + 1, n);
            ++i2;
        }
        this.shadowITA.setVertices(shadowVertices);
        this.shadowITA.setIndices(shadowIndices);
    }

    public Vertex3d newVertex(Vector3 p, Vector3 n) {
        return Util.getVertex3d(p, n);
    }

    public void updateBallPosition() {
        Vector3 pos = this.ball.ballVehicle.getPosition((ReferenceFrame)this.ground);
        Vector3 shadow_pos = this.shadowVehicle.getPosition((ReferenceFrame)this.ground);
        pos.x = shadow_pos.x;
        pos.z = shadow_pos.z;
        this.ball.setPosition(pos, (ReferenceFrame)this.ground);
    }

    public void setPosition(Vector3 p, ReferenceFrame reference) {
        this.shadowVehicle.setPosition((Vector3d)p, reference);
        this.updateBallPosition();
    }
}

