/*
 * Decompiled with CFR 0.152.
 */
package squirrel;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;
import squirrel.BallShadow;
import squirrel.Part;
import squirrel.Util;

public class Ball {
    Vector3 position;
    double RADIUS = 0.06;
    Color COLOR = new Color(0.8, 0.2, 0.6, 1.0);
    Transformable ballVehicle;
    Visual ballVisual;
    IndexedTriangleArray ballITA;
    Appearance ballAppearance;
    Transformable parent;
    Part attached_part;
    BallShadow ballShadow;

    Ball() {
    }

    Ball(Transformable parent) {
        this.init(parent, this.COLOR, this.RADIUS);
    }

    Ball(Transformable parent, double radius, Color color) {
        this.init(parent, color, radius);
    }

    public void hide() {
        this.ballVisual.setParent(null);
        if (this.ballShadow != null) {
            this.ballShadow.shadowVisual.setParent(null);
        }
    }

    public void init_no_shadow(Transformable parent, Color color, double radius) {
        this.parent = parent;
        this.COLOR = color;
        this.RADIUS = radius;
        this.ballVehicle = new Transformable();
        this.ballVehicle.setParent((Container)parent);
        this.ballVisual = new Visual();
        this.ballVisual.setParent((Container)this.ballVehicle);
        this.ballITA = new IndexedTriangleArray();
        this.ballVisual.setGeometry((Geometry)this.ballITA);
        this.setGeometry(this.ballITA, this.RADIUS);
        this.ballAppearance = new Appearance();
        this.ballVisual.setFrontFacingAppearance(this.ballAppearance);
        this.ballAppearance.setDiffuseColor(this.COLOR);
        this.ballAppearance.setFillingStyle(FillingStyle.SOLID);
        this.ballAppearance.setShadingStyle(ShadingStyle.SMOOTH);
    }

    public void setGeometry(IndexedTriangleArray ballITA, double radius) {
        Vector3 center = new Vector3(0.0, 0.0, 0.0);
        Vertex3d[] ballVertices = new Vertex3d[26];
        int n = 0;
        int y = 0;
        while (y < 5) {
            Vector3 nv;
            double yangle = Math.PI * 2 * (double)y / 8.0;
            double yradius = radius * Math.cos(yangle);
            double xradius = radius * Math.sin(yangle);
            if (y == 0 || y == 4) {
                int i = n++;
                ballVertices[i] = new Vertex3d(19);
                Vector3 v = new Vector3(0.0, yradius, 0.0);
                ballVertices[i].position.set(v.x, v.y, v.z);
                nv = Vector3.subtract((Vector3d)v, (Vector3d)center);
                nv.normalize();
                ballVertices[i].normal.set(nv.x, nv.y, nv.z);
            } else {
                int x = 0;
                while (x < 8) {
                    double xangle = Math.PI * 2 * (double)x / 8.0;
                    int i = n++;
                    ballVertices[i] = new Vertex3d(19);
                    Vector3 v = new Vector3(xradius * Math.cos(xangle), yradius, xradius * Math.sin(xangle));
                    ballVertices[i].position.set(v.x, v.y, v.z);
                    nv = Vector3.subtract((Vector3d)v, (Vector3d)center);
                    nv.normalize();
                    ballVertices[i].normal.set(nv.x, nv.y, nv.z);
                    ++x;
                }
            }
            ++y;
        }
        int[] ballIndices = new int[144];
        n = 0;
        int x = 0;
        while (x < 8) {
            ballIndices[n++] = 17 + x;
            ballIndices[n++] = 17 + Util.mod(x + 1, 8);
            ballIndices[n++] = 25;
            ballIndices[n++] = 1 + x;
            ballIndices[n++] = 0;
            ballIndices[n++] = 1 + Util.mod(x + 1, 8);
            ++x;
        }
        int y2 = 0;
        while (y2 < 2) {
            int x2 = 0;
            while (x2 < 8) {
                ballIndices[n++] = 1 + y2 * 8 + x2;
                ballIndices[n++] = 1 + y2 * 8 + Util.mod(x2 + 1, 8);
                ballIndices[n++] = 1 + y2 * 8 + x2 + 8;
                ballIndices[n++] = 1 + y2 * 8 + x2 + 8;
                ballIndices[n++] = 1 + y2 * 8 + Util.mod(x2 + 1, 8);
                ballIndices[n++] = 1 + y2 * 8 + Util.mod(x2 + 1, 8) + 8;
                ++x2;
            }
            ++y2;
        }
        ballITA.setVertices(ballVertices);
        ballITA.setIndices(ballIndices);
    }

    public void show() {
        this.ballVisual.setParent((Container)this.ballVehicle);
        if (this.ballShadow != null) {
            this.ballShadow.shadowVisual.setParent((Container)this.ballShadow.shadowVehicle);
        }
    }

    public void setPosition(Vector3 pos) {
        this.ballVehicle.setPosition((Vector3d)pos, (ReferenceFrame)this.parent);
        if (this.ballShadow != null) {
            this.ballShadow.updatePosition();
        }
    }

    public void setPosition(Vector3 pos, ReferenceFrame reference) {
        this.ballVehicle.setPosition((Vector3d)pos, reference);
        if (this.ballShadow != null) {
            this.ballShadow.updatePosition();
        }
    }

    public Vector3 getPosition() {
        return this.ballVehicle.getPosition((ReferenceFrame)this.parent);
    }

    public Vector3 getPosition(ReferenceFrame reference) {
        return this.ballVehicle.getPosition(reference);
    }

    public void init(Transformable parent, Color color, double radius) {
        this.init_no_shadow(parent, color, radius);
        this.ballShadow = new BallShadow(this, (Transformable)parent.getParent());
    }

    public void delete() {
        this.ballVehicle.setParent(null);
        if (this.ballShadow != null) {
            this.ballShadow.shadowVehicle.setParent(null);
        }
    }
}

