/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.DoubleQR;
import VisualNumerics.math.DoubleVector;
import VisualNumerics.math.MathException;

public class DoubleMatrix {
    static void CheckMatrix(double[][] dArray, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        nArray[0] = dArray.length;
        nArray2[0] = dArray[0].length;
        int n = 1;
        while (n < nArray[0]) {
            if (dArray[n].length != nArray2[0]) {
                throw new IllegalArgumentException("The lengths of the rows of the input matrix are not consistent.");
            }
            ++n;
        }
    }

    static boolean IsSymmetric(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (n != n2) {
            return false;
        }
        int n3 = 1;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n3) {
                if (dArray[n3][n4] != dArray[n4][n3]) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public static double[] QRsolve(double[][] dArray, double[] dArray2) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = dArray2.length;
        if (n != n3) {
            throw new IllegalArgumentException("The number of rows in the input matrix A is not equal to the number of elements in the input vector B.");
        }
        try {
            DoubleQR doubleQR = new DoubleQR(dArray);
            return doubleQR.solve(dArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (MathException mathException) {
            throw mathException;
        }
    }

    public static double[][] add(double[][] dArray, double[][] dArray2) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        DoubleMatrix.CheckMatrix(dArray2, nArray, nArray2);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n != n3 || n2 != n4) {
            throw new IllegalArgumentException("Matrices A and B must have similar dimensions.");
        }
        double[][] dArray3 = new double[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                dArray3[n5][n6] = dArray[n5][n6] + dArray2[n5][n6];
                ++n6;
            }
            ++n5;
        }
        return dArray3;
    }

    static double[][] copy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            System.arraycopy(dArray[n3], 0, dArray2[n3], 0, n2);
            ++n3;
        }
        return dArray2;
    }

    public static double determinant(double[][] dArray) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        if (n2 != n) {
            throw new IllegalArgumentException("The matrix is not square.");
        }
        DoubleLU doubleLU = new DoubleLU(dArray);
        return doubleLU.determinant();
    }

    public static double frobeniusNorm(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray2[n3] = dArray[n3][0];
            ++n3;
        }
        double d = DoubleVector.twoNorm(dArray2);
        int n4 = 1;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                dArray2[n5] = dArray[n5][n4];
                ++n5;
            }
            double d2 = DoubleVector.twoNorm(dArray2);
            d = DoubleMatrix.hypt(d, d2);
            ++n4;
        }
        return d;
    }

    private static double hypt(double d, double d2) {
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        if (d3 == 0.0) {
            return d3;
        }
        double d4 = Math.min(Math.abs(d), Math.abs(d2)) / d3;
        d4 = Math.pow(d4, 2.0);
        double d5 = 4.0 + d4;
        while (d5 != 4.0) {
            double d6 = d4 / d5;
            double d7 = 1.0 + 2.0 * d6;
            d3 *= d7;
            d4 = d6 / d7 * (d6 / d7) * d4;
            d5 = 4.0 + d4;
        }
        return d3;
    }

    public static double infinityNorm(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                d2 += Math.abs(dArray[n3][n4]);
                ++n4;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static double[][] inverse(double[][] dArray) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        if (n2 != n) {
            throw new IllegalArgumentException("The matrix is not square.");
        }
        DoubleLU doubleLU = new DoubleLU(dArray);
        return doubleLU.inverse();
    }

    public static double[] multiply(double[] dArray, double[][] dArray2) throws IllegalArgumentException {
        int n = dArray.length;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray2, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        if (n != n2) {
            throw new IllegalArgumentException("The number of elements in the input vector is not equal to the number of rows in the input matrix.");
        }
        double[] dArray3 = new double[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = n4;
                dArray3[n6] = dArray3[n6] + dArray[n5] * dArray2[n5][n4];
                ++n5;
            }
            ++n4;
        }
        return dArray3;
    }

    public static double[] multiply(double[][] dArray, double[] dArray2) throws IllegalArgumentException {
        int n = dArray2.length;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        if (n3 != n) {
            throw new IllegalArgumentException("The number of columns in the input matrix is not equal to the number of elements in the input vector.");
        }
        double[] dArray3 = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = n4;
                dArray3[n6] = dArray3[n6] + dArray[n4][n5] * dArray2[n5];
                ++n5;
            }
            ++n4;
        }
        return dArray3;
    }

    public static double[][] multiply(double[][] dArray, double[][] dArray2) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        DoubleMatrix.CheckMatrix(dArray2, nArray, nArray2);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n2 != n3) {
            throw new IllegalArgumentException("The number of columns in the input matrix A is not equal to the number of rows in the input matrix B.");
        }
        double[][] dArray3 = new double[n][n4];
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n4) {
                int n7 = 0;
                while (n7 < n3) {
                    double[] dArray4 = dArray3[n5];
                    int n8 = n6;
                    dArray4[n8] = dArray4[n8] + dArray[n5][n7] * dArray2[n7][n6];
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        return dArray3;
    }

    public static double oneNorm(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n) {
                d2 += Math.abs(dArray[n4][n3]);
                ++n4;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static double[] solve(double[][] dArray, double[] dArray2) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = dArray2.length;
        if (n != n3) {
            throw new IllegalArgumentException("The number of rows in the input matrix A is not equal to the number of elements in the input vector B.");
        }
        try {
            DoubleLU doubleLU = new DoubleLU(dArray);
            return doubleLU.solve(dArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (MathException mathException) {
            throw mathException;
        }
    }

    public static double[][] subtract(double[][] dArray, double[][] dArray2) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        DoubleMatrix.CheckMatrix(dArray2, nArray, nArray2);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n != n3 || n2 != n4) {
            throw new IllegalArgumentException("Matrices A and B must have similar dimensions.");
        }
        double[][] dArray3 = new double[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                dArray3[n5][n6] = dArray[n5][n6] - dArray2[n5][n6];
                ++n6;
            }
            ++n5;
        }
        return dArray3;
    }

    public static double trace(double[][] dArray) throws MathException {
        double d = 0.0;
        if (dArray.length != dArray[0].length) {
            throw new MathException("Matrix is not square.");
        }
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n][n];
            ++n;
        }
        return d;
    }

    public static double[][] transpose(double[][] dArray) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        double[][] dArray2 = new double[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                dArray2[n3][n4] = dArray[n4][n3];
                ++n4;
            }
            ++n3;
        }
        return dArray2;
    }

    static double[][] zero(int n, int n2) {
        double[][] dArray = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = 0.0;
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }
}

