/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.MathException;

public class DoubleLU {
    private double[][] factor;
    private double[][] acopy;
    private int[] ipvt;
    private int[] info;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;

    public DoubleLU(double[][] dArray) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        int n = nArray2[0];
        this.acopy = dArray;
        this.factor = new double[n][n];
        this.ipvt = new int[n];
        this.info = new int[1];
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(dArray[n2], 0, this.factor[n2], 0, n);
            ++n2;
        }
        this.info[0] = 0;
        int n3 = n - 1;
        if (n3 >= 1) {
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                int n6 = n4 + 1;
                this.ipvt[n4] = n5 = BLAS.idamax(n - n4, this.factor[n4], n4, 1) + n4;
                if (this.factor[n4][n5] == 0.0) {
                    this.info[0] = n4;
                } else {
                    double d;
                    if (n5 != n4) {
                        d = this.factor[n4][n5];
                        this.factor[n4][n5] = this.factor[n4][n4];
                        this.factor[n4][n4] = d;
                    }
                    d = -1.0 / this.factor[n4][n4];
                    BLAS.dscal(n - n4 - 1, d, this.factor[n4], n6, 1);
                    int n7 = n6;
                    while (n7 < n) {
                        d = this.factor[n7][n5];
                        if (n5 != n4) {
                            this.factor[n7][n5] = this.factor[n7][n4];
                            this.factor[n7][n4] = d;
                        }
                        BLAS.daxpy(n - n4 - 1, d, this.factor[n4], n6, 1, this.factor[n7], n6, 1);
                        ++n7;
                    }
                }
                ++n4;
            }
        }
        this.ipvt[n3] = n3;
        if (this.factor[n3][n3] == 0.0) {
            this.info[0] = n3;
        }
        if (this.info[0] != 0) {
            throw new MathException("The input matrix is singular. Some of the diagonal elements of the upper triangular matrix U of the LU factorization are close to zero.");
        }
    }

    public double condition() {
        int n;
        int n2;
        double d;
        int n3;
        double d2;
        int n4 = this.acopy[0].length;
        double d3 = 1.0;
        double d4 = BLAS.dnr1rr(n4, n4, this.acopy);
        double d5 = 1.0;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        int n5 = 0;
        while (n5 < n4) {
            if (dArray[n5] != 0.0) {
                d5 = Math.abs(d5);
                if (-dArray[n5] < 0.0) {
                    d5 = -d5;
                }
            }
            if (Math.abs(d5 - dArray[n5]) > Math.abs(this.factor[n5][n5])) {
                d2 = Math.abs(this.factor[n5][n5]) / Math.abs(d5 - dArray[n5]);
                BLAS.dscal(n4, d2, dArray, 0, 1);
                d5 = d2 * d5;
            }
            double d6 = d5 - dArray[n5];
            double d7 = -d5 - dArray[n5];
            d2 = Math.abs(d6);
            double d8 = Math.abs(d7);
            if (this.factor[n5][n5] == 0.0) {
                d6 = 1.0;
                d7 = 1.0;
            } else {
                d6 /= this.factor[n5][n5];
                d7 /= this.factor[n5][n5];
            }
            n3 = n5 + 1;
            if (n3 < n4) {
                int n6 = n3;
                while (n6 < n4) {
                    d8 += Math.abs(dArray[n6] + d7 * this.factor[n5][n6]);
                    dArray[n6] = dArray[n6] + d6 * this.factor[n5][n6];
                    d2 += Math.abs(dArray[n6]);
                    ++n6;
                }
                if (d2 < d8) {
                    d = d7 - d6;
                    d6 = d7;
                    int n7 = n3;
                    System.arraycopy(this.factor[n5], n7, dArray2, 0, n4 - n7 + 1);
                    BLAS.daxpy(n4 - 1 - n5, d, dArray2, 0, 1, dArray, n3, 1);
                }
            }
            dArray[n5] = d6;
            ++n5;
        }
        d2 = 1.0 / BLAS.dasum(n4, dArray, 0, 1);
        BLAS.dscal(n4, d2, dArray, 0, 1);
        n5 = n4 - 1;
        while (n5 >= 0) {
            if (n5 < n4 - 1) {
                n2 = 0;
                n = 0;
                while (n < n4) {
                    dArray2[n] = this.factor[n2][n5];
                    ++n2;
                    ++n;
                }
                dArray[n5] = dArray[n5] + BLAS.ddot(n4 - 1 - n5, dArray2, n5 + 1, 1, dArray, n5 + 1, 1);
            }
            if (Math.abs(dArray[n5]) > 1.0) {
                d2 = 1.0 / Math.abs(dArray[n5]);
                BLAS.dscal(n4, d2, dArray, 0, 1);
            }
            n = this.ipvt[n5];
            d = dArray[n];
            dArray[n] = dArray[n5];
            dArray[n5] = d;
            --n5;
        }
        d2 = 1.0 / BLAS.dasum(n4, dArray, 0, 1);
        BLAS.dscal(n4, d2, dArray, 0, 1);
        double d9 = 1.0;
        n5 = 0;
        while (n5 < n4) {
            n = this.ipvt[n5];
            d = dArray[n];
            dArray[n] = dArray[n5];
            dArray[n5] = d;
            if (n5 < n4 - 1) {
                n3 = n5 + 1;
                n2 = 0;
                n = 0;
                while (n < n4) {
                    dArray2[n] = this.factor[n2][n5];
                    ++n2;
                    ++n;
                }
                BLAS.daxpy(n4 - 1 - n5, d, dArray2, n3, 1, dArray, n3, 1);
            }
            if (Math.abs(dArray[n5]) > 1.0) {
                d2 = 1.0 / Math.abs(dArray[n5]);
                BLAS.dscal(n4, d2, dArray, 0, 1);
                d9 = d2 * d9;
            }
            ++n5;
        }
        d2 = 1.0 / BLAS.dasum(n4, dArray, 0, 1);
        BLAS.dscal(n4, d2, dArray, 0, 1);
        d9 = d2 * d9;
        n5 = n4 - 1;
        while (n5 >= 0) {
            if (Math.abs(dArray[n5]) > Math.abs(this.factor[n5][n5])) {
                d2 = Math.abs(this.factor[n5][n5]) / Math.abs(dArray[n5]);
                BLAS.dscal(n4, d2, dArray, 0, 1);
                d9 = d2 * d9;
            }
            dArray[n5] = this.factor[n5][n5] == 0.0 ? 1.0 : dArray[n5] / this.factor[n5][n5];
            d = -dArray[n5];
            n2 = 0;
            n = 0;
            while (n < n4) {
                dArray2[n] = this.factor[n2][n5];
                ++n2;
                ++n;
            }
            BLAS.daxpy(n5, d, dArray2, 0, 1, dArray, 0, 1);
            --n5;
        }
        d2 = 1.0 / BLAS.dasum(n4, dArray, 0, 1);
        BLAS.dscal(n4, d2, dArray, 0, 1);
        d9 = d2 * d9;
        if (d4 != 0.0) {
            d3 = d9 / d4;
        }
        return d3;
    }

    public double determinant() {
        double d = 1.0;
        double d2 = 1.0;
        int n = this.factor.length;
        int n2 = 0;
        while (n2 < n) {
            d *= this.factor[n2][n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.ipvt[n2] > n2) {
                d2 *= -1.0;
            }
            ++n2;
        }
        return d *= d2;
    }

    public double[][] inverse() {
        int n = this.acopy[0].length;
        double[] dArray = new double[n];
        double[][] dArray2 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            dArray2[n2] = this.solve(dArray);
            dArray[n2] = 0.0;
            ++n2;
        }
        dArray2 = DoubleMatrix.transpose(dArray2);
        return dArray2;
    }

    public int[] ipvt() {
        return this.ipvt;
    }

    public double[] solve(double[] dArray) {
        double[] dArray2;
        block8: {
            double d;
            int n;
            int n2;
            block7: {
                double d2;
                int n3;
                boolean bl = true;
                n2 = dArray.length;
                dArray2 = new double[n2];
                System.arraycopy(dArray, 0, dArray2, 0, n2);
                n = n2 - 1;
                if (bl) break block7;
                if (n >= 1) {
                    n3 = 0;
                    while (n3 < n) {
                        int n4 = n3 + 1;
                        int n5 = this.ipvt[n3];
                        d2 = dArray2[n5];
                        if (n5 != n3) {
                            dArray2[n5] = dArray2[n3];
                            dArray2[n3] = d2;
                        }
                        BLAS.daxpy(n - n3, d2, this.factor[n3], n4, 1, dArray2, n4, 1);
                        ++n3;
                    }
                }
                n3 = n;
                while (n3 >= 0) {
                    dArray2[n3] = dArray2[n3] / this.factor[n3][n3];
                    d2 = -dArray2[n3];
                    BLAS.daxpy(n3, d2, this.factor[n3], 0, 1, dArray2, 0, 1);
                    --n3;
                }
                break block8;
            }
            int n6 = 0;
            while (n6 < n2) {
                d = BLAS.ddot(n6, this.factor[n6], 0, 1, dArray2, 0, 1);
                dArray2[n6] = (dArray2[n6] - d) / this.factor[n6][n6];
                ++n6;
            }
            if (n < 1) break block8;
            int n7 = n;
            n6 = n - 1;
            while (n6 >= 0) {
                dArray2[n6] = dArray2[n6] + BLAS.ddot(n - n6, this.factor[n6], n7, 1, dArray2, n7, 1);
                n7 = n6;
                int n8 = this.ipvt[n6];
                if (n8 != n6) {
                    d = dArray2[n8];
                    dArray2[n8] = dArray2[n6];
                    dArray2[n6] = d;
                }
                --n6;
            }
        }
        return dArray2;
    }
}

