/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.Complex;
import VisualNumerics.math.ComplexMatrix;
import VisualNumerics.math.MathException;

public class ComplexLU {
    private int[] ipvt;
    private int[] info;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;
    private Complex[][] zfactr;
    private Complex[][] zcopy;

    public ComplexLU(Complex[][] complexArray) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Complex complex = new Complex();
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray2[0];
        this.zcopy = complexArray;
        this.zfactr = new Complex[n][n];
        this.ipvt = new int[n];
        this.info = new int[1];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                this.zfactr[n2][n3] = new Complex(complexArray[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        this.info[0] = 0;
        int n4 = n - 1;
        if (n4 >= 1) {
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                int n7 = n5 + 1;
                this.ipvt[n5] = n6 = BLAS.izamax(n - n5, this.zfactr[n5], n5, 1) + n5;
                if (Complex.zabs1(this.zfactr[n5][n6]) == 0.0) {
                    this.info[0] = n5;
                } else {
                    Complex complex2;
                    if (n6 != n5) {
                        complex2 = this.zfactr[n5][n6];
                        this.zfactr[n5][n6] = this.zfactr[n5][n5];
                        this.zfactr[n5][n5] = complex2;
                    }
                    complex2 = new Complex(-1.0, 0.0);
                    complex2 = Complex.divide(complex2, this.zfactr[n5][n5]);
                    BLAS.zscal(n - n5 - 1, complex2, this.zfactr[n5], n7, 1);
                    int n8 = n7;
                    while (n8 < n) {
                        complex2 = this.zfactr[n8][n6];
                        if (n6 != n5) {
                            this.zfactr[n8][n6] = this.zfactr[n8][n5];
                            this.zfactr[n8][n5] = complex2;
                        }
                        BLAS.zaxpy(n - n5 - 1, complex2, this.zfactr[n5], n7, 1, this.zfactr[n8], n7, 1);
                        ++n8;
                    }
                }
                ++n5;
            }
        }
        this.ipvt[n4] = n4;
        if (this.zfactr[n4][n4].equals(complex)) {
            this.info[0] = n4;
        }
        if (this.info[0] != 0) {
            throw new MathException("The input matrix is singular. Some of the diagonal elements of the upper triangular matrix U of the LU factorization are close to zero.");
        }
    }

    public double condition() {
        int n;
        Complex complex;
        int n2;
        double d;
        Complex complex2;
        int n3 = this.zcopy[0].length;
        double d2 = 1.0;
        double d3 = BLAS.znr1rr(n3, n3, this.zcopy);
        Complex complex3 = new Complex(1.0, 0.0);
        Complex[] complexArray = new Complex[n3];
        BLAS.zset(n3, new Complex(), complexArray, 0, 1);
        int n4 = 0;
        while (n4 < n3) {
            Complex complex4 = Complex.negate(complexArray[n4]);
            if (Complex.zabs1(complexArray[n4]) != 0.0) {
                complex2 = new Complex(Complex.zabs1(complex4));
                complex2 = Complex.divide(complex4, complex2);
                complex3 = Complex.multiply(Complex.zabs1(complex3), complex2);
            }
            if (Complex.zabs1(complex2 = Complex.subtract(complex3, complexArray[n4])) > Complex.zabs1(this.zfactr[n4][n4])) {
                d = Complex.zabs1(this.zfactr[n4][n4]);
                BLAS.zdscal(n3, d /= Complex.zabs1(complex2), complexArray, 0, 1);
                complex3 = Complex.multiply(d, complex3);
            }
            complex4 = Complex.subtract(complex3, complexArray[n4]);
            Complex complex5 = Complex.negate(complex3);
            complex5 = Complex.subtract(complex5, complexArray[n4]);
            d = Complex.zabs1(complex4);
            double d4 = Complex.zabs1(complex5);
            if (Complex.zabs1(this.zfactr[n4][n4]) != 0.0) {
                complex2 = Complex.conjugate(this.zfactr[n4][n4]);
                complex4 = Complex.divide(complex4, complex2);
                complex5 = Complex.divide(complex5, complex2);
            } else {
                complex4 = new Complex(1.0, 0.0);
                complex5 = new Complex(1.0, 0.0);
            }
            n2 = n4 + 1;
            if (n2 < n3) {
                int n5 = n2;
                while (n5 < n3) {
                    complex2 = Complex.conjugate(this.zfactr[n5][n4]);
                    complex2 = Complex.multiply(complex5, complex2);
                    complex2 = Complex.add(complexArray[n5], complex2);
                    d4 += Complex.zabs1(complex2);
                    complex2 = Complex.conjugate(this.zfactr[n5][n4]);
                    complex2 = Complex.multiply(complex4, complex2);
                    complexArray[n5] = Complex.add(complexArray[n5], complex2);
                    d += Complex.zabs1(complexArray[n5]);
                    ++n5;
                }
                if (d < d4) {
                    complex = Complex.subtract(complex5, complex4);
                    complex4 = new Complex(complex5);
                    n5 = n2;
                    while (n5 < n3) {
                        complex2 = Complex.conjugate(this.zfactr[n5][n4]);
                        complex2 = Complex.multiply(complex, complex2);
                        complexArray[n5] = Complex.add(complexArray[n5], complex2);
                        ++n5;
                    }
                }
            }
            complexArray[n4] = new Complex(complex4);
            ++n4;
        }
        d = 1.0 / BLAS.dzasum(n3, complexArray, 0, 1);
        BLAS.zdscal(n3, d, complexArray, 0, 1);
        n4 = n3 - 1;
        while (n4 >= 0) {
            if (n4 < n3 - 1) {
                complex2 = BLAS.zdotc(n3 - 1 - n4, this.zfactr[n4], n4 + 1, 1, complexArray, n4 + 1, 1);
                complexArray[n4] = Complex.add(complexArray[n4], complex2);
            }
            if (Complex.zabs1(complexArray[n4]) > 1.0) {
                d = 1.0 / Complex.zabs1(complexArray[n4]);
                BLAS.zdscal(n3, d, complexArray, 0, 1);
            }
            n = this.ipvt[n4];
            complex = complexArray[n];
            complexArray[n] = complexArray[n4];
            complexArray[n4] = complex;
            --n4;
        }
        d = 1.0 / BLAS.dzasum(n3, complexArray, 0, 1);
        BLAS.zdscal(n3, d, complexArray, 0, 1);
        double d5 = 1.0;
        n4 = 0;
        while (n4 < n3) {
            n = this.ipvt[n4];
            complex = complexArray[n];
            complexArray[n] = complexArray[n4];
            complexArray[n4] = complex;
            if (n4 < n3 - 1) {
                n2 = n4 + 1;
                BLAS.zaxpy(n3 - 1 - n4, complex, this.zfactr[n4], n2, 1, complexArray, n2, 1);
            }
            if (Complex.zabs1(complexArray[n4]) > 1.0) {
                d = 1.0 / Complex.zabs1(complexArray[n4]);
                BLAS.zdscal(n3, d, complexArray, 0, 1);
                d5 = d * d5;
            }
            ++n4;
        }
        d = 1.0 / BLAS.dzasum(n3, complexArray, 0, 1);
        BLAS.zdscal(n3, d, complexArray, 0, 1);
        d5 = d * d5;
        n4 = n3 - 1;
        while (n4 >= 0) {
            if (Complex.zabs1(complexArray[n4]) > Complex.zabs1(this.zfactr[n4][n4])) {
                d = Complex.zabs1(this.zfactr[n4][n4]) / Complex.zabs1(complexArray[n4]);
                BLAS.zdscal(n3, d, complexArray, 0, 1);
                d5 = d * d5;
            }
            complexArray[n4] = Complex.zabs1(this.zfactr[n4][n4]) != 0.0 ? Complex.divide(complexArray[n4], this.zfactr[n4][n4]) : new Complex(1.0, 0.0);
            complex = Complex.negate(complexArray[n4]);
            BLAS.zaxpy(n4, complex, this.zfactr[n4], 0, 1, complexArray, 0, 1);
            --n4;
        }
        d = 1.0 / BLAS.dzasum(n3, complexArray, 0, 1);
        BLAS.zdscal(n3, d, complexArray, 0, 1);
        d5 = d * d5;
        if (d3 != 0.0) {
            d2 = d5 / d3;
        }
        return d2;
    }

    public Complex determinant() {
        Complex complex = new Complex(1.0, 0.0);
        double d = 1.0;
        int n = this.zfactr.length;
        int n2 = 0;
        while (n2 < n) {
            complex = Complex.multiply(complex, this.zfactr[n2][n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.ipvt[n2] > n2) {
                d *= -1.0;
            }
            ++n2;
        }
        complex = Complex.multiply(complex, d);
        return complex;
    }

    public Complex[][] inverse() {
        int n = this.zcopy[0].length;
        Complex[] complexArray = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex();
            ++n2;
        }
        Complex[][] complexArray2 = new Complex[n][n];
        n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(1.0, 0.0);
            complexArray2[n2] = this.solve(complexArray);
            complexArray[n2] = new Complex();
            ++n2;
        }
        complexArray2 = ComplexMatrix.transpose(complexArray2);
        return complexArray2;
    }

    public int[] ipvt() {
        return this.ipvt;
    }

    public Complex[] solve(Complex[] complexArray) {
        Complex[] complexArray2;
        block9: {
            Complex complex;
            int n;
            int n2;
            block8: {
                Complex complex2;
                int n3;
                boolean bl = true;
                n2 = complexArray.length;
                complexArray2 = new Complex[n2];
                int n4 = 0;
                while (n4 < n2) {
                    complexArray2[n4] = new Complex(complexArray[n4]);
                    ++n4;
                }
                n = n2 - 1;
                if (bl) break block8;
                if (n >= 1) {
                    n3 = 0;
                    while (n3 < n) {
                        int n5 = n3 + 1;
                        int n6 = this.ipvt[n3];
                        complex2 = complexArray2[n6];
                        if (n6 != n3) {
                            complexArray2[n6] = complexArray2[n3];
                            complexArray2[n3] = complex2;
                        }
                        BLAS.zaxpy(n - n3, complex2, this.zfactr[n3], n5, 1, complexArray2, n5, 1);
                        ++n3;
                    }
                }
                n3 = n;
                while (n3 >= 0) {
                    complexArray2[n3] = Complex.divide(complexArray2[n3], this.zfactr[n3][n3]);
                    complex2 = Complex.negate(complexArray2[n3]);
                    BLAS.zaxpy(n3, complex2, this.zfactr[n3], 0, 1, complexArray2, 0, 1);
                    --n3;
                }
                break block9;
            }
            int n7 = 0;
            while (n7 < n2) {
                complex = BLAS.zdot(n7, this.zfactr[n7], 0, 1, complexArray2, 0, 1);
                complexArray2[n7] = Complex.subtract(complexArray2[n7], complex);
                complexArray2[n7] = Complex.divide(complexArray2[n7], this.zfactr[n7][n7]);
                ++n7;
            }
            if (n < 1) break block9;
            int n8 = n;
            n7 = n - 1;
            while (n7 >= 0) {
                complexArray2[n7] = Complex.add(complexArray2[n7], BLAS.zdot(n - n7, this.zfactr[n7], n8, 1, complexArray2, n8, 1));
                n8 = n7;
                int n9 = this.ipvt[n7];
                if (n9 != n7) {
                    complex = complexArray2[n9];
                    complexArray2[n9] = complexArray2[n7];
                    complexArray2[n7] = complex;
                }
                --n7;
            }
        }
        return complexArray2;
    }
}

