/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

final class ComplexA {
    static final double INFINITY = Double.POSITIVE_INFINITY;

    ComplexA() {
    }

    static final double abs(double[] dArray) {
        double d;
        double d2 = Math.abs(dArray[0]);
        if (d2 + (d = Math.abs(dArray[1])) == 0.0) {
            return 0.0;
        }
        if (d2 > d) {
            return d2 * Math.sqrt(1.0 + (d /= d2) * d);
        }
        return d * Math.sqrt((d2 /= d) * d2 + 1.0);
    }

    static final void add(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
    }

    static final double[] conjugate(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], -dArray[1]};
        return dArray2;
    }

    static final double[] divide(double[] dArray, double d) {
        double[] dArray2 = new double[]{dArray[0] / d, dArray[1] / d};
        return dArray2;
    }

    static final double[] divide(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[2];
        if (Math.abs(dArray2[0]) > Math.abs(dArray2[1])) {
            double d = dArray2[1] / dArray2[0];
            double d2 = dArray2[0] + dArray2[1] * d;
            dArray3[0] = (dArray[0] + dArray[1] * d) / d2;
            dArray3[1] = (dArray[1] - dArray[0] * d) / d2;
        } else {
            double d = dArray2[0] / dArray2[1];
            double d3 = dArray2[1] + dArray2[0] * d;
            dArray3[0] = (dArray[1] + dArray[0] * d) / d3;
            dArray3[1] = (dArray[1] * d - dArray[0]) / d3;
        }
        return dArray3;
    }

    static final boolean equals(double[] dArray, double[] dArray2) {
        return dArray[0] == dArray2[0] && dArray[1] == dArray2[1];
    }

    static final void multiply(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
    }

    static final void multiply(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        dArray[0] = d * d3 - d2 * d4;
        dArray[1] = d * d4 + d2 * d3;
    }

    static final void multiply(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] * dArray2[0] - dArray[1] * dArray2[1];
        dArray3[1] = dArray[0] * dArray2[1] + dArray[1] * dArray2[0];
    }

    static final void subtract(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] - dArray2[0];
        dArray[1] = dArray[1] - dArray2[1];
    }

    static final double zabs1(double[] dArray) {
        return Math.abs(dArray[0]) + Math.abs(dArray[1]);
    }
}

