/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.tracker.vicon;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.io.tracker.vicon.MarkerData;
import edu.cmu.cs.stage3.io.tracker.vicon.ViconTracker;

public class ViconMarker
extends Element {
    public final StringProperty markerName = new StringProperty((Element)this, "markerName", "");
    public final StringProperty subjectName = new StringProperty((Element)this, "subjectName", "");
    public final TransformableProperty transformable = new TransformableProperty((Element)this, "transformable", null);
    private MarkerData markerData = new MarkerData();
    private ViconTracker tracker = new ViconTracker();

    public ViconMarker() {
    }

    public ViconMarker(String mn) {
        int colon = mn.indexOf(58);
        if (colon == -1) {
            this.markerName.set((Object)mn);
            this.subjectName.set((Object)"");
        } else {
            this.subjectName.set((Object)mn.substring(0, colon));
            this.markerName.set((Object)mn.substring(colon + 1));
        }
        this.transformable.set(null);
    }

    public ViconMarker(String sn, String mn) {
        this.markerName.set((Object)mn);
        this.subjectName.set((Object)sn);
        this.transformable.set(null);
    }

    public ViconMarker(String mn, Transformable trans) {
        int colon = mn.indexOf(58);
        if (colon == -1) {
            this.markerName.set((Object)mn);
            this.subjectName.set((Object)"");
        } else {
            this.subjectName.set((Object)mn.substring(0, colon));
            this.markerName.set((Object)mn.substring(colon + 1));
        }
        this.transformable.set((Object)trans.createCopyNamed(this.getMarkerName().replace(':', '_').concat("_marker"), null, null));
    }

    public ViconMarker(String sn, String mn, Transformable trans) {
        this.markerName.set((Object)mn);
        this.subjectName.set((Object)sn);
        this.transformable.set((Object)trans.createCopyNamed(this.getMarkerName().replace(':', '_').concat("_marker"), null, null));
    }

    public String getMarkerName() {
        if (this.subjectName.getStringValue() == "") {
            return this.markerName.getStringValue();
        }
        return this.subjectName.getStringValue().concat(":".concat(this.markerName.getStringValue()));
    }

    public void enable(String[] channelNames) {
        if (this.markerName.getStringValue() != "") {
            this.markerData.name = this.getMarkerName();
            for (int i = 0; i < channelNames.length; ++i) {
                if (channelNames[i].endsWith(this.markerData.name.concat(" <P-X>"))) {
                    this.markerData.indexPX = i;
                    continue;
                }
                if (channelNames[i].endsWith(this.markerData.name.concat(" <P-Y>"))) {
                    this.markerData.indexPY = i;
                    continue;
                }
                if (channelNames[i].endsWith(this.markerData.name.concat(" <P-Z>"))) {
                    this.markerData.indexPZ = i;
                    continue;
                }
                if (!channelNames[i].endsWith(this.markerData.name.concat(" <P-O>"))) continue;
                this.markerData.indexPO = i;
            }
            if (this.markerData.indexPX != -1 && this.markerData.indexPY != -1 && this.markerData.indexPZ != -1) {
                this.tracker.enable();
            }
        }
    }

    public void update(double[] data) {
        if (this.tracker.isEnabled()) {
            this.tracker.setTransformation(this.markerData.update(data));
            Transformable transValue = (Transformable)this.transformable.getElementValue();
            if (transValue != null) {
                if (this.markerData.isVisible(data) && this.tracker.getTransformation() != null) {
                    ((Model)transValue).isShowing.set(true);
                    transValue.localTransformation.set((Object)this.tracker.getTransformation());
                } else {
                    ((Model)transValue).isShowing.set(false);
                }
            }
        }
    }
}

