/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.tracker.vicon;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.io.tracker.vicon.BodyData;
import edu.cmu.cs.stage3.io.tracker.vicon.ViconTracker;

public class ViconBody
extends Element {
    public final StringProperty bodyName = new StringProperty((Element)this, "bodyName", "");
    public final StringProperty subjectName = new StringProperty((Element)this, "subjectName", "");
    public final TransformableProperty transformable = new TransformableProperty((Element)this, "transformable", null);
    private BodyData bodyData = new BodyData();
    private ViconTracker tracker = new ViconTracker();

    public ViconBody() {
    }

    public ViconBody(String bn) {
        int colon = bn.indexOf(58);
        if (colon == -1) {
            this.bodyName.set((Object)bn);
            this.subjectName.set((Object)"");
        } else {
            this.subjectName.set((Object)bn.substring(0, colon));
            this.bodyName.set((Object)bn.substring(colon + 1));
        }
        this.transformable.set(null);
    }

    public ViconBody(String sn, String bn) {
        this.bodyName.set((Object)bn);
        this.subjectName.set((Object)sn);
        this.transformable.set(null);
    }

    public ViconBody(String bn, Transformable trans) {
        int colon = bn.indexOf(58);
        if (colon == -1) {
            this.bodyName.set((Object)bn);
            this.subjectName.set((Object)"");
        } else {
            this.subjectName.set((Object)bn.substring(0, colon));
            this.bodyName.set((Object)bn.substring(colon + 1));
        }
        this.transformable.set((Object)trans);
    }

    public ViconBody(String sn, String bn, Transformable trans) {
        this.bodyName.set((Object)bn);
        this.subjectName.set((Object)sn);
        this.transformable.set((Object)trans);
    }

    public String getBodyName() {
        if (this.subjectName.getStringValue() == "") {
            return this.bodyName.getStringValue();
        }
        return this.subjectName.getStringValue().concat(":".concat(this.bodyName.getStringValue()));
    }

    public void enable(String[] channelNames) {
        if (this.bodyName.getStringValue() != "") {
            this.bodyData.name = this.getBodyName();
            for (int i = 0; i < channelNames.length; ++i) {
                if (channelNames[i].endsWith(this.bodyData.name.concat(" <A-X>"))) {
                    this.bodyData.indexAX = i;
                    continue;
                }
                if (channelNames[i].endsWith(this.bodyData.name.concat(" <A-Y>"))) {
                    this.bodyData.indexAY = i;
                    continue;
                }
                if (channelNames[i].endsWith(this.bodyData.name.concat(" <A-Z>"))) {
                    this.bodyData.indexAZ = i;
                    continue;
                }
                if (channelNames[i].endsWith(this.bodyData.name.concat(" <T-X>"))) {
                    this.bodyData.indexTX = i;
                    continue;
                }
                if (channelNames[i].endsWith(this.bodyData.name.concat(" <T-Y>"))) {
                    this.bodyData.indexTY = i;
                    continue;
                }
                if (!channelNames[i].endsWith(this.bodyData.name.concat(" <T-Z>"))) continue;
                this.bodyData.indexTZ = i;
            }
            if (this.bodyData.indexAX != -1 && this.bodyData.indexAY != -1 && this.bodyData.indexAZ != -1 && this.bodyData.indexTX != -1 && this.bodyData.indexTY != -1 && this.bodyData.indexTZ != -1) {
                this.tracker.enable();
            }
        }
    }

    public void update(double[] data) {
        if (this.tracker.isEnabled()) {
            this.tracker.setTransformation(this.bodyData.update(data));
            Transformable transValue = (Transformable)this.transformable.getElementValue();
            if (transValue != null && this.tracker.getTransformation() != null) {
                transValue.localTransformation.set((Object)this.tracker.getTransformation());
            }
        }
    }
}

