/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.tracker.vicon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

class TarsusClient
extends Thread {
    protected InetAddress serverIP;
    protected int serverPort = 800;
    protected boolean connected = false;
    protected long delay = 10L;
    protected Socket socket;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected String[] channelNames;
    protected double[] data;
    protected double[] tempData;
    public static int CLOSE = 0;
    public static int INFO = 1;
    public static int DATA = 2;
    public static int STREAMING_ON = 3;
    public static int STREAMING_OFF = 4;
    public static int REQUEST = 0;
    public static int REPLY = 1;
    private StringBuffer tempSB = new StringBuffer();

    public TarsusClient() {
        try {
            this.serverIP = InetAddress.getLocalHost();
            this.start();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public synchronized String[] connect() {
        if (this.connected) {
            this.disconnect();
        }
        if (this.serverIP == null) {
            System.err.println("Error: cannot connect because serverIP is null");
        } else {
            try {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("connecting to ").append(this.serverIP.getHostName()).append(" (").append(this.serverIP.getHostAddress()).append(")"))));
                this.socket = new Socket(this.serverIP, this.serverPort);
                this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.requestChannelInfo();
                this.connected = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.channelNames;
    }

    public String[] connect(String hostName) {
        this.setServerIP(hostName);
        return this.connect();
    }

    public String[] connect(String hostName, int port) {
        this.setServerIP(hostName);
        this.setServerPort(port);
        return this.connect();
    }

    public String[] connect(InetAddress serverIP) {
        this.setServerIP(serverIP);
        return this.connect();
    }

    public String[] connect(InetAddress serverIP, int port) {
        this.setServerIP(serverIP);
        this.setServerPort(port);
        return this.connect();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void disconnect() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("disconnecting from ").append(this.serverIP.getHostName()).append(" (").append(this.serverIP.getHostAddress()).append(")"))));
        try {
            this.socket.close();
            this.socket = null;
            this.in = null;
            this.out = null;
            this.channelNames = null;
            this.data = null;
            this.tempData = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connected = false;
    }

    public double[] getData() {
        return this.data;
    }

    public InetAddress getServerIP() {
        return this.serverIP;
    }

    public synchronized void setServerIP(InetAddress serverIP) {
        if (this.connected) {
            this.disconnect();
        }
        this.serverIP = serverIP;
    }

    public synchronized void setServerIP(String hostName) {
        if (this.connected) {
            this.disconnect();
        }
        try {
            this.serverIP = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            System.err.println("Error: unknown host: ".concat(String.valueOf(String.valueOf(hostName))));
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public synchronized void setServerPort(int serverPort) {
        if (this.connected) {
            this.disconnect();
        }
        this.serverPort = serverPort;
    }

    protected synchronized void requestChannelInfo() throws IOException {
        this.writeInt(INFO);
        this.writeInt(REQUEST);
        this.out.flush();
        int packet = this.readInt();
        if (packet != REPLY) {
            throw new RuntimeException("bad packet while requesting info: ".concat(String.valueOf(String.valueOf(packet))));
        }
        int type = this.readInt();
        if (type != INFO) {
            throw new RuntimeException("bad type while requesting info: ".concat(String.valueOf(String.valueOf(type))));
        }
        this.channelNames = this.readInfo();
        this.data = new double[this.channelNames.length];
        this.tempData = new double[this.channelNames.length];
    }

    protected synchronized void requestData() throws IOException {
        this.writeInt(DATA);
        this.writeInt(REQUEST);
        this.out.flush();
        int packet = this.readInt();
        if (packet != DATA) {
            throw new RuntimeException("bad packet while requesting data: ".concat(String.valueOf(String.valueOf(packet))));
        }
        int type = this.readInt();
        if (type != REPLY) {
            throw new RuntimeException("bad type while requesting data: ".concat(String.valueOf(String.valueOf(type))));
        }
        this.readData(this.tempData);
        double[] dArray = this.data;
        synchronized (dArray) {
            System.arraycopy(this.tempData, 0, this.data, 0, this.tempData.length);
        }
    }

    protected String[] readInfo() throws IOException {
        int infoSize = this.readInt();
        String[] info = new String[infoSize];
        for (int i = 0; i < infoSize; ++i) {
            info[i] = this.readString();
        }
        return info;
    }

    protected String readString() throws IOException {
        int stringSize = this.readInt();
        this.tempSB.setLength(0);
        for (int i = 0; i < stringSize; ++i) {
            this.tempSB.append((char)this.in.readByte());
        }
        return this.tempSB.toString();
    }

    protected void readData(double[] d) throws IOException {
        int dataSize = this.readInt();
        if (d.length != dataSize) {
            throw new RuntimeException("size of data array read from socket does not match size of channel array");
        }
        for (int i = 0; i < dataSize; ++i) {
            d[i] = this.readDouble();
        }
    }

    protected int readInt() throws IOException {
        int i = this.in.readInt();
        return (i & 0xFF) << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >>> 8 | (i & 0xFF000000) >>> 24;
    }

    protected void writeInt(int i) throws IOException {
        int j = (i & 0xFF) << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >>> 8 | (i & 0xFF000000) >>> 24;
        this.out.writeInt(j);
    }

    protected double readDouble() throws IOException {
        byte[] bytes = new byte[8];
        this.in.read(bytes);
        long l = ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[0] & 0xFFL) << 0;
        return Double.longBitsToDouble(l);
    }

    public void run() {
        while (true) {
            TarsusClient tarsusClient = this;
            synchronized (tarsusClient) {
                try {
                    if (this.connected) {
                        this.requestData();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

