/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.tracker.vicon;

import edu.cmu.cs.stage3.math.Matrix44;

class BodyData {
    String name = "head";
    int indexTX = -1;
    int indexTY = -1;
    int indexTZ = -1;
    int indexAX = -1;
    int indexAY = -1;
    int indexAZ = -1;

    BodyData() {
    }

    Matrix44 update(double[] data) {
        if (this.indexTX == -1 || this.indexTY == -1 || this.indexTZ == -1 || this.indexAX == -1 || this.indexAY == -1 || this.indexAZ == -1) {
            return null;
        }
        double len = Math.sqrt(data[this.indexAX] * data[this.indexAX] + data[this.indexAY] * data[this.indexAY] + data[this.indexAZ] * data[this.indexAZ]);
        double QW = Math.cos(len / 2.0);
        double tmp = Math.sin(len / 2.0);
        if (len < 1.0E-10) {
            double QX = data[this.indexAX];
            double QY = data[this.indexAY];
            double QZ = data[this.indexAZ];
        } else {
            double QX = data[this.indexAX] * tmp / len;
            double QY = data[this.indexAY] * tmp / len;
            double QZ = data[this.indexAZ] * tmp / len;
        }
        Matrix44 m = new Matrix44();
        if (!(len < 1.0E-15)) {
            double x = data[this.indexAX] / len;
            double y = data[this.indexAY] / len;
            double z = data[this.indexAZ] / len;
            double c = Math.cos(len);
            double s = Math.sin(len);
            double ra = c + (1.0 - c) * x * x;
            double rd = (1.0 - c) * x * y + s * -z;
            double rg = (1.0 - c) * x * z + s * y;
            double rb = (1.0 - c) * y * x + s * z;
            double re = c + (1.0 - c) * y * y;
            double rh = (1.0 - c) * y * z + s * -x;
            double rc = (1.0 - c) * z * x + s * -y;
            double rf = (1.0 - c) * z * y + s * x;
            double ri = c + (1.0 - c) * z * z;
            double tx = data[this.indexTX] * 0.001;
            double ty = data[this.indexTY] * 0.001;
            double tz = data[this.indexTZ] * 0.001;
            m = new Matrix44(re, -rf, -rd, 0.0, -rh, ri, rg, 0.0, -rb, rc, ra, 0.0, -ty, tz, tx, 1.0);
        }
        return m;
    }
}

