/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.toolkit;

import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Vector;

public class Toolkit {
    private static boolean s_successfullyLoadedLibrary;
    private static Component s_source;
    private static Vector s_mouseListeners;
    private static Vector s_mouseMotionListeners;
    private static Point m_prevCursorLocation;
    private static int m_prevModifiers;
    private static int m_clickCount;
    private static int[] s_prevCursorXY;
    private static int[] s_currCursorXY;
    static Class class$java$awt$event$MouseMotionListener;
    static Class class$java$awt$event$MouseListener;

    public static native boolean getCursorLocationIsSupported();

    public static native boolean setCursorLocationIsSupported();

    public static native boolean isKeyPressedIsSupported();

    public static native boolean getModifiersIsSupported();

    public static boolean pumpMessageQueueIsSupported() {
        return true;
    }

    public static boolean mouseListenersAreSupported() {
        return Toolkit.getModifiersIsSupported() && Toolkit.getCursorLocationIsSupported();
    }

    public static boolean mouseMotionListenersAreSupported() {
        return Toolkit.getModifiersIsSupported() && Toolkit.getCursorLocationIsSupported();
    }

    public static native void pumpMessageQueue();

    private static native void getCursorLocation(int[] var0);

    public static Point getCursorLocation() {
        int[] xy = new int[]{0, 0};
        Toolkit.getCursorLocation(xy);
        return new Point(xy[0], xy[1]);
    }

    public static native void setCursorLocation(int var0, int var1);

    public static void setCursorLocation(Point p) {
        Toolkit.setCursorLocation(p.x, p.y);
    }

    public static native boolean isKeyPressed(int var0);

    public static native int getModifiers();

    private static boolean isButton1Pressed(int modifiers) {
        return (modifiers & 0x10) == 16;
    }

    private static boolean isButton2Pressed(int modifiers) {
        return (modifiers & 8) == 8;
    }

    private static boolean isButton3Pressed(int modifiers) {
        return (modifiers & 4) == 4;
    }

    public static void invokeMouseAndMouseMotionListenersIfNecessary() {
        int id = 0;
        int currModifiers = Toolkit.getModifiers();
        boolean drag = false;
        if (Toolkit.isButton1Pressed(m_prevModifiers)) {
            if (Toolkit.isButton1Pressed(currModifiers)) {
                drag = true;
            } else {
                id = 502;
            }
        } else if (Toolkit.isButton1Pressed(currModifiers)) {
            id = 501;
            drag = true;
        }
        if (Toolkit.isButton2Pressed(m_prevModifiers)) {
            if (Toolkit.isButton2Pressed(currModifiers)) {
                drag = true;
            } else {
                id = 502;
            }
        } else if (Toolkit.isButton2Pressed(currModifiers)) {
            id = 501;
            drag = true;
        }
        if (Toolkit.isButton3Pressed(m_prevModifiers)) {
            if (Toolkit.isButton3Pressed(currModifiers)) {
                drag = true;
            } else {
                id = 502;
            }
        } else if (Toolkit.isButton3Pressed(currModifiers)) {
            id = 501;
            drag = true;
        }
        long when = System.currentTimeMillis();
        boolean isPopupTrigger = false;
        Toolkit.getCursorLocation(s_currCursorXY);
        if (id != 0) {
            if (s_mouseListeners.size() > 0) {
                MouseEvent mouseEvent = new MouseEvent(s_source, id, when, currModifiers, s_currCursorXY[0], s_currCursorXY[1], m_clickCount, isPopupTrigger);
                block11: for (int i = 0; i < s_mouseListeners.size(); ++i) {
                    MouseListener mouseListener = (MouseListener)s_mouseListeners.elementAt(i);
                    switch (id) {
                        case 500: {
                            mouseListener.mouseClicked(mouseEvent);
                            continue block11;
                        }
                        case 504: {
                            mouseListener.mouseEntered(mouseEvent);
                            continue block11;
                        }
                        case 505: {
                            mouseListener.mouseExited(mouseEvent);
                            continue block11;
                        }
                        case 501: {
                            mouseListener.mousePressed(mouseEvent);
                            continue block11;
                        }
                        case 502: {
                            mouseListener.mouseReleased(mouseEvent);
                        }
                    }
                }
            }
        } else if ((s_prevCursorXY[0] != s_currCursorXY[0] || s_prevCursorXY[1] != s_currCursorXY[1]) && s_mouseMotionListeners.size() > 0) {
            id = drag ? 506 : 503;
            MouseEvent mouseEvent = new MouseEvent(s_source, id, when, currModifiers, s_currCursorXY[0], s_currCursorXY[1], m_clickCount, isPopupTrigger);
            block12: for (int i = 0; i < s_mouseMotionListeners.size(); ++i) {
                MouseMotionListener mouseMotionListener = (MouseMotionListener)s_mouseMotionListeners.elementAt(i);
                switch (id) {
                    case 503: {
                        mouseMotionListener.mouseMoved(mouseEvent);
                        continue block12;
                    }
                    case 506: {
                        mouseMotionListener.mouseDragged(mouseEvent);
                    }
                }
            }
        }
        System.arraycopy(s_currCursorXY, 0, s_prevCursorXY, 0, 2);
        m_prevModifiers = currModifiers;
    }

    public static void addMouseListener(MouseListener mouseListener) {
        s_mouseListeners.addElement(mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        s_mouseListeners.removeElement(mouseListener);
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.addElement(mouseMotionListener);
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.removeElement(mouseMotionListener);
    }

    public static EventListener[] getListeners(Class listenerType) {
        if ((class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Toolkit.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).isAssignableFrom(listenerType)) {
            return (EventListener[])s_mouseListeners.toArray();
        }
        if ((class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = Toolkit.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener).isAssignableFrom(listenerType)) {
            return (EventListener[])s_mouseMotionListeners.toArray();
        }
        return null;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        try {
            System.loadLibrary("jni_toolkit");
            s_successfullyLoadedLibrary = true;
        }
        catch (UnsatisfiedLinkError ule) {
            s_successfullyLoadedLibrary = false;
        }
        s_source = new Label("edu.cmu.cs.stage3.io.toolkit.Toolkit");
        s_mouseListeners = new Vector();
        s_mouseMotionListeners = new Vector();
        m_prevCursorLocation = new Point();
        m_prevModifiers = 0;
        m_clickCount = 0;
        s_prevCursorXY = new int[]{0, 0};
        s_currCursorXY = new int[]{0, 0};
    }
}

