/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.media.effects;

import edu.cmu.cs.stage3.io.media.control.PanControl;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class Pan
implements Effect {
    Format inputFormat;
    Format outputFormat;
    Format[] inputFormats;
    Format[] outputFormats;
    PanControl control = new PanControl();

    public Pan() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 2, 0, 1, 32, -1.0, Format.byteArray)};
        this.outputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 2, 0, 1, 32, -1.0, Format.byteArray)};
    }

    public Format[] getSupportedInputFormats() {
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (this.matches(input, this.inputFormats) != null) {
            return new Format[]{this.matches(input, this.inputFormats).intersects(input)};
        }
        return new Format[0];
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (format == null || this.matches(format, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = this.matches(format, this.outputFormats).intersects(format);
        return this.outputFormat;
    }

    public int process(Buffer input, Buffer output) {
        byte[] inData = (byte[])input.getData();
        int inOffset = input.getOffset();
        int dataLength = input.getLength();
        byte[] outData = this.validateByteArraySize(output, dataLength);
        int outOffset = output.getOffset();
        double leftPan = 1.0 - Math.max(this.control.getPan(), 0.0);
        double rightPan = 1.0 + Math.min(this.control.getPan(), 0.0);
        int numSamples = dataLength / 2;
        for (int i = 0; i < numSamples / 2; ++i) {
            byte tempL = inData[inOffset++];
            byte tempH = inData[inOffset++];
            int sample = tempH << 8 | tempL & 0xFF;
            sample = (int)((double)sample * leftPan);
            outData[outOffset++] = (byte)(sample & 0xFF);
            outData[outOffset++] = (byte)(sample >> 8);
            tempL = inData[inOffset++];
            tempH = inData[inOffset++];
            sample = tempH << 8 | tempL & 0xFF;
            sample = (int)((double)sample * rightPan);
            outData[outOffset++] = (byte)(sample & 0xFF);
            outData[outOffset++] = (byte)(sample >> 8);
        }
        output.setFormat(this.outputFormat);
        output.setLength(dataLength);
        output.setOffset(0);
        return 0;
    }

    public String getName() {
        return "PanEffect";
    }

    public void close() {
    }

    public void open() {
    }

    public void reset() {
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!cls.isInstance(cs[i])) continue;
                Object object = cs[i];
                return object;
            }
            Object var4_7 = null;
            return var4_7;
        }
        catch (Exception e) {
            Object var3_5 = null;
            return var3_5;
        }
    }

    public Object[] getControls() {
        return new Object[]{this.control};
    }

    Format matches(Format in, Format[] outs) {
        for (int i = 0; i < outs.length; ++i) {
            if (!in.matches(outs[i])) continue;
            return outs[i];
        }
        return null;
    }

    private byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof byte[] && (typedArray = (byte[])objectArray).length >= newSize) {
            return typedArray;
        }
        typedArray = new byte[newSize];
        buffer.setData((Object)typedArray);
        return typedArray;
    }
}

