/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.media;

import java.io.IOException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class SeekableInputSourceStream
implements PullSourceStream,
Seekable {
    protected byte[] data;
    protected long location;
    protected ContentDescriptor descriptor;
    protected long size;

    public SeekableInputSourceStream(byte[] inputBytes, ContentDescriptor inputDescriptor) {
        this.data = inputBytes;
        this.location = 0L;
        this.descriptor = inputDescriptor;
        this.size = this.data.length;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        long bytesLeft = this.size - this.location;
        if (bytesLeft == (long)0) {
            return -1;
        }
        int intBytesLeft = (int)bytesLeft;
        int toRead = length;
        if (intBytesLeft < length) {
            toRead = intBytesLeft;
        }
        System.arraycopy(this.data, (int)this.location, buffer, offset, toRead);
        this.location += (long)toRead;
        return toRead;
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.descriptor;
    }

    public boolean endOfStream() {
        return this.location == this.size;
    }

    public long getContentLength() {
        return this.size;
    }

    public boolean willReadBlock() {
        return this.endOfStream();
    }

    public boolean isRandomAccess() {
        return true;
    }

    public long seek(long where) {
        this.location = where > this.size ? this.size : where;
        return this.location;
    }

    public long tell() {
        return this.location;
    }
}

