/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.media;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.io.media.MediaLockObserver;
import java.io.IOException;
import javax.media.Codec;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Renderer;
import javax.media.Time;
import javax.media.UnsupportedPlugInException;
import javax.media.protocol.DataSource;

public class MediaLock
implements ControllerListener {
    protected Processor m_player;
    private MediaLockObserver m_mediaLockObserver;
    private ControllerErrorEvent m_errorEvent;
    private boolean m_finished;

    public MediaLock(MediaLock ml) {
    }

    public MediaLock(DataSource dataSourceValue) {
        try {
            this.m_player = Manager.createProcessor((DataSource)dataSourceValue);
            this.m_player.addControllerListener((ControllerListener)this);
            this.m_player.configure();
            this.m_errorEvent = null;
            long startT = System.currentTimeMillis();
            while (this.m_player.getState() == 140 && this.m_errorEvent == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                if (System.currentTimeMillis() <= startT + (long)2000) continue;
                this.m_errorEvent = new ControllerErrorEvent((Controller)this.m_player);
                throw new RuntimeException("Timeout Configuring Player");
            }
            if (this.m_errorEvent == null && this.m_player.getState() == 180) {
                this.m_player.setContentDescriptor(null);
            }
            this.m_mediaLockObserver = null;
            this.m_finished = false;
        }
        catch (NoPlayerException npe) {
            npe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ControllerErrorEvent) {
            this.m_errorEvent = (ControllerErrorEvent)event;
        } else if (event instanceof EndOfMediaEvent) {
            this.m_finished = true;
        }
    }

    public double getTimeRemaining() {
        if (this.m_finished) {
            return 0.0;
        }
        if (this.m_player != null) {
            Time duration = this.m_player.getDuration();
            if (duration == null) {
                return Double.NaN;
            }
            if (duration.equals(Duration.DURATION_UNBOUNDED)) {
                return Double.POSITIVE_INFINITY;
            }
            Time mediaTime = this.m_player.getMediaTime();
            if (mediaTime == null) {
                return Double.NaN;
            }
            double timeRemaining = duration.getSeconds() - mediaTime.getSeconds();
            return timeRemaining;
        }
        return Double.NaN;
    }

    public boolean isFree() {
        return this.m_mediaLockObserver == null;
    }

    public boolean isLocked() {
        return this.m_mediaLockObserver != null;
    }

    public Processor getPlayer() {
        return this.m_player;
    }

    public void installCodec(Codec codec) {
        if (this.m_player.getState() == 180) {
            for (int i = 0; i < this.m_player.getTrackControls().length; ++i) {
                try {
                    this.m_player.getTrackControls()[i].setCodecChain(new Codec[]{codec});
                    continue;
                }
                catch (UnsupportedPlugInException upie) {
                    upie.printStackTrace();
                }
            }
        } else {
            System.err.println("Can't add Codec, Processor not in Configured state");
        }
    }

    public void setRenderer(Renderer renderer) {
        if (this.m_player.getState() == 180) {
            for (int i = 0; i < this.m_player.getTrackControls().length; ++i) {
                try {
                    this.m_player.getTrackControls()[i].setRenderer(renderer);
                    continue;
                }
                catch (UnsupportedPlugInException upie) {
                    upie.printStackTrace();
                }
            }
        } else {
            System.err.println("Can't set renderer, Processor not in Configured state");
        }
    }

    public Player prefetchAndLock(MediaLockObserver mediaLockObserver) {
        this.m_player.prefetch();
        return this.lock(mediaLockObserver);
    }

    public Player lock(MediaLockObserver mediaLockObserver) {
        this.m_mediaLockObserver = mediaLockObserver;
        if (this.m_player.getState() < 300) {
            this.m_player.realize();
            long startT = System.currentTimeMillis();
            while (this.m_player.getState() == 200 && this.m_errorEvent == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                if (System.currentTimeMillis() <= startT + (long)2000) continue;
                this.m_errorEvent = new ControllerErrorEvent((Controller)this.m_player);
                throw new RuntimeException("Timeout Realizing Player");
            }
        }
        if (this.m_errorEvent == null && this.m_player.getState() >= 300) {
            this.m_player.setMediaTime(new Time(0L));
            this.m_finished = false;
            return this.m_player;
        }
        throw new RuntimeException("could not realize player: ".concat(String.valueOf(String.valueOf(this.m_player))));
    }

    public void release() {
        if (this.m_mediaLockObserver != null) {
            this.m_mediaLockObserver.mediaLockLost(this);
        } else {
            Element.warnln((Object)"TODO: handle releasing unlocked player.");
        }
        this.m_mediaLockObserver = null;
    }
}

