/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.media;

import edu.cmu.cs.stage3.io.media.StreamDataSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;

public class MediaIO {
    private static final String[] s_codecNames = new String[]{"audio.mpeg", "audio.x_wav"};
    private static final String[] s_wavExtensions = new String[]{"wav"};
    private static final String[] s_mp3Extensions = new String[]{"mp3"};

    public static String[] getCodecNames() {
        return s_codecNames;
    }

    public static String[] getExtensionsForCodec(String codecName) {
        if (codecName.equals("audio.mpeg")) {
            return s_mp3Extensions;
        }
        if (codecName.equals("audio.x_wav")) {
            return s_wavExtensions;
        }
        return null;
    }

    public static String mapExtensionToCodecName(String extension) {
        String[] codecNames = MediaIO.getCodecNames();
        for (int i = 0; i < codecNames.length; ++i) {
            String[] extensions = MediaIO.getExtensionsForCodec(codecNames[i]);
            for (int j = 0; j < extensions.length; ++j) {
                if (!extensions[j].equalsIgnoreCase(extension)) continue;
                return codecNames[i];
            }
        }
        return null;
    }

    public static DataSource load(String codec, InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        return new StreamDataSource(bufferedInputStream, codec);
    }

    public static void store(String codec, OutputStream outputStream, DataSource inSource) throws IOException {
        byte[] bytes = new byte[1];
        PullSourceStream[] inStreams = null;
        inSource.connect();
        inSource.start();
        if (inSource instanceof PullDataSource) {
            inStreams = ((PullDataSource)inSource).getStreams();
        } else if (inSource instanceof PullBufferDataSource) {
            inStreams = ((PullBufferDataSource)inSource).getStreams();
        } else if (inSource instanceof PushDataSource) {
            inStreams = ((PushDataSource)inSource).getStreams();
        } else if (inSource instanceof PushBufferDataSource) {
            inStreams = ((PushBufferDataSource)inSource).getStreams();
        }
        boolean done = false;
        while (!done) {
            boolean readable = true;
            PullSourceStream stream = inStreams[0];
            if (stream instanceof PullSourceStream) {
                readable = stream.willReadBlock();
            } else if (stream instanceof PullBufferStream) {
                readable = ((PullBufferStream)stream).willReadBlock();
            }
            if (readable) {
                // empty if block
            }
            int numread = -1;
            if (stream instanceof PullSourceStream) {
                numread = stream.read(bytes, 0, bytes.length);
            } else if (stream instanceof PushSourceStream) {
                numread = ((PushSourceStream)stream).read(bytes, 0, bytes.length);
            }
            if (numread != -1) {
                outputStream.write(bytes, 0, numread);
                continue;
            }
            done = true;
        }
        inSource.stop();
        outputStream.flush();
    }
}

