/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.joystick;

import edu.cmu.cs.stage3.io.joystick.event.JoystickEvent;
import edu.cmu.cs.stage3.io.joystick.event.JoystickListener;
import java.util.Vector;

public class Joystick {
    private static boolean[] m_isPressedPrev;
    private static boolean[] m_isPressedCurr;
    private static Vector s_joystickListeners;
    private static JoystickListener[] s_joystickListenerArray;
    private static JoystickThread s_joystickThread;

    public static native void initialize();

    public static native void terminate();

    private static native void updateButtonState(boolean[] var0);

    public static void invokeJoystickListenersIfNecessary() {
        Joystick.updateButtonState(m_isPressedCurr);
        JoystickListener[] jls = Joystick.getJoystickListeners();
        long when = System.currentTimeMillis();
        int n = Math.min(m_isPressedPrev.length, m_isPressedCurr.length);
        for (int i = 0; i < n; ++i) {
            int j;
            JoystickEvent joystickEvent;
            if (m_isPressedPrev[i]) {
                if (m_isPressedCurr[i]) continue;
                joystickEvent = new JoystickEvent(s_joystickThread, when, i);
                for (j = 0; j < jls.length; ++j) {
                    jls[j].joystickButtonReleased(joystickEvent);
                }
                continue;
            }
            if (!m_isPressedCurr[i]) continue;
            joystickEvent = new JoystickEvent(s_joystickThread, when, i);
            for (j = 0; j < jls.length; ++j) {
                jls[j].joystickButtonPressed(joystickEvent);
            }
        }
        System.arraycopy(m_isPressedCurr, 0, m_isPressedPrev, 0, n);
    }

    public static void addJoystickListener(JoystickListener joystickListener) {
        s_joystickListeners.addElement(joystickListener);
        Joystick.startIfNecessary();
    }

    public static void removeJoystickListener(JoystickListener joystickListener) {
        s_joystickListeners.removeElement(joystickListener);
    }

    public static JoystickListener[] getJoystickListeners() {
        if (s_joystickListenerArray == null) {
            s_joystickListenerArray = new JoystickListener[s_joystickListeners.size()];
            s_joystickListeners.copyInto(s_joystickListenerArray);
        }
        return s_joystickListenerArray;
    }

    private static void startIfNecessary() {
        if (s_joystickThread == null) {
            s_joystickThread = new JoystickThread();
            s_joystickThread.start();
        }
    }

    static {
        System.loadLibrary("jni_joystick");
        m_isPressedPrev = new boolean[]{false, false, false, false};
        m_isPressedCurr = new boolean[]{false, false, false, false};
        s_joystickListeners = new Vector();
        s_joystickListenerArray = null;
        s_joystickThread = null;
    }

    private static class JoystickThread
    extends Thread {
        private boolean m_continue;

        private JoystickThread() {
        }

        public void safeStop() {
            this.m_continue = false;
        }

        public void run() {
            Joystick.initialize();
            this.m_continue = true;
            while (this.m_continue) {
                Joystick.invokeJoystickListenersIfNecessary();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Joystick.terminate();
        }
    }
}

