/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.ImageCodec;
import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import edu.cmu.cs.stage3.io.image.codec.RasterFactory;
import edu.cmu.cs.stage3.io.image.codec.SeekableStream;
import edu.cmu.cs.stage3.io.image.codec.SimpleRenderedImage;
import edu.cmu.cs.stage3.io.image.codec.TIFFDecodeParam;
import edu.cmu.cs.stage3.io.image.codec.TIFFDirectory;
import edu.cmu.cs.stage3.io.image.codec.TIFFFaxDecoder;
import edu.cmu.cs.stage3.io.image.codec.TIFFField;
import edu.cmu.cs.stage3.io.image.codec.TIFFLZWDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class TIFFImage
extends SimpleRenderedImage {
    private static final boolean DEBUG = true;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    char[] bitsPerSample;
    int samplesPerPixel;
    int extraSamples;
    int compression;
    byte[] palette;
    int bands;
    char[] sampleFormat;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    boolean decodePaletteAsShorts;
    boolean isBigEndian;
    int predictor;
    int image_type;
    int dataType;
    private static final int TYPE_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TYPE_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TYPE_GREYSCALE_WHITE_IS_ZERO = 2;
    private static final int TYPE_GREYSCALE_BLACK_IS_ZERO = 3;
    private static final int TYPE_RGB = 4;
    private static final int TYPE_ARGB_PRE = 5;
    private static final int TYPE_ARGB = 6;
    private static final int TYPE_ORGB = 7;
    private static final int TYPE_RGB_EXTRA = 8;
    private static final int TYPE_PALETTE = 9;
    private static final int TYPE_TRANS = 10;
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_PACKBITS = 32773;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;
    private WritableRaster tile00 = null;

    public TIFFImage(SeekableStream stream, TIFFDecodeParam param, int directory) throws IOException {
        this.stream = stream;
        if (param == null) {
            param = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = param.getDecodePaletteAsShorts();
        TIFFDirectory dir = new TIFFDirectory(stream, directory);
        this.isBigEndian = dir.isBigEndian();
        this.minY = 0;
        this.minX = 0;
        this.width = (int)dir.getFieldAsLong(256);
        this.height = (int)dir.getFieldAsLong(257);
        int photometric_interp = (int)dir.getFieldAsLong(262);
        TIFFField bitsField = dir.getField(258);
        if (bitsField == null) {
            this.bitsPerSample = new char[1];
            this.bitsPerSample[0] = '\u0001';
        } else {
            this.bitsPerSample = bitsField.getAsChars();
        }
        for (int i = 1; i < this.bitsPerSample.length; ++i) {
            if (this.bitsPerSample[i] == this.bitsPerSample[1]) continue;
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder19"));
        }
        TIFFField sfield = dir.getField(277);
        this.samplesPerPixel = sfield == null ? 1 : (int)sfield.getAsLong(0);
        TIFFField efield = dir.getField(338);
        this.extraSamples = efield == null ? 0 : (int)efield.getAsLong(0);
        TIFFField sampleFormatField = dir.getField(339);
        if (sampleFormatField != null) {
            this.sampleFormat = sampleFormatField.getAsChars();
            for (int l = 1; l < this.sampleFormat.length; ++l) {
                if (this.sampleFormat[l] == this.sampleFormat[0]) continue;
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder20"));
            }
        } else {
            this.sampleFormat = new char[]{'\u0001'};
        }
        if (this.sampleFormat[0] == '\u0001' || this.sampleFormat[0] == '\u0004') {
            if (this.bitsPerSample[0] == '\b') {
                this.dataType = 0;
            } else if (this.bitsPerSample[0] == '\u0010') {
                this.dataType = 1;
            } else if (this.bitsPerSample[0] == ' ') {
                this.dataType = 3;
            }
        } else if (this.sampleFormat[0] == '\u0002') {
            if (this.bitsPerSample[0] == '\u0001' || this.bitsPerSample[0] == '\u0004' || this.bitsPerSample[0] == '\b') {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder21"));
            }
            if (this.bitsPerSample[0] == '\u0010') {
                this.dataType = 2;
            } else if (this.bitsPerSample[0] == ' ') {
                this.dataType = 3;
            }
        } else if (this.sampleFormat[0] == '\u0003') {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder22"));
        }
        if (dir.getField(322) != null) {
            this.tileWidth = (int)dir.getFieldAsLong(322);
            this.tileHeight = (int)dir.getFieldAsLong(323);
            this.tileOffsets = dir.getField(324).getAsLongs();
            this.tileByteCounts = dir.getField(325).getAsLongs();
        } else {
            this.tileWidth = this.width;
            TIFFField field = dir.getField(278);
            if (field == null) {
                this.tileHeight = this.height;
            } else {
                long l = field.getAsLong(0);
                long infinity = 1L;
                this.tileHeight = l == (infinity = (infinity << 32) - (long)1) ? this.height : (int)l;
            }
            TIFFField tileOffsetsField = dir.getField(273);
            if (tileOffsetsField == null) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder11"));
            }
            this.tileOffsets = tileOffsetsField.getAsLongs();
            TIFFField tileByteCountsField = dir.getField(279);
            if (tileByteCountsField == null) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder12"));
            }
            this.tileByteCounts = tileByteCountsField.getAsLongs();
        }
        TIFFField fillOrderField = dir.getField(266);
        this.fillOrder = fillOrderField != null ? fillOrderField.getAsInt(0) : 1;
        switch (photometric_interp) {
            case 0: {
                byte[] g;
                byte[] r;
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0001') {
                    this.image_type = 0;
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
                    r = new byte[]{-1, 0};
                    g = new byte[]{-1, 0};
                    byte[] b = new byte[]{-1, 0};
                    this.colorModel = new IndexColorModel(1, 2, r, g, b);
                    break;
                }
                this.image_type = 2;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 4);
                    this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, false);
                    break;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, false);
                    break;
                }
                if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                throw new IllegalArgumentException(JaiI18N.getString("TIFFImageDecoder14"));
            }
            case 1: {
                byte[] g;
                byte[] r;
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0001') {
                    this.image_type = 1;
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
                    r = new byte[]{0, -1};
                    g = new byte[]{0, -1};
                    byte[] b = new byte[]{0, -1};
                    this.colorModel = new IndexColorModel(1, 2, r, g, b);
                    break;
                }
                this.image_type = 3;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 4);
                    this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, true);
                    break;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                throw new IllegalArgumentException(JaiI18N.getString("TIFFImageDecoder14"));
            }
            case 2: {
                this.bands = this.samplesPerPixel;
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                } else if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                } else {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder15"));
                }
                if (this.samplesPerPixel < 3) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder1"));
                }
                if (this.samplesPerPixel == 3) {
                    this.image_type = 4;
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                if (this.samplesPerPixel == 4) {
                    if (this.extraSamples == 0) {
                        this.image_type = 7;
                        this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, false, 1);
                        break;
                    }
                    if (this.extraSamples == 1) {
                        this.image_type = 5;
                        this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, true, 3);
                        break;
                    }
                    if (this.extraSamples != 2) break;
                    this.image_type = 6;
                    this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, false, 2);
                    break;
                }
                this.image_type = 8;
                int[] bandOffsets = new int[this.bands];
                for (int i = 0; i < this.bands; ++i) {
                    bandOffsets[i] = i;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands, this.bands * this.tileWidth, bandOffsets);
                    this.colorModel = null;
                    break;
                }
                if (this.bitsPerSample[0] != '\u0010') break;
                this.sampleModel = new PixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands, this.bands * this.tileWidth, bandOffsets);
                this.colorModel = null;
                break;
            }
            case 3: {
                this.image_type = 9;
                TIFFField cfield = dir.getField(320);
                if (cfield == null) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder2"));
                }
                this.colormap = cfield.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.bands = 3;
                    if (this.bitsPerSample[0] != '\u0004' && this.bitsPerSample[0] != '\b' && this.bitsPerSample[0] != '\u0010') {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder13"));
                    }
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.bitsPerSample[0]);
                } else if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                } else if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(1, this.tileWidth, this.tileHeight, this.bands);
                } else {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder13"));
                }
                int bandLength = this.colormap.length / 3;
                byte[] r = new byte[bandLength];
                byte[] g = new byte[bandLength];
                byte[] b = new byte[bandLength];
                int gIndex = bandLength;
                int bIndex = bandLength * 2;
                if (this.dataType == 2) {
                    for (int i = 0; i < bandLength; ++i) {
                        r[i] = param.decodeSigned16BitsTo8Bits((short)this.colormap[i]);
                        g[i] = param.decodeSigned16BitsTo8Bits((short)this.colormap[gIndex + i]);
                        b[i] = param.decodeSigned16BitsTo8Bits((short)this.colormap[bIndex + i]);
                    }
                } else {
                    for (int i = 0; i < bandLength; ++i) {
                        r[i] = param.decode16BitsTo8Bits(this.colormap[i] & 0xFFFF);
                        g[i] = param.decode16BitsTo8Bits(this.colormap[gIndex + i] & 0xFFFF);
                        b[i] = param.decode16BitsTo8Bits(this.colormap[bIndex + i] & 0xFFFF);
                    }
                }
                this.colorModel = new IndexColorModel((int)this.bitsPerSample[0], bandLength, r, g, b);
                break;
            }
            case 4: {
                this.image_type = 10;
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder3"));
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder4"));
            }
        }
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.bands;
        TIFFField compField = dir.getField(259);
        if (compField != null) {
            this.compression = compField.getAsInt(0);
            if (this.compression == 3) {
                TIFFField t4OptionsField = dir.getField(292);
                this.tiffT4Options = t4OptionsField != null ? t4OptionsField.getAsLong(0) : 0L;
            }
            if (this.compression == 4) {
                TIFFField t6OptionsField = dir.getField(293);
                this.tiffT6Options = t6OptionsField != null ? t6OptionsField.getAsLong(0) : 0L;
            }
            if (this.compression == 2 || this.compression == 3 || this.compression == 4) {
                this.decoder = new TIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileHeight);
            }
            if (this.compression == 5) {
                TIFFField predictorField = dir.getField(317);
                if (predictorField == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = predictorField.getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder16"));
                    }
                    if (this.predictor == 2 && this.bitsPerSample[0] != '\b') {
                        throw new RuntimeException(String.valueOf(String.valueOf(this.bitsPerSample[0])).concat(String.valueOf(String.valueOf(JaiI18N.getString("TIFFImageDecoder17")))));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, this.samplesPerPixel);
            }
            if (this.compression != 1 && this.compression != 32773 && this.compression != 2 && this.compression != 3 && this.compression != 4 && this.compression != 5) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder0"));
            }
        } else {
            this.compression = 1;
        }
    }

    public TIFFDirectory getPrivateIFD(long offset) throws IOException {
        return new TIFFDirectory(this.stream, offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Raster getTile(int tileX, int tileY) {
        if (tileX == 0 && tileY == 0 && this.tile00 != null) {
            return this.tile00;
        }
        if (tileX < 0 || tileX >= this.tilesX || tileY < 0 || tileY >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFImageDecoder5"));
        }
        byte[] bdata = null;
        short[] sdata = null;
        Object idata = null;
        DataBuffer buffer = this.sampleModel.createDataBuffer();
        int dataType = this.sampleModel.getDataType();
        if (dataType == 0) {
            bdata = ((DataBufferByte)buffer).getData();
        } else if (dataType == 1) {
            sdata = ((DataBufferUShort)buffer).getData();
        } else if (dataType == 2) {
            sdata = ((DataBufferShort)buffer).getData();
        }
        WritableRaster tile = RasterFactory.createWritableRaster(this.sampleModel, buffer, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
        long save_offset = 0L;
        try {
            save_offset = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[tileY * this.tilesX + tileX]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
        }
        int byteCount = (int)this.tileByteCounts[tileY * this.tilesX + tileX];
        Rectangle tileRect = new Rectangle(this.tileXToX(tileX), this.tileYToY(tileY), this.tileWidth, this.tileHeight);
        Rectangle newRect = tileRect.intersection(this.getBounds());
        int unitsInThisTile = newRect.width * newRect.height * this.bands;
        byte[] data = new byte[byteCount];
        switch (this.image_type) {
            case 0: 
            case 1: {
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(data, 0, byteCount);
                        int bytesInThisTile = newRect.width % 8 == 0 ? newRect.width / 8 * newRect.height : (newRect.width / 8 + 1) * newRect.height;
                        this.decodePackbits(data, bytesInThisTile, bdata);
                    } else if (this.compression == 5) {
                        this.stream.readFully(data, 0, byteCount);
                        this.lzwDecoder.decode(data, bdata, newRect.height);
                    } else if (this.compression == 2) {
                        this.stream.readFully(data, 0, byteCount);
                        this.decoder.decode1D(bdata, data, newRect.x, newRect.height);
                    } else if (this.compression == 3) {
                        this.stream.readFully(data, 0, byteCount);
                        this.decoder.decode2D(bdata, data, newRect.x, newRect.height, this.tiffT4Options);
                    } else if (this.compression == 4) {
                        this.stream.readFully(data, 0, byteCount);
                        this.decoder.decodeT6(bdata, data, newRect.x, newRect.height, this.tiffT6Options);
                    } else if (this.compression == 1) {
                        this.stream.readFully(bdata, 0, byteCount);
                    }
                    this.stream.seek(save_offset);
                    break;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 2: 
            case 3: {
                try {
                    if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            int bytesInThisTile = unitsInThisTile * 2;
                            byte[] byteArray = new byte[bytesInThisTile];
                            this.decodePackbits(data, bytesInThisTile, byteArray);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            byte[] byteArray = new byte[unitsInThisTile * 2];
                            this.lzwDecoder.decode(data, byteArray, newRect.height);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else if (this.compression == 1) {
                            this.readShorts(byteCount / 2, sdata);
                        }
                        if (this.image_type == 2) {
                            if (dataType == 1) {
                                for (int l = 0; l < sdata.length; ++l) {
                                    sdata[l] = (short)(65535 - sdata[l]);
                                }
                            } else if (dataType == 2) {
                                for (int l = 0; l < sdata.length; ++l) {
                                    sdata[l] = ~sdata[l];
                                }
                            }
                        }
                    } else if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            this.decodePackbits(data, unitsInThisTile, bdata);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            this.lzwDecoder.decode(data, bdata, newRect.height);
                        } else if (this.compression == 1) {
                            this.stream.readFully(bdata, 0, byteCount);
                        }
                    } else if (this.bitsPerSample[0] == '\u0004') {
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            int bytesInThisTile = newRect.width % 8 == 0 ? newRect.width / 2 * newRect.height : (newRect.width / 2 + 1) * newRect.height;
                            this.decodePackbits(data, bytesInThisTile, bdata);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            this.lzwDecoder.decode(data, bdata, newRect.height);
                        } else {
                            this.stream.readFully(bdata, 0, byteCount);
                        }
                    }
                    this.stream.seek(save_offset);
                    break;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 4: {
                try {
                    if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 1) {
                            this.stream.readFully(bdata, 0, byteCount);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            this.lzwDecoder.decode(data, bdata, newRect.height);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(data, 0, byteCount);
                            this.decodePackbits(data, unitsInThisTile, bdata);
                        }
                        for (int i = 0; i < unitsInThisTile; i += 3) {
                            byte bswap = bdata[i];
                            bdata[i] = bdata[i + 2];
                            bdata[i + 2] = bswap;
                        }
                    } else if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 1) {
                            this.readShorts(byteCount / 2, sdata);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            byte[] byteArray = new byte[unitsInThisTile * 2];
                            this.lzwDecoder.decode(data, byteArray, newRect.height);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(data, 0, byteCount);
                            int bytesInThisTile = unitsInThisTile * 2;
                            byte[] byteArray = new byte[bytesInThisTile];
                            this.decodePackbits(data, bytesInThisTile, byteArray);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        }
                        for (int i = 0; i < unitsInThisTile; i += 3) {
                            short sswap = sdata[i];
                            sdata[i] = sdata[i + 2];
                            sdata[i + 2] = sswap;
                        }
                    }
                    this.stream.seek(save_offset);
                    break;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 5: 
            case 6: 
            case 7: {
                try {
                    if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 1) {
                            this.stream.readFully(bdata, 0, byteCount);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            this.lzwDecoder.decode(data, bdata, newRect.height);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(data, 0, byteCount);
                            this.decodePackbits(data, unitsInThisTile, bdata);
                        }
                        for (int i = 0; i < unitsInThisTile; i += 4) {
                            byte bswap = bdata[i];
                            bdata[i] = bdata[i + 3];
                            bdata[i + 3] = bswap;
                            bswap = bdata[i + 1];
                            bdata[i + 1] = bdata[i + 2];
                            bdata[i + 2] = bswap;
                        }
                    } else if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 1) {
                            this.readShorts(byteCount / 2, sdata);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            byte[] byteArray = new byte[unitsInThisTile * 2];
                            this.lzwDecoder.decode(data, byteArray, newRect.height);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(data, 0, byteCount);
                            int bytesInThisTile = unitsInThisTile * 2;
                            byte[] byteArray = new byte[bytesInThisTile];
                            this.decodePackbits(data, bytesInThisTile, byteArray);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        }
                        for (int i = 0; i < unitsInThisTile; i += 4) {
                            short sswap = sdata[i];
                            sdata[i] = sdata[i + 3];
                            sdata[i + 3] = sswap;
                            sswap = sdata[i + 1];
                            sdata[i + 1] = sdata[i + 2];
                            sdata[i + 2] = sswap;
                        }
                    }
                    this.stream.seek(save_offset);
                    break;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 8: {
                try {
                    if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 1) {
                            this.stream.readFully(bdata, 0, byteCount);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            this.lzwDecoder.decode(data, bdata, newRect.height);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(data, 0, byteCount);
                            this.decodePackbits(data, unitsInThisTile, bdata);
                        }
                    } else if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 1) {
                            this.readShorts(byteCount / 2, sdata);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            byte[] byteArray = new byte[unitsInThisTile * 2];
                            this.lzwDecoder.decode(data, byteArray, newRect.height);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(data, 0, byteCount);
                            int bytesInThisTile = unitsInThisTile * 2;
                            byte[] byteArray = new byte[bytesInThisTile];
                            this.decodePackbits(data, bytesInThisTile, byteArray);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        }
                    }
                    this.stream.seek(save_offset);
                    break;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 9: {
                if (this.bitsPerSample[0] == '\u0010') {
                    if (this.decodePaletteAsShorts) {
                        short[] tempData = null;
                        int unitsBeforeLookup = unitsInThisTile / 3;
                        int entries = unitsBeforeLookup * 2;
                        try {
                            byte[] byteArray;
                            if (this.compression == 32773) {
                                this.stream.readFully(data, 0, byteCount);
                                byteArray = new byte[entries];
                                this.decodePackbits(data, entries, byteArray);
                                tempData = new short[unitsBeforeLookup];
                                this.interpretBytesAsShorts(byteArray, tempData, unitsBeforeLookup);
                            } else if (this.compression == 5) {
                                this.stream.readFully(data, 0, byteCount);
                                byteArray = new byte[entries];
                                this.lzwDecoder.decode(data, byteArray, newRect.height);
                                tempData = new short[unitsBeforeLookup];
                                this.interpretBytesAsShorts(byteArray, tempData, unitsBeforeLookup);
                            } else if (this.compression == 1) {
                                tempData = new short[byteCount / 2];
                                this.readShorts(byteCount / 2, tempData);
                            }
                            this.stream.seek(save_offset);
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                        }
                        if (dataType == 1) {
                            int count = 0;
                            int len = this.colormap.length / 3;
                            int len2 = len * 2;
                            for (int i = 0; i < unitsBeforeLookup; ++i) {
                                int lookup = tempData[i] & 0xFFFF;
                                char cmapValue = this.colormap[lookup + len2];
                                sdata[count++] = (short)(cmapValue & 0xFFFF);
                                cmapValue = this.colormap[lookup + len];
                                sdata[count++] = (short)(cmapValue & 0xFFFF);
                                cmapValue = this.colormap[lookup];
                                sdata[count++] = (short)(cmapValue & 0xFFFF);
                            }
                        } else {
                            if (dataType != 2) break;
                            int count = 0;
                            int len = this.colormap.length / 3;
                            int len2 = len * 2;
                            for (int i = 0; i < unitsBeforeLookup; ++i) {
                                int lookup = tempData[i] & 0xFFFF;
                                char cmapValue = this.colormap[lookup + len2];
                                sdata[count++] = (short)cmapValue;
                                cmapValue = this.colormap[lookup + len];
                                sdata[count++] = (short)cmapValue;
                                cmapValue = this.colormap[lookup];
                                sdata[count++] = (short)cmapValue;
                            }
                        }
                        break;
                    }
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            int bytesInThisTile = unitsInThisTile * 2;
                            byte[] byteArray = new byte[bytesInThisTile];
                            this.decodePackbits(data, bytesInThisTile, byteArray);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            byte[] byteArray = new byte[unitsInThisTile * 2];
                            this.lzwDecoder.decode(data, byteArray, newRect.height);
                            this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                        } else if (this.compression == 1) {
                            this.readShorts(byteCount / 2, sdata);
                        }
                        this.stream.seek(save_offset);
                        break;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                    }
                }
                if (this.bitsPerSample[0] == '\b') {
                    if (this.decodePaletteAsShorts) {
                        byte[] tempData = null;
                        int unitsBeforeLookup = unitsInThisTile / 3;
                        try {
                            if (this.compression == 32773) {
                                this.stream.readFully(data, 0, byteCount);
                                tempData = new byte[unitsBeforeLookup];
                                this.decodePackbits(data, unitsBeforeLookup, tempData);
                            } else if (this.compression == 5) {
                                this.stream.readFully(data, 0, byteCount);
                                tempData = new byte[unitsBeforeLookup];
                                this.lzwDecoder.decode(data, tempData, newRect.height);
                            } else if (this.compression == 1) {
                                tempData = new byte[byteCount];
                                this.stream.readFully(tempData, 0, byteCount);
                            }
                            this.stream.seek(save_offset);
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                        }
                        int count = 0;
                        int len = this.colormap.length / 3;
                        int len2 = len * 2;
                        for (int i = 0; i < unitsBeforeLookup; ++i) {
                            int lookup = tempData[i] & 0xFF;
                            char cmapValue = this.colormap[lookup + len2];
                            sdata[count++] = (short)(cmapValue & 0xFFFF);
                            cmapValue = this.colormap[lookup + len];
                            sdata[count++] = (short)(cmapValue & 0xFFFF);
                            cmapValue = this.colormap[lookup];
                            sdata[count++] = (short)(cmapValue & 0xFFFF);
                        }
                        break;
                    }
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            this.decodePackbits(data, unitsInThisTile, bdata);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            this.lzwDecoder.decode(data, bdata, newRect.height);
                        } else if (this.compression == 1) {
                            this.stream.readFully(bdata, 0, byteCount);
                        }
                        this.stream.seek(save_offset);
                        break;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                    }
                }
                if (this.bitsPerSample[0] != '\u0004') throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder7"));
                int padding = newRect.width % 2 == 0 ? 0 : 1;
                int bytesPostDecoding = (newRect.width / 2 + padding) * newRect.height;
                if (this.decodePaletteAsShorts) {
                    byte[] tempData = null;
                    try {
                        this.stream.readFully(data, 0, byteCount);
                        this.stream.seek(save_offset);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                    }
                    if (this.compression == 32773) {
                        tempData = new byte[bytesPostDecoding];
                        this.decodePackbits(data, bytesPostDecoding, tempData);
                    } else if (this.compression == 5) {
                        tempData = new byte[bytesPostDecoding];
                        this.lzwDecoder.decode(data, tempData, newRect.height);
                    } else if (this.compression == 1) {
                        tempData = data;
                    }
                    int bytes = unitsInThisTile / 3;
                    data = new byte[bytes];
                    int srcCount = 0;
                    int dstCount = 0;
                    for (int j = 0; j < newRect.height; ++j) {
                        for (int i = 0; i < newRect.width / 2; ++i) {
                            data[dstCount++] = (byte)((tempData[srcCount] & 0xF0) >> 4);
                            data[dstCount++] = (byte)(tempData[srcCount++] & 0xF);
                        }
                        if (padding != 1) continue;
                        data[dstCount++] = (byte)((tempData[srcCount++] & 0xF0) >> 4);
                    }
                    int len = this.colormap.length / 3;
                    int len2 = len * 2;
                    int count = 0;
                    for (int i = 0; i < bytes; ++i) {
                        int lookup = data[i] & 0xFF;
                        char cmapValue = this.colormap[lookup + len2];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup + len];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                    }
                    break;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(data, 0, byteCount);
                        this.decodePackbits(data, bytesPostDecoding, bdata);
                    } else if (this.compression == 5) {
                        this.stream.readFully(data, 0, byteCount);
                        this.lzwDecoder.decode(data, bdata, newRect.height);
                    } else if (this.compression == 1) {
                        this.stream.readFully(bdata, 0, byteCount);
                    }
                    this.stream.seek(save_offset);
                    break;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 10: {
                break;
            }
        }
        if (tileX != 0 || tileY != 0) return tile;
        this.tile00 = tile;
        return tile;
    }

    private void readShorts(int shortCount, short[] shortArray) {
        int byteCount = 2 * shortCount;
        byte[] byteArray = new byte[byteCount];
        try {
            this.stream.readFully(byteArray, 0, byteCount);
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
        }
        this.interpretBytesAsShorts(byteArray, shortArray, shortCount);
    }

    private void interpretBytesAsShorts(byte[] byteArray, short[] shortArray, int shortCount) {
        if (this.isBigEndian) {
            for (int i = 0; i < shortCount; ++i) {
                int j = 2 * i;
                int firstByte = byteArray[j] & 0xFF;
                int secondByte = byteArray[j + 1] & 0xFF;
                shortArray[i] = (short)((firstByte << 8) + secondByte);
            }
        } else {
            for (int i = 0; i < shortCount; ++i) {
                int j = 2 * i;
                int firstByte = byteArray[j] & 0xFF;
                int secondByte = byteArray[j + 1] & 0xFF;
                shortArray[i] = (short)((secondByte << 8) + firstByte);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] decodePackbits(byte[] data, int arraySize, byte[] dst) {
        if (dst == null) {
            dst = new byte[arraySize];
        }
        int srcCount = 0;
        int dstCount = 0;
        try {
            block2: while (dstCount < arraySize) {
                int i;
                byte b;
                if ((b = data[srcCount++]) >= 0 && b <= 127) {
                    i = 0;
                    while (true) {
                        if (i >= b + 1) continue block2;
                        dst[dstCount++] = data[srcCount++];
                        ++i;
                    }
                }
                if (b <= -1 && b >= -127) {
                    byte repeat = data[srcCount++];
                    i = 0;
                    while (true) {
                        if (i >= -b + 1) continue block2;
                        dst[dstCount++] = repeat;
                        ++i;
                    }
                }
                ++srcCount;
            }
            return dst;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder10"));
        }
    }

    private ComponentColorModel createAlphaComponentColorModel(int dataType, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency) {
        ComponentColorModel ccm = null;
        int[][] RGBBits = new int[][]{{8, 8, 8, 8}, {16, 16, 16, 16}, {16, 16, 16, 16}};
        RGBBits[2] = new int[]{32, 32, 32, 32};
        ccm = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits[dataType], hasAlpha, isAlphaPremultiplied, transparency, dataType);
        return ccm;
    }

    static {
        DEBUG = true;
        TYPE_BILEVEL_WHITE_IS_ZERO = 0;
        TYPE_BILEVEL_BLACK_IS_ZERO = 1;
        TYPE_GREYSCALE_WHITE_IS_ZERO = 2;
        TYPE_GREYSCALE_BLACK_IS_ZERO = 3;
        TYPE_RGB = 4;
        TYPE_ARGB_PRE = 5;
        TYPE_ARGB = 6;
        TYPE_ORGB = 7;
        TYPE_RGB_EXTRA = 8;
        TYPE_PALETTE = 9;
        TYPE_TRANS = 10;
        COMP_NONE = 1;
        COMP_FAX_G3_1D = 2;
        COMP_FAX_G3_2D = 3;
        COMP_FAX_G4_2D = 4;
        COMP_LZW = 5;
        COMP_PACKBITS = 32773;
    }
}

