/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import edu.cmu.cs.stage3.io.image.codec.SimpleRenderedImage;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class JPEGImage
extends SimpleRenderedImage {
    private BufferedImage image = null;

    public JPEGImage(InputStream stream) {
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)stream);
        try {
            this.image = decoder.decodeAsBufferedImage();
        }
        catch (ImageFormatException e) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder1"));
        }
        catch (IOException e) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder2"));
        }
        this.minX = 0;
        this.minY = 0;
        this.tileWidth = this.width = this.image.getWidth();
        this.tileHeight = this.height = this.image.getHeight();
        if (!(this.image.getSampleModel() instanceof ComponentSampleModel)) {
            int type = -1;
            int numBands = this.image.getSampleModel().getNumBands();
            if (numBands == 1) {
                type = 10;
            } else if (numBands == 3) {
                type = 5;
            } else if (numBands == 4) {
                type = 6;
            } else {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder3"));
            }
            BufferedImage bi = new BufferedImage(this.width, this.height, type);
            Graphics2D g = bi.createGraphics();
            g.drawRenderedImage(this.image, new AffineTransform());
            this.image = bi;
        }
        this.sampleModel = this.image.getSampleModel();
        this.colorModel = this.image.getColorModel();
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGImageDecoder4"));
        }
        return this.image.getTile(0, 0);
    }
}

