/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.GIFImageSource;
import edu.cmu.cs.stage3.io.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageDecoderImpl;
import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;

public class GIFImageDecoder
extends ImageDecoderImpl {
    BufferedImage bufferedImage = null;

    public GIFImageDecoder(InputStream input, ImageDecodeParam param) {
        super(input, param);
    }

    private synchronized RenderedImage decode() throws IOException {
        if (this.bufferedImage == null) {
            GIFImageSource source = new GIFImageSource(this.input);
            Image image = Toolkit.getDefaultToolkit().createImage(source);
            MediaTracker tracker = new MediaTracker(new Canvas());
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(JaiI18N.getString("GIFImageDecoder0"));
            }
            if (tracker.isErrorID(0)) {
                throw new RuntimeException(JaiI18N.getString("GIFImageDecoder1"));
            }
            tracker.removeImage(image);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            this.bufferedImage = new BufferedImage(width, height, 5);
            Graphics g = this.bufferedImage.getGraphics();
            g.drawImage(image, 0, 0, null);
        }
        return this.bufferedImage;
    }

    public RenderedImage decodeAsRenderedImage(int page) throws IOException {
        if (page != 0) {
            throw new IOException(JaiI18N.getString("GIFImageDecoder2"));
        }
        return this.decode();
    }
}

