/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.BMPEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.BMPImageDecoder;
import edu.cmu.cs.stage3.io.image.codec.BMPImageEncoder;
import edu.cmu.cs.stage3.io.image.codec.ImageCodec;
import edu.cmu.cs.stage3.io.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.io.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.io.image.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BMPCodec
extends ImageCodec {
    static Class class$java$lang$Object;
    static Class class$edu$cmu$cs$stage3$io$image$codec$BMPEncodeParam;

    public String getFormatName() {
        return "bmp";
    }

    public Class getEncodeParamClass() {
        return class$edu$cmu$cs$stage3$io$image$codec$BMPEncodeParam == null ? (class$edu$cmu$cs$stage3$io$image$codec$BMPEncodeParam = BMPCodec.class$("edu.cmu.cs.stage3.io.image.codec.BMPEncodeParam")) : class$edu$cmu$cs$stage3$io$image$codec$BMPEncodeParam;
    }

    public Class getDecodeParamClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = BMPCodec.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        SampleModel sampleModel = im.getSampleModel();
        int dataType = sampleModel.getTransferType();
        if (dataType == 1 || dataType == 2 || dataType == 3 || dataType == 4 || dataType == 5) {
            return false;
        }
        if (param != null) {
            if (!(param instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam BMPParam = (BMPEncodeParam)param;
            int version = BMPParam.getVersion();
            if (version == 0 || version == 2) {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        BMPEncodeParam p = null;
        if (param != null) {
            p = (BMPEncodeParam)param;
        }
        return new BMPImageEncoder(dst, p);
    }

    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        return new BMPImageDecoder(src, null);
    }

    protected ImageDecoder createImageDecoder(File src, ImageDecodeParam param) throws IOException {
        return new BMPImageDecoder(new FileInputStream(src), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new BMPImageDecoder((InputStream)src, null);
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 66 && header[1] == 77;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

