/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileTreeLoader
implements DirectoryTreeLoader {
    private Hashtable m_pathnameToZipEntryMap = new Hashtable();
    private File m_rootFile = null;
    private ZipFile m_zipFile = null;
    private String m_currentDirectory = null;
    private InputStream m_currentlyOpenStream = null;

    private static String getCanonicalPathname(String pathname) {
        int index;
        pathname = pathname.replace('\\', '/');
        while ((index = pathname.indexOf("//")) != -1) {
            pathname = String.valueOf(String.valueOf(pathname.substring(0, index + 1))).concat(String.valueOf(String.valueOf(pathname.substring(index + 2))));
        }
        if (pathname.charAt(0) == '/') {
            pathname = pathname.substring(1);
        }
        return pathname;
    }

    public void open(Object pathname) throws IOException, IllegalArgumentException {
        if (this.m_zipFile != null) {
            this.close();
        }
        if (pathname instanceof String) {
            this.m_rootFile = new File((String)pathname);
        } else if (pathname instanceof File) {
            this.m_rootFile = (File)pathname;
        } else {
            if (pathname == null) {
                throw new IllegalArgumentException("pathname is null");
            }
            throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
        }
        this.m_zipFile = new ZipFile(this.m_rootFile);
        this.m_currentDirectory = "";
        this.m_currentlyOpenStream = null;
        this.m_pathnameToZipEntryMap.clear();
        Enumeration<? extends ZipEntry> enumeration = this.m_zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.m_pathnameToZipEntryMap.put(ZipFileTreeLoader.getCanonicalPathname(zipEntry.getName()), zipEntry);
        }
    }

    public void close() throws IOException {
        if (this.m_zipFile != null) {
            this.closeCurrentFile();
            this.m_zipFile.close();
            this.m_zipFile = null;
        }
    }

    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        if (pathname == null) {
            pathname = "";
        } else if (pathname.length() > 0) {
            if (pathname.charAt(0) != '/' && pathname.charAt(0) != '\\') {
                pathname = String.valueOf(String.valueOf(this.m_currentDirectory)).concat(String.valueOf(String.valueOf(pathname)));
            }
            if (!(pathname = ZipFileTreeLoader.getCanonicalPathname(pathname)).endsWith("/")) {
                pathname = String.valueOf(String.valueOf(pathname)).concat("/");
            }
            if (!pathname.startsWith("/")) {
                pathname = "/".concat(String.valueOf(String.valueOf(pathname)));
            }
        }
        this.m_currentDirectory = pathname;
    }

    public String getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    public InputStream readFile(String filename) throws IOException, IllegalArgumentException {
        this.closeCurrentFile();
        String pathname = ZipFileTreeLoader.getCanonicalPathname(String.valueOf(String.valueOf(this.m_currentDirectory)).concat(String.valueOf(String.valueOf(filename))));
        ZipEntry zipEntry = (ZipEntry)this.m_pathnameToZipEntryMap.get(pathname);
        if (zipEntry != null) {
            this.m_currentlyOpenStream = this.m_zipFile.getInputStream(zipEntry);
            return this.m_currentlyOpenStream;
        }
        throw new FileNotFoundException("Not Found: ".concat(String.valueOf(String.valueOf(pathname))));
    }

    public void closeCurrentFile() throws IOException {
        if (this.m_currentlyOpenStream != null) {
            this.m_currentlyOpenStream.close();
            this.m_currentlyOpenStream = null;
        }
    }

    public String[] getFilesInCurrentDirectory() {
        throw new RuntimeException("not implemented");
    }

    public String[] getDirectoriesInCurrentDirectory() {
        throw new RuntimeException("not implemented");
    }

    public boolean isKeepFileSupported() {
        return true;
    }

    static Object getKeepKey(File file, String currentDirectory, String filename) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getAbsolutePath()))).append("____").append(currentDirectory).append(filename)));
    }

    public Object getKeepKey(String filename) {
        return ZipFileTreeLoader.getKeepKey(this.m_rootFile, this.m_currentDirectory, filename);
    }
}

