/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.AppearanceProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.GeometryProxy;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;

class VisualProxy
extends ComponentProxy {
    private GeometryProxy m_geometry = null;
    private boolean m_isShowing = false;
    private TransformGroup m_j3dScaleGroup = new TransformGroup();
    private Transform3D m_j3dScale3D = new Transform3D();
    private Shape3D m_j3dShape3D = new Shape3D();

    VisualProxy() {
    }

    protected Node getJ3DNode() {
        return this.m_j3dScaleGroup;
    }

    protected void initJ3D() {
        super.initJ3D();
        this.m_j3dScaleGroup.setCapability(18);
        this.m_j3dScaleGroup.setPickable(true);
        this.m_j3dScaleGroup.setUserData((Object)this);
        this.m_j3dScale3D.setIdentity();
        this.m_j3dScaleGroup.setTransform(this.m_j3dScale3D);
        this.m_j3dShape3D.setCapability(15);
        this.m_j3dShape3D.setCapability(13);
        this.m_j3dShape3D.setPickable(true);
        this.m_j3dShape3D.setUserData((Object)this);
        this.m_j3dScaleGroup.addChild((Node)this.m_j3dShape3D);
    }

    public void updateJ3DGeometry() {
        javax.media.j3d.Geometry j3dGeometry = this.m_geometry != null ? (this.m_isShowing ? this.m_geometry.getJ3DGeometry() : null) : null;
        this.m_j3dShape3D.setGeometry(j3dGeometry);
    }

    protected void changed(Property property, Object value) {
        if (property == Visual.FRONT_FACING_APPEARANCE_PROPERTY) {
            AppearanceProxy appearanceProxy = (AppearanceProxy)this.getProxyFor((Element)((Appearance)value));
            this.m_j3dShape3D.setAppearance(appearanceProxy.getJ3DAppearance());
        } else if (property != Visual.BACK_FACING_APPEARANCE_PROPERTY) {
            if (property == Visual.GEOMETRY_PROPERTY) {
                if (this.m_geometry != null) {
                    this.m_geometry.removeVisual(this);
                }
                this.m_geometry = (GeometryProxy)this.getProxyFor((Element)((Geometry)value));
                if (this.m_geometry != null) {
                    this.m_geometry.addVisual(this);
                }
                this.updateJ3DGeometry();
            } else if (property == Visual.SCALE_PROPERTY) {
                Matrix4d m = new Matrix4d();
                m.set((Matrix3d)value);
                m.transpose();
                m.m02 = -m.m02;
                m.m12 = -m.m12;
                m.m20 = -m.m20;
                m.m21 = -m.m21;
                this.m_j3dScale3D.set(m);
                this.m_j3dScaleGroup.setTransform(this.m_j3dScale3D);
            } else if (property == Visual.IS_SHOWING_PROPERTY) {
                this.m_isShowing = value != null && (Boolean)value != false;
                this.updateJ3DGeometry();
            } else if (property != Visual.DISABLED_AFFECTORS_PROPERTY) {
                super.changed(property, value);
            }
        }
    }
}

