/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer;

import com.sun.j3d.utils.image.TextureLoader;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.AppearanceProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.ElementProxy;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Vector;
import javax.media.j3d.Texture;

class TextureMapProxy
extends ElementProxy {
    private Vector m_appearances = new Vector();
    private Texture m_j3dTexture = null;

    TextureMapProxy() {
    }

    public Texture getJ3DTexture() {
        return this.m_j3dTexture;
    }

    public void addAppearance(AppearanceProxy appearance) {
        this.m_appearances.addElement(appearance);
    }

    public void removeAppearance(AppearanceProxy appearance) {
        this.m_appearances.removeElement((Object)appearance);
    }

    protected void updateAppearances() {
        for (int i = 0; i < this.m_appearances.size(); ++i) {
            AppearanceProxy appearance = (AppearanceProxy)((Object)this.m_appearances.elementAt(i));
            appearance.updateJ3DTexture(this.m_j3dTexture);
        }
    }

    protected void changed(Property property, Object value) {
        if (property == TextureMap.IMAGE_PROPERTY) {
            this.m_j3dTexture = null;
            BufferedImage image = (BufferedImage)value;
            if (image != null) {
                if (image.getColorModel() instanceof IndexColorModel) {
                    System.err.println("TODO: handle indexed texture maps ".concat(String.valueOf(String.valueOf(image))));
                } else {
                    this.m_j3dTexture = new TextureLoader(image).getTexture();
                }
            }
            this.updateAppearances();
        } else if (property != TextureMap.FORMAT_PROPERTY) {
            super.changed(property, value);
        }
    }
}

