/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.LightweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.ContainerProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.HeavyweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.OnscreenRenderTarget;
import javax.vecmath.Vector3d;

public class Renderer
extends AbstractProxyRenderer {
    private DisplayDriver[] m_displayDrivers = new DisplayDriver[0];
    private static final String RENDERER_PACKAGE_NAME = "edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.";
    private static final String SCENEGRAPH_PACKAGE_NAME = "edu.cmu.cs.stage3.alice.scenegraph.";
    private static final int SCENEGRAPH_PACKAGE_NAME_COUNT;

    protected boolean requiresHierarchyAndAbsoluteTransformationListening() {
        return false;
    }

    protected boolean requiresBoundListening() {
        return false;
    }

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget createOffscreenRenderTarget() {
        return new OffscreenRenderTarget(this);
    }

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.HeavyweightOnscreenRenderTarget createHeavyweightOnscreenRenderTarget() {
        return new HeavyweightOnscreenRenderTarget(this);
    }

    public LightweightOnscreenRenderTarget createLightweightOnscreenRenderTarget() {
        throw new RuntimeException();
    }

    protected void dispatchAbsoluteTransformationChange(AbsoluteTransformationEvent absoluteTransformationEvent) {
    }

    protected void dispatchBoundChange(BoundEvent boundEvent) {
    }

    public void dispatchChildAdd(ChildrenEvent childrenEvent) {
        Container sgContainer = (Container)childrenEvent.getSource();
        ContainerProxy containerProxy = (ContainerProxy)this.getProxyFor((Element)sgContainer);
        ComponentProxy childProxy = (ComponentProxy)this.getProxyFor((Element)childrenEvent.getChild());
        containerProxy.onChildAdded(childProxy);
    }

    public void dispatchChildRemove(ChildrenEvent childrenEvent) {
        Container sgContainer = (Container)childrenEvent.getSource();
        ContainerProxy containerProxy = (ContainerProxy)this.getProxyFor((Element)sgContainer);
        ComponentProxy childProxy = (ComponentProxy)this.getProxyFor((Element)childrenEvent.getChild());
        containerProxy.onChildRemoved(childProxy);
    }

    protected void dispatchHierarchyChange(HierarchyEvent hierarchyEvent) {
    }

    public DisplayDriver[] getDisplayDrivers() {
        return this.m_displayDrivers;
    }

    public PickInfo pick(Component sgComponent, Vector3d v, double planeMinX, double planeMinY, double planeMaxX, double planeMaxY, double nearClippingPlaneDistance, double farClippingPlaneDistance, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        return null;
    }

    protected void doFrame() {
        OnscreenRenderTarget onscreenRenderTarget;
        int i;
        edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget[] onscreenRenderTargets = this.getOnscreenRenderTargets();
        boolean atLeastOneRenderTargetHasUpdated = false;
        this.onIdle();
        for (i = 0; i < onscreenRenderTargets.length; ++i) {
            onscreenRenderTarget = (OnscreenRenderTarget)onscreenRenderTargets[i];
            if (!onscreenRenderTarget.updateIsAutomatic() || !onscreenRenderTarget.clearAndRenderOffscreenIsRequired()) continue;
            onscreenRenderTarget.clearAndRenderOffscreen();
        }
        for (i = 0; i < onscreenRenderTargets.length; ++i) {
            onscreenRenderTarget = (OnscreenRenderTarget)onscreenRenderTargets[i];
            if (!onscreenRenderTarget.updateIsAutomatic() || !onscreenRenderTarget.updateIsRequired()) continue;
            onscreenRenderTarget.update();
            if (onscreenRenderTarget.updateIsRequired()) continue;
            atLeastOneRenderTargetHasUpdated = true;
        }
        try {
            if (atLeastOneRenderTargetHasUpdated) {
                Thread.sleep(1L);
            } else {
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    protected AbstractProxy createProxyFor(Element sgElement) {
        String className;
        Class<?> sgClass;
        for (sgClass = sgElement.getClass(); sgClass != null && !(className = sgClass.getName()).startsWith(SCENEGRAPH_PACKAGE_NAME); sgClass = sgClass.getSuperclass()) {
        }
        try {
            Class<?> proxyClass = Class.forName(String.valueOf(String.valueOf(new StringBuffer(RENDERER_PACKAGE_NAME).append(sgClass.getName().substring(SCENEGRAPH_PACKAGE_NAME_COUNT)).append("Proxy"))));
            AbstractProxy abstractProxy = (AbstractProxy)proxyClass.newInstance();
            return abstractProxy;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        return null;
    }

    static {
        RENDERER_PACKAGE_NAME = RENDERER_PACKAGE_NAME;
        SCENEGRAPH_PACKAGE_NAME = SCENEGRAPH_PACKAGE_NAME;
        SCENEGRAPH_PACKAGE_NAME_COUNT = SCENEGRAPH_PACKAGE_NAME.length();
    }
}

