/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer;

import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.VertexGeometryProxy;
import javax.media.j3d.Geometry;
import javax.vecmath.TexCoord2f;

class IndexedTriangleArrayProxy
extends VertexGeometryProxy {
    private javax.media.j3d.IndexedTriangleArray m_j3dIndexedTriangleArray;

    IndexedTriangleArrayProxy() {
    }

    protected Geometry getJ3DGeometry() {
        return this.m_j3dIndexedTriangleArray;
    }

    protected void updateGeometry() {
        IndexedTriangleArray sgITA = (IndexedTriangleArray)this.getSceneGraphElement();
        Vertex3d[] vertices = sgITA.getVertices();
        int[] indices = sgITA.getIndices();
        int vertexCount = 0;
        if (vertices != null) {
            vertexCount = vertices.length;
        }
        int indexCount = 0;
        if (indices != null) {
            indexCount = indices.length;
        }
        if (vertexCount < 1 || indexCount < 3) {
            this.m_j3dIndexedTriangleArray = new javax.media.j3d.IndexedTriangleArray(1, 35, 3);
            int[] _indices = new int[]{0, 0, 0};
            double[] coords = new double[]{0.0, 0.0, 0.0};
            float[] normals = new float[]{0.0f, 1.0f, 0.0f};
            float[] texturecoords = new float[]{0.0f, 0.0f};
            this.m_j3dIndexedTriangleArray.setCoordinates(0, coords);
            this.m_j3dIndexedTriangleArray.setCoordinateIndices(0, _indices);
        } else {
            int[] reversedIndices = new int[indexCount];
            for (int i = 0; i < indexCount; i += 3) {
                reversedIndices[i] = indices[i + 2];
                reversedIndices[i + 1] = indices[i + 1];
                reversedIndices[i + 2] = indices[i];
            }
            double[] coords = null;
            float[] normals = null;
            TexCoord2f[] texturecoords = null;
            float[] colors = null;
            int j3dVertexFormat = 0;
            int vertexFormat = vertices[0].getFormat();
            if ((vertexFormat & 1) != 0) {
                coords = new double[vertexCount * 3];
                j3dVertexFormat |= 1;
            }
            if ((vertexFormat & 2) != 0) {
                normals = new float[vertexCount * 3];
                j3dVertexFormat |= 2;
            }
            if ((vertexFormat & 0x10) != 0) {
                texturecoords = new TexCoord2f[vertexCount];
                j3dVertexFormat |= 0x20;
            }
            if ((vertexFormat & 4) != 0) {
                colors = new float[vertexCount * 4];
                j3dVertexFormat |= 0xC;
            }
            int coordIndex = 0;
            int normalIndex = 0;
            int texturecoordIndex = 0;
            int colorIndex = 0;
            for (int i = 0; i < vertexCount; ++i) {
                Vertex3d vertex = vertices[i];
                if ((j3dVertexFormat & 1) != 0) {
                    coords[coordIndex++] = vertex.position.x;
                    coords[coordIndex++] = vertex.position.y;
                    coords[coordIndex++] = -vertex.position.z;
                }
                if ((j3dVertexFormat & 2) != 0) {
                    normals[normalIndex++] = (float)vertex.normal.x;
                    normals[normalIndex++] = (float)vertex.normal.y;
                    normals[normalIndex++] = -((float)vertex.normal.z);
                }
                if ((j3dVertexFormat & 0x20) != 0) {
                    texturecoords[texturecoordIndex++] = vertex.textureCoordinate0;
                }
                if ((j3dVertexFormat & 0xC) == 0) continue;
                colors[colorIndex++] = vertex.diffuseColor.red;
                colors[colorIndex++] = vertex.diffuseColor.green;
                colors[colorIndex++] = vertex.diffuseColor.blue;
                colors[colorIndex++] = vertex.diffuseColor.alpha;
            }
            this.m_j3dIndexedTriangleArray = new javax.media.j3d.IndexedTriangleArray(vertexCount, j3dVertexFormat, indexCount);
            if ((j3dVertexFormat & 1) != 0) {
                this.m_j3dIndexedTriangleArray.setCoordinates(0, coords);
                this.m_j3dIndexedTriangleArray.setCoordinateIndices(0, reversedIndices);
            }
            if ((j3dVertexFormat & 2) != 0) {
                this.m_j3dIndexedTriangleArray.setNormals(0, normals);
                this.m_j3dIndexedTriangleArray.setNormalIndices(0, reversedIndices);
            }
            if ((j3dVertexFormat & 0x20) != 0) {
                this.m_j3dIndexedTriangleArray.setTextureCoordinates(0, 0, texturecoords);
                this.m_j3dIndexedTriangleArray.setTextureCoordinateIndices(0, reversedIndices);
            }
            if ((j3dVertexFormat & 0xC) != 0) {
                this.m_j3dIndexedTriangleArray.setColors(0, colors);
                this.m_j3dIndexedTriangleArray.setColorIndices(0, reversedIndices);
            }
        }
        this.updateVisuals();
    }

    protected void changed(Property property, Object value) {
        if (property == IndexedTriangleArray.INDICES_PROPERTY) {
            this.updateGeometry();
        } else if (property != IndexedTriangleArray.INDEX_LOWER_BOUND_PROPERTY && property != IndexedTriangleArray.INDEX_UPPER_BOUND_PROPERTY) {
            super.changed(property, value);
        }
    }
}

