/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.java3drenderer.TextureMapProxy;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;

class AppearanceProxy
extends ElementProxy {
    private TextureMapProxy m_diffuseColorMap = null;
    private javax.media.j3d.Appearance m_j3dAppearance = new javax.media.j3d.Appearance();
    private Material m_j3dMaterial = new Material();
    private ColoringAttributes m_j3dColoringAttributes = new ColoringAttributes();
    private PolygonAttributes m_j3dPolygonAttributes = new PolygonAttributes();
    private LineAttributes m_j3dLineAttributes = new LineAttributes();
    private PointAttributes m_j3dPointAttributes = new PointAttributes();
    private RenderingAttributes m_j3dRenderingAttributes = new RenderingAttributes();
    private TextureAttributes m_j3dTextureAttributes = new TextureAttributes();

    AppearanceProxy() {
    }

    protected javax.media.j3d.Appearance getJ3DAppearance() {
        return this.m_j3dAppearance;
    }

    protected void initJ3D() {
        super.initJ3D();
        this.m_j3dAppearance.setCapability(3);
        this.m_j3dMaterial.setCapability(1);
        this.m_j3dPolygonAttributes.setCapability(3);
        this.m_j3dPolygonAttributes.setCapability(1);
        this.m_j3dPolygonAttributes.setCullFace(1);
        this.m_j3dPolygonAttributes.setBackFaceNormalFlip(true);
        this.m_j3dColoringAttributes.setCapability(1);
        this.m_j3dColoringAttributes.setCapability(3);
        this.m_j3dTextureAttributes.setTextureMode(2);
        this.m_j3dAppearance.setMaterial(this.m_j3dMaterial);
        this.m_j3dAppearance.setColoringAttributes(this.m_j3dColoringAttributes);
        this.m_j3dAppearance.setPointAttributes(this.m_j3dPointAttributes);
        this.m_j3dAppearance.setLineAttributes(this.m_j3dLineAttributes);
        this.m_j3dAppearance.setPolygonAttributes(this.m_j3dPolygonAttributes);
        this.m_j3dAppearance.setTextureAttributes(this.m_j3dTextureAttributes);
    }

    public void updateJ3DTexture(Texture j3dTexture) {
        this.m_j3dAppearance.setTexture(j3dTexture);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void changed(Property property, Object value) {
        if (property == Appearance.AMBIENT_COLOR_PROPERTY) {
            Color color = (Color)value;
            return;
        } else if (property == Appearance.DIFFUSE_COLOR_PROPERTY) {
            Color color = (Color)value;
            this.m_j3dMaterial.setAmbientColor(color.createVecmathColor3f());
            this.m_j3dMaterial.setDiffuseColor(color.createVecmathColor3f());
            return;
        } else if (property == Appearance.FILLING_STYLE_PROPERTY) {
            if (value.equals(FillingStyle.SOLID)) {
                this.m_j3dPolygonAttributes.setPolygonMode(2);
                return;
            } else if (value.equals(FillingStyle.WIREFRAME)) {
                this.m_j3dPolygonAttributes.setPolygonMode(1);
                return;
            } else {
                if (!value.equals(FillingStyle.POINTS)) throw new RuntimeException();
                this.m_j3dPolygonAttributes.setPolygonMode(0);
            }
            return;
        } else if (property == Appearance.SHADING_STYLE_PROPERTY) {
            if (value == null || value.equals(ShadingStyle.NONE)) {
                this.m_j3dMaterial.setLightingEnable(false);
                return;
            } else if (value.equals(ShadingStyle.FLAT)) {
                this.m_j3dMaterial.setLightingEnable(true);
                this.m_j3dColoringAttributes.setShadeModel(2);
                return;
            } else {
                if (!value.equals(ShadingStyle.SMOOTH)) throw new RuntimeException();
                this.m_j3dMaterial.setLightingEnable(true);
                this.m_j3dColoringAttributes.setShadeModel(3);
            }
            return;
        } else {
            if (property == Appearance.OPACITY_PROPERTY || property == Appearance.SPECULAR_HIGHLIGHT_COLOR_PROPERTY || property == Appearance.SPECULAR_HIGHLIGHT_EXPONENT_PROPERTY || property == Appearance.EMISSIVE_COLOR_PROPERTY) return;
            if (property == Appearance.DIFFUSE_COLOR_MAP_PROPERTY) {
                if (this.m_diffuseColorMap != null) {
                    this.m_diffuseColorMap.removeAppearance(this);
                }
                this.m_diffuseColorMap = (TextureMapProxy)this.getProxyFor((Element)((TextureMap)value));
                if (this.m_diffuseColorMap != null) {
                    this.m_diffuseColorMap.addAppearance(this);
                    this.updateJ3DTexture(this.m_diffuseColorMap.getJ3DTexture());
                    return;
                } else {
                    this.updateJ3DTexture(null);
                }
                return;
            } else {
                if (property == Appearance.OPACITY_MAP_PROPERTY || property == Appearance.EMISSIVE_COLOR_MAP_PROPERTY || property == Appearance.SPECULAR_HIGHLIGHT_COLOR_MAP_PROPERTY || property == Appearance.BUMP_MAP_PROPERTY || property == Appearance.DETAIL_MAP_PROPERTY) return;
                super.changed(property, value);
            }
        }
    }
}

