/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import vrml.VrmlAppearance;
import vrml.VrmlIndexedFaceSet;
import vrml.VrmlObj;
import vrml.VrmlShape;

public class VrmlTransform
extends VrmlObj {
    private static final String PROP_TRANS = "translation";
    private static final String PROP_ROTAT = "rotation";
    private static final String PROP_SCALE = "scale";
    private double[] translation = new double[3];
    private double[] rotation = new double[4];
    private double[] scale = new double[]{1.0, 1.0, 1.0};

    public Vector3d getTranslation() {
        return new Vector3d(this.translation);
    }

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("Transform");
        pw.println(" {");
        String indent2 = indent + "  ";
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_TRANS, this.translation));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_ROTAT, this.rotation));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_SCALE, this.scale));
        VrmlObj[] children = this.getChildren();
        if (children != null && children.length > 0) {
            pw.println(indent2 + "children" + " [");
            String indent3 = indent2 + "  ";
            int i = 0;
            while (i < children.length) {
                pw.print(indent3);
                children[i].outputVrml(pw, indent3);
                ++i;
            }
            pw.println(indent2 + "]");
        }
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  translation:");
        int i = 0;
        while (i < this.translation.length) {
            sb.append(" ");
            sb.append(this.translation[i]);
            ++i;
        }
        sb.append("\n  rotation:");
        i = 0;
        while (i < this.rotation.length) {
            sb.append(" ");
            sb.append(this.rotation[i]);
            ++i;
        }
        sb.append("\n  scale:");
        i = 0;
        while (i < this.scale.length) {
            sb.append(" ");
            sb.append(this.scale[i]);
            ++i;
        }
        return sb.toString();
    }

    public void setScale(double[] scale) {
        if (scale != null && scale.length >= this.scale.length) {
            int i = 0;
            while (i < this.scale.length) {
                this.scale[i] = scale[i];
                ++i;
            }
        }
    }

    public Vector3d getScale() {
        return new Vector3d(this.scale);
    }

    public void setRotation(double[] rotation) {
        if (rotation != null && rotation.length >= this.rotation.length) {
            int i = 0;
            while (i < this.rotation.length) {
                this.rotation[i] = rotation[i];
                ++i;
            }
        }
    }

    public Vector4d getRotation() {
        return new Vector4d(this.rotation);
    }

    public VrmlShape getShape() {
        VrmlObj[] children = this.getChildren();
        if (children == null) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof VrmlShape) {
                return (VrmlShape)children[i];
            }
            ++i;
        }
        return null;
    }

    public VrmlAppearance getAppearance() {
        VrmlShape shape = this.getShape();
        if (shape == null) {
            return null;
        }
        return shape.getAppearance();
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            double[] values;
            if (PROP_TRANS.equals(objs[i])) {
                values = this.makeValues(objs, i, this.translation);
                if (values != null) {
                    this.setTranslation(values);
                    i += values.length;
                }
            } else if (PROP_ROTAT.equals(objs[i])) {
                values = this.makeValues(objs, i, this.rotation);
                if (values != null) {
                    this.setRotation(values);
                    i += values.length;
                }
            } else if (PROP_SCALE.equals(objs[i]) && (values = this.makeValues(objs, i, this.scale)) != null) {
                this.setScale(values);
                i += values.length;
            }
            ++i;
        }
    }

    public VrmlIndexedFaceSet getGeometory() {
        VrmlShape shape = this.getShape();
        if (shape == null) {
            return null;
        }
        return shape.getGeometry();
    }

    public void setTranslation(double[] translation) {
        if (translation != null && translation.length >= this.translation.length) {
            int i = 0;
            while (i < this.translation.length) {
                this.translation[i] = translation[i];
                ++i;
            }
        }
    }
}

