/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.vecmath.TexCoord2f;
import vrml.VrmlCoordinate;
import vrml.VrmlObj;

public class VrmlTextureCoordinate
extends VrmlCoordinate {
    private static final String PROP_POINT = "point";
    private TexCoord2f[] point = null;

    public TexCoord2f[] getTextureCoordinates() {
        return this.point;
    }

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("TextureCoordinate");
        pw.print(" { ");
        String indent2 = indent + "  ";
        if (this.point != null) {
            pw.print(PROP_POINT);
            pw.print(" [");
            int i = 0;
            int j = 0;
            while (i < this.point.length) {
                if (j > 3) {
                    j = 0;
                }
                if (j == 0) {
                    pw.println();
                    pw.print(indent2);
                }
                pw.print(VrmlObj.dblFormat.format(this.point[i].x));
                pw.print(" ");
                pw.print(VrmlObj.dblFormat.format(this.point[i].y));
                pw.print(", ");
                ++i;
                ++j;
            }
            pw.println(" ]");
        }
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.point != null) {
            sb.append("\n  ").append(PROP_POINT).append(": [");
            int i = 0;
            while (i < this.point.length) {
                sb.append("\n    ").append(this.point[i].x).append(" ").append(this.point[i].y);
                ++i;
            }
            sb.append("\n  ]");
        }
        return sb.toString();
    }

    public VrmlTextureCoordinate() {
    }

    public VrmlTextureCoordinate(TexCoord2f[] texCoords) {
        this.point = texCoords;
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            if (PROP_POINT.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof Vector) {
                this.point = this.makeTexCoords((Vector)objs[i + 1]);
                ++i;
            }
            ++i;
        }
    }

    private TexCoord2f[] makeTexCoords(Vector values) {
        try {
            ArrayList<TexCoord2f> ar = new ArrayList<TexCoord2f>();
            int i = 0;
            while (i < values.size()) {
                Vector val = (Vector)values.get(i);
                if (val.size() != 2) {
                    return null;
                }
                ar.add(new TexCoord2f(((Double)val.get(0)).floatValue(), ((Double)val.get(1)).floatValue()));
                ++i;
            }
            return ar.toArray(new TexCoord2f[ar.size()]);
        }
        catch (ClassCastException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

