/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.Vector;
import vrml.VrmlAppearance;
import vrml.VrmlIndexedFaceSet;
import vrml.VrmlObj;

public class VrmlShape
extends VrmlObj {
    private static final String PROP_APPEAR = "appearance";
    private static final String PROP_GEOME = "geometry";
    private VrmlAppearance appearance = null;
    private VrmlIndexedFaceSet geometry = null;

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("Shape");
        pw.println(" {");
        String indent2 = indent + "  ";
        if (this.appearance != null) {
            pw.print(indent2 + PROP_APPEAR);
            pw.print(" ");
            this.appearance.outputVrml(pw, indent2);
        }
        if (this.geometry != null) {
            pw.print(indent2 + PROP_GEOME);
            pw.print(" ");
            this.geometry.outputVrml(pw, indent2);
        }
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  ").append(PROP_APPEAR).append(" {\n").append(this.appearance).append("\n  }");
        sb.append("\n  ").append(PROP_GEOME).append(" {\n").append(this.geometry).append("\n  }");
        return sb.toString();
    }

    public VrmlShape() {
    }

    public VrmlShape(VrmlAppearance appearance, VrmlIndexedFaceSet geometry) {
        this.appearance = appearance;
        this.geometry = geometry;
    }

    public VrmlAppearance getAppearance() {
        return this.appearance;
    }

    public VrmlIndexedFaceSet getGeometry() {
        return this.geometry;
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            if (PROP_APPEAR.equals(objs[i])) {
                if (i + 1 < objs.length && objs[i + 1] instanceof VrmlAppearance) {
                    this.appearance = (VrmlAppearance)objs[i + 1];
                    ++i;
                }
            } else if (PROP_GEOME.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof VrmlIndexedFaceSet) {
                this.geometry = (VrmlIndexedFaceSet)objs[i + 1];
                ++i;
            }
            ++i;
        }
    }
}

