/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.Vector3d;
import vrml.VrmlObj;

public class VrmlPositionInterpolator
extends VrmlObj {
    private static final String NAME_POSTFIX = "_TranslationData";
    private static final String PROP_KEY = "key";
    private static final String PROP_KEYVALUE = "keyValue";
    private static final String PHRASE_ROUTE = "ROUTE ";
    private static final String PHRASE_TIMER = ".fraction_changed TO ";
    private static final String PHRASE_TIMER2 = ".set_fraction";
    private static final String PHRASE_POS = ".value_changed TO ";
    private static final String PHRASE_POS2 = ".set_translation";
    private String transformName = null;
    private String timerName = null;
    private Vector position = new Vector();

    private double[] makeKeys(int count) {
        double[] result = new double[count];
        int i = 0;
        while (i < count) {
            result[i] = (double)i / (double)(count - 1);
            ++i;
        }
        return result;
    }

    public void addPosition(Vector3d pos) {
        this.position.add(pos);
    }

    public void outputVrml(PrintWriter pw, String indent) {
        if (!this.isValid()) {
            return;
        }
        double[] noMove = new double[3];
        String noMoveVrml = this.toVrmlString(noMove);
        int count = this.position.size();
        double[] keys = this.makeKeys(count);
        pw.print(this.getVrmlName());
        pw.print("PositionInterpolator");
        pw.println(" {");
        String indent2 = indent + "  ";
        String indent3 = indent2 + "  ";
        pw.print(indent2);
        pw.print(PROP_KEY);
        pw.println(" [");
        pw.print(indent3);
        pw.println(this.toVrmlString(keys));
        pw.println(indent2 + "]");
        pw.print(indent2);
        pw.print(PROP_KEYVALUE);
        pw.println(" [");
        double[] vals = new double[3];
        String trans = null;
        int i = 0;
        while (i < count) {
            Vector3d pos = (Vector3d)this.position.get(i);
            if (pos == null) {
                trans = noMoveVrml;
            } else {
                pos.get(vals);
                trans = this.toVrmlString(vals);
            }
            pw.print(indent3);
            pw.println(trans);
            ++i;
        }
        pw.println(indent2 + "]");
        pw.println(indent + "}");
        pw.print(indent);
        pw.print(PHRASE_ROUTE);
        pw.print(this.timerName);
        pw.print(PHRASE_TIMER);
        pw.print(this.getName());
        pw.println(PHRASE_TIMER2);
        pw.print(indent);
        pw.print(PHRASE_ROUTE);
        pw.print(this.getName());
        pw.print(PHRASE_POS);
        pw.print(this.transformName);
        pw.println(PHRASE_POS2);
    }

    private boolean isValid() {
        if (this.position == null) {
            return false;
        }
        if (!this.isValidName(this.transformName) || !this.isValidName(this.timerName)) {
            return false;
        }
        boolean valid = false;
        int i = 0;
        while (i < this.position.size()) {
            Vector3d pos = (Vector3d)this.position.get(i);
            if (pos != null && (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0)) {
                valid = true;
            }
            ++i;
        }
        return valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  position [");
        int i = 0;
        while (i < this.position.size()) {
            Vector3d pos = (Vector3d)this.position.get(i);
            sb.append("\n    ").append(pos);
            ++i;
        }
        sb.append("\n  ]");
        return sb.toString();
    }

    public void setTransformName(String name) {
        this.transformName = name;
        this.setName(name + NAME_POSTFIX);
    }

    public void setTimerName(String name) {
        this.timerName = name;
    }

    private boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        return !(name = name.trim()).equals("");
    }
}

