/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import vrml.VrmlException;
import vrml.VrmlObj;
import vrml.VrmlRoot;

public class VrmlParser {
    private static final char QUATE = '\"';
    private static final char CANMA = ',';
    private static final char SBRACKET_L = '[';
    private static final char SBRACKET_R = ']';
    private static final char CBRACKET_L = '{';
    private static final char CBRACKET_R = '}';
    private static final int STAT_NONE = 0;
    private static final int STAT_PROPERTY = 1;
    private static final int STAT_CSV = 2;
    public static final String PROP_CHILDREN = "children";
    public static final String KEYWORD_TRANSFORM = "Transform";
    public static final String KEYWORD_SHAPE = "Shape";
    public static final String KEYWORD_APPEARANCE = "Appearance";
    public static final String KEYWORD_MATERIAL = "Material";
    public static final String KEYWORD_IMAGETEXTURE = "ImageTexture";
    public static final String KEYWORD_INDEXEDFACESET = "IndexedFaceSet";
    public static final String KEYWORD_COORDINATE = "Coordinate";
    public static final String KEYWORD_NORMAL = "Normal";
    public static final String KEYWORD_TEXTURECOORDINATE = "TextureCoordinate";
    public static final String KEYWORD_TIMESENSOR = "TimeSensor";
    public static final String KEYWORD_ORIENTATIONIP = "OrientationInterpolator";
    public static final String KEYWORD_POSITIONIP = "PositionInterpolator";
    public static final String KEYWORD_DEF = "DEF";
    public static final String INDENT = "  ";
    Hashtable classDic = new Hashtable();

    public VrmlObj parse(Reader reader) throws IOException, VrmlException {
        StreamTokenizer st = new StreamTokenizer(reader);
        st.commentChar(35);
        st.eolIsSignificant(true);
        st.quoteChar(34);
        st.parseNumbers();
        st.lowerCaseMode(false);
        st.wordChars(95, 95);
        VrmlRoot top = new VrmlRoot();
        this.parseSub(st, 0, top, 0, -1);
        return top;
    }

    public VrmlParser() {
        this.classDic.put(KEYWORD_TRANSFORM, "vrml.VrmlTransform");
        this.classDic.put(KEYWORD_SHAPE, "vrml.VrmlShape");
        this.classDic.put(KEYWORD_APPEARANCE, "vrml.VrmlAppearance");
        this.classDic.put(KEYWORD_MATERIAL, "vrml.VrmlMaterial");
        this.classDic.put(KEYWORD_IMAGETEXTURE, "vrml.VrmlImageTexture");
        this.classDic.put(KEYWORD_INDEXEDFACESET, "vrml.VrmlIndexedFaceSet");
        this.classDic.put(KEYWORD_COORDINATE, "vrml.VrmlCoordinate");
        this.classDic.put(KEYWORD_NORMAL, "vrml.VrmlNormal");
        this.classDic.put(KEYWORD_TEXTURECOORDINATE, "vrml.VrmlTextureCoordinate");
    }

    private String getLastString(Vector params) {
        Object obj;
        if (params != null && params.size() > 0 && (obj = params.lastElement()) instanceof String) {
            return (String)obj;
        }
        return null;
    }

    private VrmlObj makeClass(Object val) {
        String type = (String)this.classDic.get(val);
        if (type != null) {
            try {
                Object obj = Class.forName(type).newInstance();
                if (obj != null && obj instanceof VrmlObj) {
                    return (VrmlObj)obj;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private VrmlObj makeClass(Vector params) {
        if (params == null || params.size() < 1) {
            return null;
        }
        String val = (String)params.lastElement();
        VrmlObj obj = this.makeClass(val);
        if (obj != null) {
            int pos = params.size() - 1;
            if (params.size() >= 3) {
                try {
                    val = (String)params.get(params.size() - 3);
                    String name = (String)params.get(params.size() - 2);
                    if (KEYWORD_DEF.equals(val)) {
                        obj.setName(name);
                        pos = params.size() - 3;
                    }
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            params.set(pos, obj);
            params.setSize(pos + 1);
            return obj;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("separator=" + File.separator);
        System.out.println("separatorChar=" + File.separatorChar);
        System.out.println("pathSeparator=" + File.pathSeparator);
        System.out.println("pathSeparatorChar=" + File.pathSeparatorChar);
        String filename = null;
        if (args.length <= 0) {
            System.out.println("Usage: VrmlParser filename");
            return;
        }
        filename = args[0];
        File tmp = new File(filename);
        System.out.print(filename);
        if (tmp.isAbsolute()) {
            System.out.println(" is absolute.");
        } else {
            System.out.println(" not absolute!");
        }
        System.out.println(tmp.getAbsolutePath().substring(0, 2));
    }

    private Vector parseSub(StreamTokenizer st, int initStatus, VrmlObj current, int startMark, int endMark) throws IOException, VrmlException {
        int status = initStatus;
        boolean skip = false;
        if (startMark != 0) {
            skip = true;
        }
        Vector<Object> params = new Vector<Object>();
        Vector<Vector<Object>> csvValues = new Vector<Vector<Object>>();
        block11: while (true) {
            int ttype;
            if ((ttype = st.nextToken()) == endMark) {
                if (status == 1) {
                    current.setProperties(params);
                } else if (status == 2) {
                    if (params.size() > 0) {
                        csvValues.add(params);
                    }
                    return csvValues;
                }
                return null;
            }
            if (ttype == -1) {
                throw new VrmlException("Unexpected file end");
            }
            if (skip) {
                if (ttype != startMark) continue;
                skip = false;
                continue;
            }
            switch (ttype) {
                case 10: {
                    break;
                }
                case -3: {
                    params.add(st.sval);
                    break;
                }
                case -2: {
                    if (status == 1) {
                        params.add(new Double(st.nval));
                        break;
                    }
                    if (status != 2) continue block11;
                    params.add(new Double(st.nval));
                    break;
                }
                case 34: {
                    if (status != 1) continue block11;
                    params.add(st.sval);
                    break;
                }
                case 44: {
                    if (status != 2) continue block11;
                    csvValues.add(params);
                    params = new Vector();
                    break;
                }
                case 91: {
                    String propname;
                    if (status != 1 || (propname = this.getLastString(params)) == null) continue block11;
                    if (PROP_CHILDREN.equals(propname)) {
                        this.parseSub(st, 0, current, 0, 93);
                        break;
                    }
                    Vector values = this.parseSub(st, 2, current, 0, 93);
                    params.add(values);
                    break;
                }
                case 93: {
                    break;
                }
                case 123: {
                    VrmlObj child;
                    if (status == 1) {
                        VrmlObj param = this.makeClass(params);
                        if (param == null) continue block11;
                        params.add(param);
                        this.parseSub(st, 1, param, 0, 125);
                        break;
                    }
                    if (status != 0 || (child = this.makeClass(params)) == null) continue block11;
                    current.appendChild(child);
                    this.parseSub(st, 1, child, 0, 125);
                    break;
                }
                case 125: {
                    break;
                }
                default: {
                    throw new VrmlException("Unknown pattarn:" + ttype + "[" + st.sval + "]");
                }
            }
        }
    }
}

