/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.AxisAngle4d;
import vrml.VrmlObj;

public class VrmlOrientationInterpolator
extends VrmlObj {
    private static final String NAME_POSTFIX = "_RotationData";
    private static final String PROP_KEY = "key";
    private static final String PROP_KEYVALUE = "keyValue";
    private static final String PHRASE_ROUTE = "ROUTE ";
    private static final String PHRASE_TIMER = ".fraction_changed TO ";
    private static final String PHRASE_TIMER2 = ".set_fraction";
    private static final String PHRASE_ROT = ".value_changed TO ";
    private static final String PHRASE_ROT2 = ".set_rotation";
    private String transformName = null;
    private String timerName = null;
    private Vector rotation = new Vector();

    private boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        return !(name = name.trim()).equals("");
    }

    private double[] makeKeys(int count) {
        double[] result = new double[count];
        int i = 0;
        while (i < count) {
            result[i] = (double)i / (double)(count - 1);
            ++i;
        }
        return result;
    }

    public void outputVrml(PrintWriter pw, String indent) {
        if (!this.isValid()) {
            return;
        }
        double[] noRot = new double[4];
        String noRotVrml = this.toVrmlString(noRot);
        int count = this.rotation.size();
        double[] keys = this.makeKeys(count);
        pw.print(this.getVrmlName());
        pw.print("OrientationInterpolator");
        pw.println(" {");
        String indent2 = indent + "  ";
        String indent3 = indent2 + "  ";
        pw.print(indent2);
        pw.print(PROP_KEY);
        pw.println(" [");
        pw.print(indent3);
        pw.println(this.toVrmlString(keys));
        pw.println(indent2 + "]");
        pw.print(indent2);
        pw.print(PROP_KEYVALUE);
        pw.println(" [");
        double[] vals = new double[4];
        String rot = null;
        int i = 0;
        while (i < count) {
            AxisAngle4d ax = (AxisAngle4d)this.rotation.get(i);
            if (ax == null) {
                rot = noRotVrml;
            } else {
                ax.get(vals);
                rot = this.toVrmlString(vals);
            }
            pw.print(indent3);
            pw.println(rot);
            ++i;
        }
        pw.println(indent2 + "]");
        pw.println(indent + "}");
        pw.print(indent);
        pw.print(PHRASE_ROUTE);
        pw.print(this.timerName);
        pw.print(PHRASE_TIMER);
        pw.print(this.getName());
        pw.println(PHRASE_TIMER2);
        pw.print(indent);
        pw.print(PHRASE_ROUTE);
        pw.print(this.getName());
        pw.print(PHRASE_ROT);
        pw.print(this.transformName);
        pw.println(PHRASE_ROT2);
    }

    private boolean isValid() {
        if (this.rotation == null) {
            return false;
        }
        if (!this.isValidName(this.transformName) || !this.isValidName(this.timerName)) {
            return false;
        }
        boolean valid = false;
        int i = 0;
        while (i < this.rotation.size()) {
            AxisAngle4d ax = (AxisAngle4d)this.rotation.get(i);
            if (ax != null && ax.angle != 0.0) {
                valid = true;
            }
            ++i;
        }
        return valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  rotation [");
        int i = 0;
        while (i < this.rotation.size()) {
            AxisAngle4d ax = (AxisAngle4d)this.rotation.get(i);
            sb.append("\n    ").append(ax);
            ++i;
        }
        sb.append("\n  ]");
        return sb.toString();
    }

    public void setTransformName(String name) {
        this.transformName = name;
        this.setName(name + NAME_POSTFIX);
    }

    public void setTimerName(String name) {
        this.timerName = name;
    }

    public void addRotation(AxisAngle4d ax) {
        this.rotation.add(ax);
    }
}

