/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VrmlObj {
    private static final String NAME_SEPARETOR = "__";
    private static final String BOOL_TRUE = "TRUE";
    private static final String BOOL_FALSE = "FALSE";
    protected static DecimalFormat dblFormat = new DecimalFormat("0.#######");
    private String name = null;
    private String nameMain = null;
    private String nameSub = null;
    private String nameShow = null;
    private VrmlObj parent = null;
    private Vector children = new Vector();

    public void appendChild(VrmlObj child) {
        child.setParent(this);
        this.children.add(child);
    }

    protected String getVrmlName() {
        if (this.name != null && !this.name.equals("")) {
            StringBuffer sb = new StringBuffer();
            sb.append("DEF").append(" ").append(this.name).append(" ");
            return sb.toString();
        }
        return "";
    }

    public void outputVrml(PrintWriter pw, String indent) {
    }

    public String getNameMain() {
        return this.nameMain;
    }

    private void toVrmlStringSub(double[] vals, StringBuffer sb) {
        if (vals != null) {
            int i = 0;
            while (i < vals.length) {
                sb.append(" ").append(dblFormat.format(vals[i]));
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append("(");
        sb.append(this.getClass().getName());
        sb.append(")");
        if (this.children != null && this.children.size() > 0) {
            sb.append("\n  child [");
            int i = 0;
            while (i < this.children.size()) {
                sb.append("\n");
                sb.append(this.children.get(i));
                ++i;
            }
            sb.append("\n  ]");
        }
        return sb.toString();
    }

    public void setParent(VrmlObj parent) {
        this.parent = parent;
    }

    public VrmlObj getParent() {
        return this.parent;
    }

    protected String toVrmlString(String property, boolean val) {
        StringBuffer sb = new StringBuffer();
        sb.append(property).append(" ");
        if (val) {
            sb.append(BOOL_TRUE);
        } else {
            sb.append(BOOL_FALSE);
        }
        return sb.toString();
    }

    protected String toVrmlString(String property, double[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(property);
        this.toVrmlStringSub(vals, sb);
        return sb.toString();
    }

    public synchronized void sortChildByName() {
        TreeMap<String, Vector<VrmlObj>> map = new TreeMap<String, Vector<VrmlObj>>();
        int i = 0;
        while (i < this.children.size()) {
            VrmlObj child = (VrmlObj)this.children.get(i);
            child.sortChildByName();
            String name = child.getName();
            name = name == null ? "x" : " " + name;
            Vector<VrmlObj> list = (Vector<VrmlObj>)map.get(name);
            if (list == null) {
                list = new Vector<VrmlObj>();
                map.put(name, list);
            }
            list.add(child);
            ++i;
        }
        this.children = new Vector();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            this.children.addAll((Vector)it.next());
        }
    }

    protected String toVrmlString(double[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.toVrmlStringSub(vals, sb);
        return sb.toString();
    }

    protected String toVrmlString(String property, double val) {
        StringBuffer sb = new StringBuffer();
        sb.append(property).append(" ").append(dblFormat.format(val));
        return sb.toString();
    }

    protected Double makeValue(Object[] objs, int pos) {
        if (pos + 1 >= objs.length) {
            return null;
        }
        if (objs[pos + 1] instanceof Double) {
            return (Double)objs[pos + 1];
        }
        return null;
    }

    public VrmlObj[] getChildren() {
        return this.children.toArray(new VrmlObj[this.children.size()]);
    }

    protected Boolean makeBoolValue(Object[] objs, int pos) {
        if (pos + 1 >= objs.length) {
            return null;
        }
        if (objs[pos + 1] instanceof String) {
            String value = (String)objs[pos + 1];
            if (BOOL_TRUE.equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if (BOOL_FALSE.equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public void setProperties(Vector params) {
    }

    public void setName(String name) {
        this.name = name;
        this.nameMain = null;
        this.nameSub = null;
        this.nameShow = null;
    }

    public String getName() {
        return this.name;
    }

    public void devideName(Pattern ptn) {
        int i = 0;
        while (i < this.children.size()) {
            VrmlObj child = (VrmlObj)this.children.get(i);
            child.devideName(ptn);
            ++i;
        }
        String org = this.name;
        if (org != null) {
            Matcher mat;
            int pos = org.indexOf(NAME_SEPARETOR);
            if (pos != -1) {
                this.nameShow = org.substring(pos + NAME_SEPARETOR.length());
                org = org.substring(0, pos);
            }
            if ((mat = ptn.matcher(org)).find()) {
                this.nameMain = mat.group(1);
                this.nameSub = mat.group(2);
            } else {
                this.nameMain = org;
                this.nameSub = null;
            }
        } else {
            this.nameMain = null;
            this.nameSub = null;
            this.nameShow = null;
        }
    }

    public String getDisplayName() {
        String text = "";
        if (this.nameMain == null) {
            text = "<no name>";
        } else if (this.nameShow != null && !this.nameShow.equals("")) {
            text = this.nameShow;
        } else {
            text = this.nameMain;
            if (this.nameSub != null) {
                text = text + this.nameSub;
            }
        }
        return text;
    }

    protected double[] makeValues(Object[] objs, int pos, double[] prop) {
        int len = prop.length;
        if (pos + len >= objs.length) {
            return null;
        }
        double[] values = new double[len];
        int j = 0;
        while (j < len) {
            if (!(objs[pos + j + 1] instanceof Double)) {
                return null;
            }
            values[j] = (Double)objs[pos + j + 1];
            ++j;
        }
        return values;
    }

    public synchronized void deleteChild(Vector parts) {
        Vector<VrmlObj> result = new Vector<VrmlObj>();
        int i = 0;
        while (i < this.children.size()) {
            VrmlObj child = (VrmlObj)this.children.get(i);
            if (parts.contains(child)) {
                child.setParent(null);
            } else {
                child.deleteChild(parts);
                result.add(child);
            }
            ++i;
        }
        this.children = result;
    }
}

