/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.vecmath.Vector3d;
import vrml.VrmlObj;

public class VrmlNormal
extends VrmlObj {
    private static final String PROP_VECTOR = "vector";
    private Vector3d[] vector = null;

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("Normal");
        pw.print(" { ");
        String indent2 = indent + "  ";
        if (this.vector != null) {
            pw.print(PROP_VECTOR);
            pw.print(" [");
            int i = 0;
            int j = 0;
            while (i < this.vector.length) {
                if (j > 2) {
                    j = 0;
                }
                if (j == 0) {
                    pw.println();
                    pw.print(indent2);
                }
                pw.print(VrmlObj.dblFormat.format(this.vector[i].x));
                pw.print(" ");
                pw.print(VrmlObj.dblFormat.format(this.vector[i].y));
                pw.print(" ");
                pw.print(VrmlObj.dblFormat.format(this.vector[i].z));
                pw.print(", ");
                ++i;
                ++j;
            }
            pw.println(" ]");
        }
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.vector != null) {
            sb.append("\n  ").append(PROP_VECTOR).append(": [");
            int i = 0;
            while (i < this.vector.length) {
                sb.append("\n    ").append(this.vector[i].x).append(" ").append(this.vector[i].y).append(" ").append(this.vector[i].z);
                ++i;
            }
            sb.append("\n  ]");
        }
        return sb.toString();
    }

    public VrmlNormal() {
    }

    public VrmlNormal(Vector3d[] vectors) {
        this.vector = vectors;
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            if (PROP_VECTOR.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof Vector) {
                this.vector = this.makeVectors((Vector)objs[i + 1]);
                ++i;
            }
            ++i;
        }
    }

    public Vector3d[] getNormals() {
        return this.vector;
    }

    private Vector3d[] makeVectors(Vector values) {
        try {
            ArrayList<Vector3d> ar = new ArrayList<Vector3d>();
            int i = 0;
            while (i < values.size()) {
                Vector val = (Vector)values.get(i);
                if (val.size() != 3) {
                    return null;
                }
                ar.add(new Vector3d(((Double)val.get(0)).doubleValue(), ((Double)val.get(1)).doubleValue(), ((Double)val.get(2)).doubleValue()));
                ++i;
            }
            return ar.toArray(new Vector3d[ar.size()]);
        }
        catch (ClassCastException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

