/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.Vector;
import vrml.VrmlObj;

public class VrmlMaterial
extends VrmlObj {
    private static final String PROP_DEFCOLOR = "diffuseColor";
    private static final String PROP_AMBIENT = "ambientIntensity";
    private static final String PROP_SPECOLOR = "specularColor";
    private static final String PROP_SHINE = "shininess";
    private static final String PROP_TRANSPAR = "transparency";
    private static final String PROP_EMICOLOR = "emissiveColor";
    private double[] diffuseColor = new double[]{1.0, 1.0, 1.0};
    private double[] specularColor = new double[]{1.0, 1.0, 1.0};
    private double[] emissiveColor = new double[]{1.0, 1.0, 1.0};
    private double ambientIntensity = 0.0;
    private double shininess = 0.0;
    private double transparency = 0.0;

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("Material");
        pw.println(" {");
        String indent2 = indent + "  ";
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_DEFCOLOR, this.diffuseColor));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_AMBIENT, this.ambientIntensity));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_SPECOLOR, this.specularColor));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_SHINE, this.shininess));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_TRANSPAR, this.transparency));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_EMICOLOR, this.emissiveColor));
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  ").append(PROP_DEFCOLOR).append(":");
        int i = 0;
        while (i < this.diffuseColor.length) {
            sb.append(" ");
            sb.append(this.diffuseColor[i]);
            ++i;
        }
        sb.append("\n  ").append(PROP_AMBIENT).append(": ").append(this.ambientIntensity);
        sb.append("\n  ").append(PROP_SPECOLOR).append(":");
        i = 0;
        while (i < this.specularColor.length) {
            sb.append(" ");
            sb.append(this.specularColor[i]);
            ++i;
        }
        sb.append("\n  ").append(PROP_SHINE).append(": ").append(this.shininess);
        sb.append("\n  ").append(PROP_TRANSPAR).append(": ").append(this.transparency);
        sb.append("\n  ").append(PROP_EMICOLOR).append(":");
        i = 0;
        while (i < this.emissiveColor.length) {
            sb.append(" ");
            sb.append(this.emissiveColor[i]);
            ++i;
        }
        return sb.toString();
    }

    public void setSpecularColor(double r, double g, double b) {
        this.specularColor[0] = r;
        this.specularColor[1] = g;
        this.specularColor[2] = b;
    }

    public double[] getSpecularColor() {
        return this.specularColor;
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            Double value;
            int j;
            double[] values;
            if (PROP_DEFCOLOR.equals(objs[i])) {
                values = this.makeValues(objs, i, this.diffuseColor);
                if (values != null) {
                    j = 0;
                    while (j < this.diffuseColor.length) {
                        this.diffuseColor[j] = values[j];
                        ++j;
                    }
                    i += values.length;
                }
            } else if (PROP_SPECOLOR.equals(objs[i])) {
                values = this.makeValues(objs, i, this.specularColor);
                if (values != null) {
                    j = 0;
                    while (j < this.specularColor.length) {
                        this.specularColor[j] = values[j];
                        ++j;
                    }
                    i += values.length;
                }
            } else if (PROP_EMICOLOR.equals(objs[i])) {
                values = this.makeValues(objs, i, this.emissiveColor);
                if (values != null) {
                    j = 0;
                    while (j < this.emissiveColor.length) {
                        this.emissiveColor[j] = values[j];
                        ++j;
                    }
                    i += values.length;
                }
            } else if (PROP_AMBIENT.equals(objs[i])) {
                value = this.makeValue(objs, i);
                if (value != null) {
                    this.ambientIntensity = value;
                    ++i;
                }
            } else if (PROP_SHINE.equals(objs[i])) {
                value = this.makeValue(objs, i);
                if (value != null) {
                    this.shininess = value;
                    ++i;
                }
            } else if (PROP_TRANSPAR.equals(objs[i]) && (value = this.makeValue(objs, i)) != null) {
                this.transparency = value;
                ++i;
            }
            ++i;
        }
    }

    public void setDiffuseColor(double r, double g, double b) {
        this.diffuseColor[0] = r;
        this.diffuseColor[1] = g;
        this.diffuseColor[2] = b;
    }

    public void setEmissiveColor(double r, double g, double b) {
        this.emissiveColor[0] = r;
        this.emissiveColor[1] = g;
        this.emissiveColor[2] = b;
    }

    public double[] getDiffuseColor() {
        return this.diffuseColor;
    }

    public double[] getEmissiveColor() {
        return this.emissiveColor;
    }
}

