/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import vrml.VrmlCoordinate;
import vrml.VrmlNormal;
import vrml.VrmlObj;
import vrml.VrmlTextureCoordinate;

public class VrmlIndexedFaceSet
extends VrmlObj {
    private static final String PROP_CCW = "ccw";
    private static final String PROP_SOLID = "solid";
    private static final String PROP_COORD = "coord";
    private static final String PROP_NORMAL = "normal";
    private static final String PROP_NPVERT = "normalPerVertex";
    private static final String PROP_TEXCOORD = "texCoord";
    private static final String PROP_COORDIDX = "coordIndex";
    private static final String PROP_TEXCRDIDX = "texCoordIndex";
    private static final String PROP_NORMALIDX = "normalIndex";
    private boolean ccw = true;
    private boolean solid = true;
    private VrmlCoordinate coord = null;
    private VrmlNormal normal = null;
    private boolean normalPerVertex = true;
    private VrmlTextureCoordinate texCoord = null;
    private int[] coordIndex = null;
    private int[] texCoordIndex = null;
    private int[] normalIndex = null;

    public TexCoord2f[] getTextureCoordinates() {
        if (this.texCoord == null) {
            return null;
        }
        return this.texCoord.getTextureCoordinates();
    }

    public int[] getCoordIndexes() {
        return this.coordIndex;
    }

    private void printArray(PrintWriter pw, String indent, int[] vals, int wrap) {
        if (vals == null) {
            return;
        }
        pw.print(indent);
        int i = 0;
        int n = 0;
        while (i < vals.length) {
            if (wrap > 0 && n >= wrap) {
                pw.println();
                pw.print(indent);
                n = 0;
            }
            pw.print(" ");
            pw.print(vals[i]);
            pw.print(",");
            ++i;
            ++n;
        }
        pw.println();
    }

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("IndexedFaceSet");
        pw.println(" {");
        String indent2 = indent + "  ";
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_CCW, this.ccw));
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_SOLID, this.solid));
        if (this.coord != null) {
            pw.print(indent2);
            pw.print(PROP_COORD);
            pw.print(" ");
            this.coord.outputVrml(pw, indent2);
        }
        if (this.normal != null) {
            pw.print(indent2);
            pw.print(PROP_NORMAL);
            pw.print(" ");
            this.normal.outputVrml(pw, indent2);
        }
        pw.print(indent2);
        pw.println(this.toVrmlString(PROP_NPVERT, this.normalPerVertex));
        if (this.texCoord != null) {
            pw.print(indent2);
            pw.print(PROP_TEXCOORD);
            pw.print(" ");
            this.texCoord.outputVrml(pw, indent2);
        }
        String indent3 = indent2 + "  ";
        pw.print(indent2);
        pw.print(PROP_COORDIDX);
        pw.println(" [");
        this.printArray(pw, indent3, this.coordIndex, 12);
        pw.print(indent2);
        pw.println("]");
        pw.print(indent2);
        pw.print(PROP_TEXCRDIDX);
        pw.println(" [");
        this.printArray(pw, indent3, this.texCoordIndex, 12);
        pw.print(indent2);
        pw.println("]");
        pw.print(indent2);
        pw.print(PROP_NORMALIDX);
        pw.println(" [");
        this.printArray(pw, indent3, this.normalIndex, 12);
        pw.print(indent2);
        pw.println("]");
        pw.print(indent);
        pw.println("}");
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  ").append(PROP_CCW).append(": ").append(this.ccw);
        sb.append("\n  ").append(PROP_SOLID).append(": ").append(this.solid);
        sb.append("\n  ").append(PROP_COORD).append(": ").append(this.coord);
        sb.append("\n  ").append(PROP_NORMAL).append(": ").append(this.normal);
        sb.append("\n  ").append(PROP_NPVERT).append(": ").append(this.normalPerVertex);
        sb.append("\n  ").append(PROP_TEXCOORD).append(": ").append(this.texCoord);
        if (this.coordIndex != null) {
            sb.append("\n  ").append(PROP_COORDIDX).append(": [\n  ");
            i = 0;
            while (i < this.coordIndex.length) {
                sb.append(this.coordIndex[i]).append(",");
                ++i;
            }
            sb.append("\n  ]");
        }
        if (this.texCoordIndex != null) {
            sb.append("\n  ").append(PROP_TEXCRDIDX).append(": [\n  ");
            i = 0;
            while (i < this.texCoordIndex.length) {
                sb.append(this.texCoordIndex[i]).append(",");
                ++i;
            }
            sb.append("\n  ]");
        }
        if (this.normalIndex != null) {
            sb.append("\n  ").append(PROP_NORMALIDX).append(": [\n  ");
            i = 0;
            while (i < this.normalIndex.length) {
                sb.append(this.normalIndex[i]).append(",");
                ++i;
            }
            sb.append("\n  ]");
        }
        return sb.toString();
    }

    public VrmlIndexedFaceSet() {
    }

    public VrmlIndexedFaceSet(VrmlCoordinate coord, VrmlNormal normal, VrmlTextureCoordinate texCoord, int[] coordIndex, int[] normalIndex, int[] texCoordIndex) {
        this.coord = coord;
        this.normal = normal;
        this.texCoord = texCoord;
        this.coordIndex = coordIndex;
        this.normalIndex = normalIndex;
        this.texCoordIndex = texCoordIndex;
    }

    public int[] getNormalIndexes() {
        return this.normalIndex;
    }

    public Vector3d[] makeNormalsLeft() {
        if (this.normal == null) {
            return null;
        }
        Vector3d[] vector = this.normal.getNormals();
        if (vector == null) {
            return null;
        }
        Vector3d[] copy = new Vector3d[vector.length];
        int i = 0;
        while (i < vector.length) {
            copy[i] = new Vector3d(vector[i].x, vector[i].y, -vector[i].z);
            ++i;
        }
        return copy;
    }

    public int[] getTexCoordIndexes() {
        return this.texCoordIndex;
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            Boolean value;
            if (PROP_CCW.equals(objs[i])) {
                value = this.makeBoolValue(objs, i);
                if (value != null) {
                    this.ccw = value;
                    ++i;
                }
            } else if (PROP_SOLID.equals(objs[i])) {
                value = this.makeBoolValue(objs, i);
                if (value != null) {
                    this.solid = value;
                    ++i;
                }
            } else if (PROP_NPVERT.equals(objs[i])) {
                value = this.makeBoolValue(objs, i);
                if (value != null) {
                    this.normalPerVertex = value;
                    ++i;
                }
            } else if (PROP_COORD.equals(objs[i])) {
                if (i + 1 < objs.length && objs[i + 1] instanceof VrmlCoordinate) {
                    this.coord = (VrmlCoordinate)objs[i + 1];
                    ++i;
                }
            } else if (PROP_NORMAL.equals(objs[i])) {
                if (i + 1 < objs.length && objs[i + 1] instanceof VrmlNormal) {
                    this.normal = (VrmlNormal)objs[i + 1];
                    ++i;
                }
            } else if (PROP_TEXCOORD.equals(objs[i])) {
                if (i + 1 < objs.length && objs[i + 1] instanceof VrmlTextureCoordinate) {
                    this.texCoord = (VrmlTextureCoordinate)objs[i + 1];
                    ++i;
                }
            } else if (PROP_COORDIDX.equals(objs[i])) {
                if (i + 1 < objs.length && objs[i + 1] instanceof Vector) {
                    this.coordIndex = this.makeIndexes((Vector)objs[i + 1]);
                    ++i;
                }
            } else if (PROP_TEXCRDIDX.equals(objs[i])) {
                if (i + 1 < objs.length && objs[i + 1] instanceof Vector) {
                    this.texCoordIndex = this.makeIndexes((Vector)objs[i + 1]);
                    ++i;
                }
            } else if (PROP_NORMALIDX.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof Vector) {
                this.normalIndex = this.makeIndexes((Vector)objs[i + 1]);
                ++i;
            }
            ++i;
        }
    }

    private int[] makeIndexes(Vector values) {
        try {
            int[] indexes = new int[values.size()];
            int i = 0;
            while (i < values.size()) {
                Vector val = (Vector)values.get(i);
                if (val.size() != 1) {
                    return null;
                }
                indexes[i] = ((Double)val.get(0)).intValue();
                ++i;
            }
            return indexes;
        }
        catch (ClassCastException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public Point3d[] makeCoordinatesLeft() {
        if (this.coord == null) {
            return null;
        }
        Point3d[] point = this.coord.getCoordinates();
        if (point == null) {
            return null;
        }
        Point3d[] copy = new Point3d[point.length];
        int i = 0;
        while (i < point.length) {
            copy[i] = new Point3d(point[i].x, point[i].y, -point[i].z);
            ++i;
        }
        return copy;
    }
}

