/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.vecmath.Point3d;
import vrml.VrmlObj;

public class VrmlCoordinate
extends VrmlObj {
    private static final String PROP_POINT = "point";
    private Point3d[] point = null;

    private Point3d[] makePoints(Vector values) {
        try {
            ArrayList<Point3d> ar = new ArrayList<Point3d>();
            int i = 0;
            while (i < values.size()) {
                Vector val = (Vector)values.get(i);
                if (val.size() != 3) {
                    return null;
                }
                ar.add(new Point3d(((Double)val.get(0)).doubleValue(), ((Double)val.get(1)).doubleValue(), ((Double)val.get(2)).doubleValue()));
                ++i;
            }
            return ar.toArray(new Point3d[ar.size()]);
        }
        catch (ClassCastException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("Coordinate");
        pw.print(" { ");
        String indent2 = indent + "  ";
        if (this.point != null) {
            pw.print(PROP_POINT);
            pw.print(" [");
            int i = 0;
            int j = 0;
            while (i < this.point.length) {
                if (j > 2) {
                    j = 0;
                }
                if (j == 0) {
                    pw.println();
                    pw.print(indent2);
                }
                pw.print(VrmlObj.dblFormat.format(this.point[i].x));
                pw.print(" ");
                pw.print(VrmlObj.dblFormat.format(this.point[i].y));
                pw.print(" ");
                pw.print(VrmlObj.dblFormat.format(this.point[i].z));
                pw.print(", ");
                ++i;
                ++j;
            }
            pw.println(" ]");
        }
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.point != null) {
            sb.append("\n  ").append(PROP_POINT).append(": [");
            int i = 0;
            while (i < this.point.length) {
                sb.append("\n    ").append(this.point[i].x).append(" ").append(this.point[i].y).append(" ").append(this.point[i].z);
                ++i;
            }
            sb.append("\n  ]");
        }
        return sb.toString();
    }

    public VrmlCoordinate() {
    }

    public VrmlCoordinate(Point3d[] points) {
        this.point = points;
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            if (PROP_POINT.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof Vector) {
                this.point = this.makePoints((Vector)objs[i + 1]);
                ++i;
            }
            ++i;
        }
    }

    public Point3d[] getCoordinates() {
        return this.point;
    }
}

