/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.awt.Image;
import java.io.PrintWriter;
import java.util.Vector;
import vrml.VrmlImageTexture;
import vrml.VrmlMaterial;
import vrml.VrmlObj;

public class VrmlAppearance
extends VrmlObj {
    private static final String PROP_MATERIAL = "material";
    private static final String PROP_TEXTURE = "texture";
    private VrmlMaterial material = null;
    private VrmlImageTexture texture = null;

    public Image getTextureImage() {
        if (this.texture == null) {
            return null;
        }
        return this.texture.getImage();
    }

    public void outputVrml(PrintWriter pw, String indent) {
        pw.print(this.getVrmlName());
        pw.print("Appearance");
        pw.println(" {");
        String indent2 = indent + "  ";
        if (this.material != null) {
            pw.print(indent2 + PROP_MATERIAL);
            pw.print(" ");
            this.material.outputVrml(pw, indent2);
        }
        if (this.texture != null) {
            pw.print(indent2 + PROP_TEXTURE);
            pw.print(" ");
            this.texture.outputVrml(pw, indent2);
        }
        pw.println(indent + "}");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n  ").append(PROP_MATERIAL).append(" {\n").append(this.material).append("\n  }");
        sb.append("\n  ").append(PROP_TEXTURE).append(" {\n").append(this.texture).append("\n  }");
        return sb.toString();
    }

    public VrmlAppearance() {
    }

    public VrmlAppearance(VrmlMaterial material, VrmlImageTexture texture) {
        this.material = material;
        this.texture = texture;
    }

    public double[] getSpecularColor() {
        if (this.material == null) {
            return null;
        }
        return this.material.getSpecularColor();
    }

    public void setProperties(Vector params) {
        Object[] objs = params.toArray(new Object[params.size()]);
        int i = 0;
        while (i < objs.length) {
            if (PROP_MATERIAL.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof VrmlMaterial) {
                this.material = (VrmlMaterial)objs[i + 1];
                ++i;
            }
            if (PROP_TEXTURE.equals(objs[i]) && i + 1 < objs.length && objs[i + 1] instanceof VrmlImageTexture) {
                this.texture = (VrmlImageTexture)objs[i + 1];
                ++i;
            }
            ++i;
        }
    }

    public double[] getDiffuseColor() {
        if (this.material == null) {
            return null;
        }
        return this.material.getDiffuseColor();
    }

    public double[] getEmissiveColor() {
        if (this.material == null) {
            return null;
        }
        return this.material.getEmissiveColor();
    }

    public VrmlImageTexture getTexture() {
        return this.texture;
    }
}

