/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class Ray
implements Cloneable {
    protected Vector3d m_origin = null;
    protected Vector3d m_direction = null;

    public Ray() {
        this(new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0));
    }

    public Ray(Vector3d origin, Vector3d direction) {
        this.setOrigin(origin);
        this.setDirection(direction);
    }

    public synchronized Object clone() {
        try {
            Ray ray = (Ray)super.clone();
            ray.setOrigin(new Vector3d(this.m_origin));
            ray.setDirection(new Vector3d(this.m_direction));
            return ray;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Ray) {
            Ray ray = (Ray)o;
            return this.m_origin.equals((Tuple3d)ray.m_origin) && this.m_direction.equals((Tuple3d)ray.m_direction);
        }
        return false;
    }

    public Vector3d getOrigin() {
        if (this.m_origin != null) {
            return new Vector3d(this.m_origin);
        }
        return null;
    }

    public void setOrigin(Vector3d origin) {
        this.m_origin = origin != null ? new Vector3d(origin) : null;
    }

    public Vector3d getDirection() {
        if (this.m_direction != null) {
            return new Vector3d(this.m_direction);
        }
        return null;
    }

    public void setDirection(Vector3d direction) {
        this.m_direction = direction != null ? new Vector3d(direction) : null;
    }

    public Vector3d getPoint(double t) {
        Vector3d p = new Vector3d(this.m_direction);
        p.scale(t);
        p.add((Tuple3d)this.m_origin);
        return p;
    }

    public void transform(Matrix4d m) {
        Vector4 transformedOrigin = Vector4.multiply(new Vector4((Tuple3d)this.m_origin, 1.0), m);
        this.m_origin = new Vector3((Tuple4d)transformedOrigin);
        Vector4 transformedDirection = Vector4.multiply(new Vector4((Tuple3d)this.m_direction, 0.0), m);
        transformedDirection.w = 1.0;
        this.m_direction = new Vector3((Tuple4d)transformedDirection);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Ray[origin=" + this.m_origin + ",direction=" + this.m_direction + "]";
    }
}

