/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import edu.cmu.cs.stage3.io.image.codec.SeekableStream;
import edu.cmu.cs.stage3.io.image.codec.TIFFField;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TIFFDirectory {
    SeekableStream stream;
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Hashtable fieldIndex = new Hashtable();
    private static final int[] sizeOfType;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        sizeOfType = nArray;
    }

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int endian) {
        return endian == 18761 || endian == 19789;
    }

    public TIFFDirectory(SeekableStream stream, int directory) throws IOException {
        this.stream = stream;
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        this.isBigEndian = endian == 19789;
        int magic = this.readUnsignedShort(stream);
        if (magic != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory2"));
        }
        long ifd_offset = this.readUnsignedInt(stream);
        int i = 0;
        while (i < directory) {
            if (ifd_offset == 0L) {
                throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory3"));
            }
            stream.seek(ifd_offset);
            int entries = this.readUnsignedShort(stream);
            stream.skip(12 * entries);
            ifd_offset = this.readUnsignedInt(stream);
            ++i;
        }
        stream.seek(ifd_offset);
        this.initialize();
        stream.seek(global_save_offset);
    }

    public TIFFDirectory(SeekableStream stream, long ifd_offset) throws IOException {
        this.stream = stream;
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        this.isBigEndian = endian == 19789;
        stream.seek(ifd_offset);
        this.initialize();
        stream.seek(global_save_offset);
    }

    private void initialize() throws IOException {
        this.numEntries = this.readUnsignedShort(this.stream);
        this.fields = new TIFFField[this.numEntries];
        int i = 0;
        while (i < this.numEntries) {
            block27: {
                long nextTagOffset;
                int count;
                int type;
                int tag;
                block26: {
                    tag = this.readUnsignedShort(this.stream);
                    type = this.readUnsignedShort(this.stream);
                    count = (int)this.readUnsignedInt(this.stream);
                    int value = 0;
                    nextTagOffset = this.stream.getFilePointer() + 4L;
                    try {
                        if (count * sizeOfType[type] <= 4) break block26;
                        value = (int)this.readUnsignedInt(this.stream);
                        this.stream.seek(value);
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                        System.err.println(String.valueOf(tag) + " " + JaiI18N.getString("TIFFDirectory4"));
                        this.stream.seek(nextTagOffset);
                        break block27;
                    }
                }
                this.fieldIndex.put(new Integer(tag), new Integer(i));
                Object obj = null;
                switch (type) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        byte[] bvalues = new byte[count];
                        this.stream.readFully(bvalues, 0, count);
                        if (type == 2) {
                            int index = 0;
                            int prevIndex = 0;
                            Vector<String> v = new Vector<String>();
                            while (index < count) {
                                while (index < count && bvalues[index++] != 0) {
                                }
                                v.add(new String(bvalues, prevIndex, index - prevIndex));
                                prevIndex = index;
                            }
                            count = v.size();
                            String[] strings = new String[count];
                            int c = 0;
                            while (c < count) {
                                strings[c] = (String)v.elementAt(c);
                                ++c;
                            }
                            obj = strings;
                            break;
                        }
                        obj = bvalues;
                        break;
                    }
                    case 3: {
                        char[] cvalues = new char[count];
                        int j = 0;
                        while (j < count) {
                            cvalues[j] = (char)this.readUnsignedShort(this.stream);
                            ++j;
                        }
                        obj = cvalues;
                        break;
                    }
                    case 4: {
                        long[] lvalues = new long[count];
                        int j = 0;
                        while (j < count) {
                            lvalues[j] = this.readUnsignedInt(this.stream);
                            ++j;
                        }
                        obj = lvalues;
                        break;
                    }
                    case 5: {
                        long[][] llvalues = new long[count][2];
                        int j = 0;
                        while (j < count) {
                            llvalues[j][0] = this.readUnsignedInt(this.stream);
                            llvalues[j][1] = this.readUnsignedInt(this.stream);
                            ++j;
                        }
                        obj = llvalues;
                        break;
                    }
                    case 8: {
                        short[] svalues = new short[count];
                        int j = 0;
                        while (j < count) {
                            svalues[j] = this.readShort(this.stream);
                            ++j;
                        }
                        obj = svalues;
                        break;
                    }
                    case 9: {
                        int[] ivalues = new int[count];
                        int j = 0;
                        while (j < count) {
                            ivalues[j] = this.readInt(this.stream);
                            ++j;
                        }
                        obj = ivalues;
                        break;
                    }
                    case 10: {
                        int[][] iivalues = new int[count][2];
                        int j = 0;
                        while (j < count) {
                            iivalues[j][0] = this.readInt(this.stream);
                            iivalues[j][1] = this.readInt(this.stream);
                            ++j;
                        }
                        obj = iivalues;
                        break;
                    }
                    case 11: {
                        float[] fvalues = new float[count];
                        int j = 0;
                        while (j < count) {
                            fvalues[j] = this.readFloat(this.stream);
                            ++j;
                        }
                        obj = fvalues;
                        break;
                    }
                    case 12: {
                        double[] dvalues = new double[count];
                        int j = 0;
                        while (j < count) {
                            dvalues[j] = this.readDouble(this.stream);
                            ++j;
                        }
                        obj = dvalues;
                        break;
                    }
                    default: {
                        System.err.println(JaiI18N.getString("TIFFDirectory0"));
                    }
                }
                this.fields[i] = new TIFFField(tag, type, count, obj);
                this.stream.seek(nextTagOffset);
            }
            ++i;
        }
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int tag) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        if (i == null) {
            return null;
        }
        return this.fields[i];
    }

    public boolean isTagPresent(int tag) {
        return this.fieldIndex.containsKey(new Integer(tag));
    }

    public int[] getTags() {
        int[] tags = new int[this.fieldIndex.size()];
        Enumeration enumeration = this.fieldIndex.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            tags[i++] = (Integer)enumeration.nextElement();
        }
        return tags;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        byte[] b = this.fields[i].getAsBytes();
        return b[index];
    }

    public byte getFieldAsByte(int tag) {
        return this.getFieldAsByte(tag, 0);
    }

    public long getFieldAsLong(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        return this.fields[i].getAsLong(index);
    }

    public long getFieldAsLong(int tag) {
        return this.getFieldAsLong(tag, 0);
    }

    public float getFieldAsFloat(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        return this.fields[i].getAsFloat(index);
    }

    public float getFieldAsFloat(int tag) {
        return this.getFieldAsFloat(tag, 0);
    }

    public double getFieldAsDouble(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        return this.fields[i].getAsDouble(index);
    }

    public double getFieldAsDouble(int tag) {
        return this.getFieldAsDouble(tag, 0);
    }

    private short readShort(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readShort();
        }
        return stream.readShortLE();
    }

    private int readUnsignedShort(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private int readInt(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readInt();
        }
        return stream.readIntLE();
    }

    private long readUnsignedInt(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    private long readLong(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readLong();
        }
        return stream.readLongLE();
    }

    private float readFloat(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readFloat();
        }
        return stream.readFloatLE();
    }

    private double readDouble(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readDouble();
        }
        return stream.readDoubleLE();
    }

    private static int readUnsignedShort(SeekableStream stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(SeekableStream stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    public static int getNumDirectories(SeekableStream stream) throws IOException {
        long pointer = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory1"));
        }
        boolean isBigEndian = endian == 19789;
        int magic = TIFFDirectory.readUnsignedShort(stream, isBigEndian);
        if (magic != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFDirectory2"));
        }
        stream.seek(4L);
        long offset = TIFFDirectory.readUnsignedInt(stream, isBigEndian);
        int numDirectories = 0;
        while (offset != 0L) {
            ++numDirectories;
            stream.seek(offset);
            int entries = TIFFDirectory.readUnsignedShort(stream, isBigEndian);
            stream.skip(12 * entries);
            offset = TIFFDirectory.readUnsignedInt(stream, isBigEndian);
        }
        stream.seek(pointer);
        return numDirectories;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }
}

