/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import edu.cmu.cs.stage3.io.image.codec.FPXDecodeParam;
import edu.cmu.cs.stage3.io.image.codec.FPXUtils;
import edu.cmu.cs.stage3.io.image.codec.ImageCodec;
import edu.cmu.cs.stage3.io.image.codec.PropertySet;
import edu.cmu.cs.stage3.io.image.codec.RasterFactory;
import edu.cmu.cs.stage3.io.image.codec.SeekableStream;
import edu.cmu.cs.stage3.io.image.codec.SimpleRenderedImage;
import edu.cmu.cs.stage3.io.image.codec.StructuredStorage;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FPXImage
extends SimpleRenderedImage {
    private static final int SUBIMAGE_COLOR_SPACE_COLORLESS = 0;
    private static final int SUBIMAGE_COLOR_SPACE_MONOCHROME = 0;
    private static final int SUBIMAGE_COLOR_SPACE_PHOTOYCC = 0;
    private static final int SUBIMAGE_COLOR_SPACE_NIFRGB = 0;
    private static final String[] COLORSPACE_NAME = new String[]{"Colorless", "Monochrome", "PhotoYCC", "NIF RGB"};
    StructuredStorage storage;
    int numResolutions;
    int highestResWidth;
    int highestResHeight;
    float defaultDisplayHeight;
    float defaultDisplayWidth;
    int displayHeightWidthUnits;
    boolean[] subimageValid;
    int[] subimageWidth;
    int[] subimageHeight;
    int[][] subimageColor;
    int[] decimationMethod;
    float[] decimationPrefilterWidth;
    int highestResolution = -1;
    int maxJPEGTableIndex;
    byte[][] JPEGTable;
    int numChannels;
    int tileHeaderTableOffset;
    int tileHeaderEntryLength;
    SeekableStream subimageHeaderStream;
    SeekableStream subimageDataStream;
    int resolution;
    int tilesAcross;
    int[] bandOffsets;
    private static final int[] RGBBits8 = new int[]{8, 8, 8};
    private static final ComponentColorModel colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1004), RGBBits8, false, false, 1, 0);
    private static final byte[] PhotoYCCToRGBLUT;
    Hashtable properties;

    static {
        byte[] byArray = new byte[361];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 2;
        byArray[5] = 3;
        byArray[6] = 4;
        byArray[7] = 5;
        byArray[8] = 6;
        byArray[9] = 7;
        byArray[10] = 8;
        byArray[11] = 9;
        byArray[12] = 10;
        byArray[13] = 11;
        byArray[14] = 12;
        byArray[15] = 13;
        byArray[16] = 14;
        byArray[17] = 15;
        byArray[18] = 16;
        byArray[19] = 17;
        byArray[20] = 18;
        byArray[21] = 19;
        byArray[22] = 20;
        byArray[23] = 22;
        byArray[24] = 23;
        byArray[25] = 24;
        byArray[26] = 25;
        byArray[27] = 26;
        byArray[28] = 28;
        byArray[29] = 29;
        byArray[30] = 30;
        byArray[31] = 31;
        byArray[32] = 33;
        byArray[33] = 34;
        byArray[34] = 35;
        byArray[35] = 36;
        byArray[36] = 38;
        byArray[37] = 39;
        byArray[38] = 40;
        byArray[39] = 41;
        byArray[40] = 43;
        byArray[41] = 44;
        byArray[42] = 45;
        byArray[43] = 47;
        byArray[44] = 48;
        byArray[45] = 49;
        byArray[46] = 51;
        byArray[47] = 52;
        byArray[48] = 53;
        byArray[49] = 55;
        byArray[50] = 56;
        byArray[51] = 57;
        byArray[52] = 59;
        byArray[53] = 60;
        byArray[54] = 61;
        byArray[55] = 63;
        byArray[56] = 64;
        byArray[57] = 65;
        byArray[58] = 67;
        byArray[59] = 68;
        byArray[60] = 70;
        byArray[61] = 71;
        byArray[62] = 72;
        byArray[63] = 74;
        byArray[64] = 75;
        byArray[65] = 76;
        byArray[66] = 78;
        byArray[67] = 79;
        byArray[68] = 81;
        byArray[69] = 82;
        byArray[70] = 83;
        byArray[71] = 85;
        byArray[72] = 86;
        byArray[73] = 88;
        byArray[74] = 89;
        byArray[75] = 91;
        byArray[76] = 92;
        byArray[77] = 93;
        byArray[78] = 95;
        byArray[79] = 96;
        byArray[80] = 98;
        byArray[81] = 99;
        byArray[82] = 101;
        byArray[83] = 102;
        byArray[84] = 103;
        byArray[85] = 105;
        byArray[86] = 106;
        byArray[87] = 108;
        byArray[88] = 109;
        byArray[89] = 111;
        byArray[90] = 112;
        byArray[91] = 113;
        byArray[92] = 115;
        byArray[93] = 116;
        byArray[94] = 118;
        byArray[95] = 119;
        byArray[96] = 121;
        byArray[97] = 122;
        byArray[98] = 123;
        byArray[99] = 125;
        byArray[100] = 126;
        byArray[101] = -128;
        byArray[102] = -127;
        byArray[103] = -126;
        byArray[104] = -124;
        byArray[105] = -123;
        byArray[106] = -122;
        byArray[107] = -120;
        byArray[108] = -119;
        byArray[109] = -118;
        byArray[110] = -116;
        byArray[111] = -115;
        byArray[112] = -114;
        byArray[113] = -112;
        byArray[114] = -111;
        byArray[115] = -110;
        byArray[116] = -108;
        byArray[117] = -107;
        byArray[118] = -106;
        byArray[119] = -104;
        byArray[120] = -103;
        byArray[121] = -102;
        byArray[122] = -101;
        byArray[123] = -99;
        byArray[124] = -98;
        byArray[125] = -97;
        byArray[126] = -96;
        byArray[127] = -94;
        byArray[128] = -93;
        byArray[129] = -92;
        byArray[130] = -91;
        byArray[131] = -90;
        byArray[132] = -88;
        byArray[133] = -87;
        byArray[134] = -86;
        byArray[135] = -85;
        byArray[136] = -84;
        byArray[137] = -82;
        byArray[138] = -81;
        byArray[139] = -80;
        byArray[140] = -79;
        byArray[141] = -78;
        byArray[142] = -77;
        byArray[143] = -76;
        byArray[144] = -74;
        byArray[145] = -73;
        byArray[146] = -72;
        byArray[147] = -71;
        byArray[148] = -70;
        byArray[149] = -69;
        byArray[150] = -68;
        byArray[151] = -67;
        byArray[152] = -66;
        byArray[153] = -65;
        byArray[154] = -64;
        byArray[155] = -62;
        byArray[156] = -61;
        byArray[157] = -60;
        byArray[158] = -59;
        byArray[159] = -58;
        byArray[160] = -57;
        byArray[161] = -56;
        byArray[162] = -55;
        byArray[163] = -54;
        byArray[164] = -53;
        byArray[165] = -52;
        byArray[166] = -52;
        byArray[167] = -51;
        byArray[168] = -50;
        byArray[169] = -49;
        byArray[170] = -48;
        byArray[171] = -47;
        byArray[172] = -46;
        byArray[173] = -45;
        byArray[174] = -44;
        byArray[175] = -43;
        byArray[176] = -43;
        byArray[177] = -42;
        byArray[178] = -41;
        byArray[179] = -40;
        byArray[180] = -39;
        byArray[181] = -39;
        byArray[182] = -38;
        byArray[183] = -37;
        byArray[184] = -36;
        byArray[185] = -35;
        byArray[186] = -35;
        byArray[187] = -34;
        byArray[188] = -33;
        byArray[189] = -33;
        byArray[190] = -32;
        byArray[191] = -31;
        byArray[192] = -31;
        byArray[193] = -30;
        byArray[194] = -29;
        byArray[195] = -29;
        byArray[196] = -28;
        byArray[197] = -27;
        byArray[198] = -27;
        byArray[199] = -26;
        byArray[200] = -26;
        byArray[201] = -25;
        byArray[202] = -25;
        byArray[203] = -24;
        byArray[204] = -23;
        byArray[205] = -23;
        byArray[206] = -22;
        byArray[207] = -22;
        byArray[208] = -21;
        byArray[209] = -21;
        byArray[210] = -20;
        byArray[211] = -20;
        byArray[212] = -20;
        byArray[213] = -19;
        byArray[214] = -19;
        byArray[215] = -18;
        byArray[216] = -18;
        byArray[217] = -18;
        byArray[218] = -17;
        byArray[219] = -17;
        byArray[220] = -16;
        byArray[221] = -16;
        byArray[222] = -16;
        byArray[223] = -15;
        byArray[224] = -15;
        byArray[225] = -15;
        byArray[226] = -14;
        byArray[227] = -14;
        byArray[228] = -14;
        byArray[229] = -14;
        byArray[230] = -13;
        byArray[231] = -13;
        byArray[232] = -13;
        byArray[233] = -12;
        byArray[234] = -12;
        byArray[235] = -12;
        byArray[236] = -12;
        byArray[237] = -11;
        byArray[238] = -11;
        byArray[239] = -11;
        byArray[240] = -11;
        byArray[241] = -11;
        byArray[242] = -10;
        byArray[243] = -10;
        byArray[244] = -10;
        byArray[245] = -10;
        byArray[246] = -10;
        byArray[247] = -9;
        byArray[248] = -9;
        byArray[249] = -9;
        byArray[250] = -9;
        byArray[251] = -9;
        byArray[252] = -9;
        byArray[253] = -8;
        byArray[254] = -8;
        byArray[255] = -8;
        byArray[256] = -8;
        byArray[257] = -8;
        byArray[258] = -8;
        byArray[259] = -7;
        byArray[260] = -7;
        byArray[261] = -7;
        byArray[262] = -7;
        byArray[263] = -7;
        byArray[264] = -7;
        byArray[265] = -7;
        byArray[266] = -7;
        byArray[267] = -7;
        byArray[268] = -6;
        byArray[269] = -6;
        byArray[270] = -6;
        byArray[271] = -6;
        byArray[272] = -6;
        byArray[273] = -6;
        byArray[274] = -6;
        byArray[275] = -6;
        byArray[276] = -6;
        byArray[277] = -6;
        byArray[278] = -5;
        byArray[279] = -5;
        byArray[280] = -5;
        byArray[281] = -5;
        byArray[282] = -5;
        byArray[283] = -5;
        byArray[284] = -5;
        byArray[285] = -5;
        byArray[286] = -5;
        byArray[287] = -5;
        byArray[288] = -5;
        byArray[289] = -5;
        byArray[290] = -5;
        byArray[291] = -5;
        byArray[292] = -4;
        byArray[293] = -4;
        byArray[294] = -4;
        byArray[295] = -4;
        byArray[296] = -4;
        byArray[297] = -4;
        byArray[298] = -4;
        byArray[299] = -4;
        byArray[300] = -4;
        byArray[301] = -4;
        byArray[302] = -4;
        byArray[303] = -4;
        byArray[304] = -4;
        byArray[305] = -4;
        byArray[306] = -4;
        byArray[307] = -4;
        byArray[308] = -4;
        byArray[309] = -3;
        byArray[310] = -3;
        byArray[311] = -3;
        byArray[312] = -3;
        byArray[313] = -3;
        byArray[314] = -3;
        byArray[315] = -3;
        byArray[316] = -3;
        byArray[317] = -3;
        byArray[318] = -3;
        byArray[319] = -3;
        byArray[320] = -3;
        byArray[321] = -3;
        byArray[322] = -3;
        byArray[323] = -3;
        byArray[324] = -3;
        byArray[325] = -3;
        byArray[326] = -3;
        byArray[327] = -2;
        byArray[328] = -2;
        byArray[329] = -2;
        byArray[330] = -2;
        byArray[331] = -2;
        byArray[332] = -2;
        byArray[333] = -2;
        byArray[334] = -2;
        byArray[335] = -2;
        byArray[336] = -2;
        byArray[337] = -2;
        byArray[338] = -2;
        byArray[339] = -2;
        byArray[340] = -2;
        byArray[341] = -2;
        byArray[342] = -1;
        byArray[343] = -1;
        byArray[344] = -1;
        byArray[345] = -1;
        byArray[346] = -1;
        byArray[347] = -1;
        byArray[348] = -1;
        byArray[349] = -1;
        byArray[350] = -1;
        byArray[351] = -1;
        byArray[352] = -1;
        byArray[353] = -1;
        byArray[354] = -1;
        byArray[355] = -1;
        byArray[356] = -1;
        byArray[357] = -1;
        byArray[358] = -1;
        byArray[359] = -1;
        byArray[360] = -1;
        PhotoYCCToRGBLUT = byArray;
    }

    public FPXImage(SeekableStream stream, FPXDecodeParam param) throws IOException {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.bandOffsets = nArray;
        this.properties = null;
        this.storage = new StructuredStorage(stream);
        this.readImageContents();
        if (param == null) {
            param = new FPXDecodeParam();
        }
        this.resolution = param.getResolution();
        this.readResolution();
        this.bandOffsets = new int[this.numChannels];
        int i = 0;
        while (i < this.numChannels) {
            this.bandOffsets[i] = i;
            ++i;
        }
        this.minX = 0;
        this.minY = 0;
        this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numChannels, this.numChannels * this.tileWidth, this.bandOffsets);
        this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
    }

    private void readImageContents() throws IOException {
        int index;
        this.storage.changeDirectoryToRoot();
        this.storage.changeDirectory("Data Object Store 000001");
        SeekableStream imageContents = this.storage.getStream("\u0005Image Contents");
        PropertySet icps = new PropertySet(imageContents);
        this.numResolutions = (int)icps.getUI4(0x1000000);
        this.highestResWidth = (int)icps.getUI4(0x1000002);
        this.highestResHeight = (int)icps.getUI4(0x1000003);
        this.displayHeightWidthUnits = (int)icps.getUI4(0x1000006, 0L);
        this.subimageValid = new boolean[this.numResolutions];
        this.subimageWidth = new int[this.numResolutions];
        this.subimageHeight = new int[this.numResolutions];
        this.subimageColor = new int[this.numResolutions][];
        this.decimationMethod = new int[this.numResolutions];
        this.decimationPrefilterWidth = new float[this.numResolutions];
        int i = 0;
        while (i < this.numResolutions) {
            index = i << 16;
            if (!icps.hasProperty(0x2000000 | index)) break;
            this.highestResolution = i;
            this.subimageValid[i] = true;
            this.subimageWidth[i] = (int)icps.getUI4(0x2000000 | index);
            this.subimageHeight[i] = (int)icps.getUI4(0x2000001 | index);
            byte[] subimageColorBlob = icps.getBlob(0x2000002 | index);
            this.decimationMethod[i] = icps.getI4(0x2000004 | index);
            int numSubImages = FPXUtils.getIntLE(subimageColorBlob, 0);
            int numChannels = FPXUtils.getIntLE(subimageColorBlob, 4);
            this.subimageColor[i] = new int[numChannels];
            int c = 0;
            while (c < numChannels) {
                int color;
                this.subimageColor[i][c] = color = FPXUtils.getIntLE(subimageColorBlob, 8 + 4 * c);
                ++c;
            }
            ++i;
        }
        this.maxJPEGTableIndex = (int)icps.getUI4(0x3000002, -1L);
        this.JPEGTable = new byte[this.maxJPEGTableIndex + 1][];
        i = 0;
        while (i <= this.maxJPEGTableIndex) {
            index = i << 16;
            this.JPEGTable[i] = (byte[])(icps.hasProperty(0x3000001 | index) ? icps.getBlob(0x3000001 | index) : null);
            ++i;
        }
    }

    private void readResolution() throws IOException {
        if (this.resolution == -1) {
            this.resolution = this.highestResolution;
        }
        this.storage.changeDirectoryToRoot();
        this.storage.changeDirectory("Data Object Store 000001");
        this.storage.changeDirectory("Resolution 000" + this.resolution);
        this.subimageHeaderStream = this.storage.getStream("Subimage 0000 Header");
        this.subimageHeaderStream.skip(28L);
        int headerLength = this.subimageHeaderStream.readIntLE();
        this.width = this.subimageHeaderStream.readIntLE();
        this.height = this.subimageHeaderStream.readIntLE();
        int numTiles = this.subimageHeaderStream.readIntLE();
        this.tileWidth = this.subimageHeaderStream.readIntLE();
        this.tileHeight = this.subimageHeaderStream.readIntLE();
        this.numChannels = this.subimageHeaderStream.readIntLE();
        this.tileHeaderTableOffset = this.subimageHeaderStream.readIntLE() + 28;
        this.tileHeaderEntryLength = this.subimageHeaderStream.readIntLE();
        this.subimageDataStream = this.storage.getStream("Subimage 0000 Data");
        this.tilesAcross = (this.width + this.tileWidth - 1) / this.tileWidth;
    }

    private int getTileOffset(int tileIndex) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * tileIndex);
        return this.subimageHeaderStream.readIntLE() + 28;
    }

    private int getTileSize(int tileIndex) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * tileIndex + 4);
        return this.subimageHeaderStream.readIntLE();
    }

    private int getCompressionType(int tileIndex) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * tileIndex + 8);
        return this.subimageHeaderStream.readIntLE();
    }

    private int getCompressionSubtype(int tileIndex) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * tileIndex + 12);
        return this.subimageHeaderStream.readIntLE();
    }

    private final byte PhotoYCCToNIFRed(float scaledY, float Cb, float Cr) {
        float red = scaledY + 1.8215f * Cr - 249.55f;
        if (red < 0.0f) {
            return 0;
        }
        if (red > 360.0f) {
            return -1;
        }
        byte r = PhotoYCCToRGBLUT[(int)red];
        return r;
    }

    private final byte PhotoYCCToNIFGreen(float scaledY, float Cb, float Cr) {
        float green = scaledY - 0.43031f * Cb - 0.9271f * Cr + 194.14f;
        if (green < 0.0f) {
            return 0;
        }
        if (green > 360.0f) {
            return -1;
        }
        byte g = PhotoYCCToRGBLUT[(int)green];
        return g;
    }

    private final byte PhotoYCCToNIFBlue(float scaledY, float Cb, float Cr) {
        float blue = scaledY + 2.2179f * Cb - 345.99f;
        if (blue < 0.0f) {
            return 0;
        }
        if (blue > 360.0f) {
            return -1;
        }
        byte b = PhotoYCCToRGBLUT[(int)blue];
        return b;
    }

    private final byte YCCToNIFRed(float Y, float Cb, float Cr) {
        float red = Y + 1.402f * Cr - 178.75499f;
        if (red < 0.0f) {
            return 0;
        }
        if (red > 255.0f) {
            return -1;
        }
        return (byte)red;
    }

    private final byte YCCToNIFGreen(float Y, float Cb, float Cr) {
        float green = Y - 0.34414f * Cb - 0.71414f * Cr + 134.9307f;
        if (green < 0.0f) {
            return 0;
        }
        if (green > 255.0f) {
            return -1;
        }
        return (byte)green;
    }

    private final byte YCCToNIFBlue(float Y, float Cb, float Cr) {
        float blue = Y + 1.772f * Cb - 225.93f;
        if (blue < 0.0f) {
            return 0;
        }
        if (blue > 255.0f) {
            return -1;
        }
        return (byte)blue;
    }

    private Raster getUncompressedTile(int tileX, int tileY) throws IOException {
        int tx = this.tileXToX(tileX);
        int ty = this.tileYToY(tileY);
        WritableRaster ras = RasterFactory.createInterleavedRaster(0, this.tileWidth, this.tileHeight, this.numChannels * this.tileWidth, this.numChannels, this.bandOffsets, new Point(tx, ty));
        DataBufferByte dataBuffer = (DataBufferByte)ras.getDataBuffer();
        byte[] data = dataBuffer.getData();
        int tileIndex = tileY * this.tilesAcross + tileX;
        this.subimageDataStream.seek(this.getTileOffset(tileIndex));
        this.subimageDataStream.readFully(data, 0, this.numChannels * this.tileWidth * this.tileHeight);
        if (this.subimageColor[this.resolution][0] >> 16 == 2) {
            int size = this.tileWidth * this.tileHeight;
            int i = 0;
            while (i < size) {
                float Y = data[3 * i] & 0xFF;
                float Cb = data[3 * i + 1] & 0xFF;
                float Cr = data[3 * i + 2] & 0xFF;
                float scaledY = Y * 1.3584f;
                byte red = this.PhotoYCCToNIFRed(scaledY, Cb, Cr);
                byte green = this.PhotoYCCToNIFGreen(scaledY, Cb, Cr);
                byte blue = this.PhotoYCCToNIFBlue(scaledY, Cb, Cr);
                data[3 * i] = red;
                data[3 * i + 1] = green;
                data[3 * i + 2] = blue;
                ++i;
            }
        }
        return ras;
    }

    private Raster getSingleColorCompressedTile(int tileX, int tileY) throws IOException {
        WritableRaster ras;
        block4: {
            int pixels;
            byte blue;
            byte green;
            byte red;
            byte alpha;
            block5: {
                int tx = this.tileXToX(tileX);
                int ty = this.tileYToY(tileY);
                ras = RasterFactory.createInterleavedRaster(0, this.tileWidth, this.tileHeight, this.numChannels * this.tileWidth, this.numChannels, this.bandOffsets, new Point(tx, ty));
                int subimageColorType = this.subimageColor[this.resolution][0] >> 16;
                DataBufferByte dataBuffer = (DataBufferByte)ras.getDataBuffer();
                byte[] data = dataBuffer.getData();
                int tileIndex = tileY * this.tilesAcross + tileX;
                int color = this.getCompressionSubtype(tileIndex);
                byte c0 = (byte)(color >> 0 & 0xFF);
                byte c1 = (byte)(color >> 8 & 0xFF);
                byte c2 = (byte)(color >> 16 & 0xFF);
                alpha = (byte)(color >> 24 & 0xFF);
                if (this.subimageColor[this.resolution][0] >> 16 == 2) {
                    float Y = c0 & 0xFF;
                    float Cb = c1 & 0xFF;
                    float Cr = c2 & 0xFF;
                    float scaledY = Y * 1.3584f;
                    red = this.PhotoYCCToNIFRed(scaledY, Cb, Cr);
                    green = this.PhotoYCCToNIFGreen(scaledY, Cb, Cr);
                    blue = this.PhotoYCCToNIFBlue(scaledY, Cb, Cr);
                } else {
                    red = c0;
                    green = c1;
                    blue = c2;
                }
                int index = 0;
                pixels = this.tileWidth * this.tileHeight;
                if (this.numChannels == 1 || this.numChannels == 2) break block4;
                if (this.numChannels != 3) break block5;
                int i = 0;
                while (i < pixels) {
                    data[index + 0] = red;
                    data[index + 1] = green;
                    data[index + 2] = blue;
                    index += 3;
                    ++i;
                }
                break block4;
            }
            if (this.numChannels != 4) break block4;
            int i = 0;
            while (i < pixels) {
                data[index + 0] = red;
                data[index + 1] = green;
                data[index + 2] = blue;
                data[index + 3] = alpha;
                index += 4;
                ++i;
            }
        }
        return ras;
    }

    private Raster getJPEGCompressedTile(int tileX, int tileY) throws IOException {
        float Cr;
        float Cb;
        float Y;
        int i;
        int offset;
        JPEGImageDecoder dec;
        int tileIndex = tileY * this.tilesAcross + tileX;
        int tx = this.tileXToX(tileX);
        int ty = this.tileYToY(tileY);
        int subtype = this.getCompressionSubtype(tileIndex);
        int interleave = subtype >> 0 & 0xFF;
        int chroma = subtype >> 8 & 0xFF;
        int conversion = subtype >> 16 & 0xFF;
        int table = subtype >> 24 & 0xFF;
        JPEGDecodeParam param = null;
        if (table != 0) {
            ByteArrayInputStream tableStream = new ByteArrayInputStream(this.JPEGTable[table]);
            dec = JPEGCodec.createJPEGDecoder((InputStream)tableStream);
            Raster junk = dec.decodeAsRaster();
            param = dec.getJPEGDecodeParam();
        }
        this.subimageDataStream.seek(this.getTileOffset(tileIndex));
        dec = param != null ? JPEGCodec.createJPEGDecoder((InputStream)this.subimageDataStream, param) : JPEGCodec.createJPEGDecoder((InputStream)this.subimageDataStream);
        Raster ras = dec.decodeAsRaster().createTranslatedChild(tx, ty);
        DataBufferByte dataBuffer = (DataBufferByte)ras.getDataBuffer();
        byte[] data = dataBuffer.getData();
        int subimageColorType = this.subimageColor[this.resolution][0] >> 16;
        int size = this.tileWidth * this.tileHeight;
        if (conversion == 0 && subimageColorType == 2) {
            offset = 0;
            i = 0;
            while (i < size) {
                Y = data[offset] & 0xFF;
                Cb = data[offset + 1] & 0xFF;
                Cr = data[offset + 2] & 0xFF;
                float scaledY = Y * 1.3584f;
                byte red = this.PhotoYCCToNIFRed(scaledY, Cb, Cr);
                byte green = this.PhotoYCCToNIFGreen(scaledY, Cb, Cr);
                byte blue = this.PhotoYCCToNIFBlue(scaledY, Cb, Cr);
                data[offset] = red;
                data[offset + 1] = green;
                data[offset + 2] = blue;
                offset += this.numChannels;
                ++i;
            }
        } else if (conversion == 1 && subimageColorType == 3) {
            offset = 0;
            i = 0;
            while (i < size) {
                Y = data[offset] & 0xFF;
                Cb = data[offset + 1] & 0xFF;
                Cr = data[offset + 2] & 0xFF;
                byte red = this.YCCToNIFRed(Y, Cb, Cr);
                byte green = this.YCCToNIFGreen(Y, Cb, Cr);
                byte blue = this.YCCToNIFBlue(Y, Cb, Cr);
                data[offset] = red;
                data[offset + 1] = green;
                data[offset + 2] = blue;
                offset += this.numChannels;
                ++i;
            }
        }
        if (conversion == 1 && subimageColorType == 3 && this.numChannels == 4) {
            offset = 0;
            i = 0;
            while (i < size) {
                data[offset + 0] = (byte)(255 - data[offset + 0]);
                data[offset + 1] = (byte)(255 - data[offset + 1]);
                data[offset + 2] = (byte)(255 - data[offset + 2]);
                offset += 4;
                ++i;
            }
        }
        return ras;
    }

    public Raster getTile(int tileX, int tileY) {
        int tileIndex = tileY * this.tilesAcross + tileX;
        try {
            int ctype = this.getCompressionType(tileIndex);
            if (ctype == 0) {
                return this.getUncompressedTile(tileX, tileY);
            }
            if (ctype == 1) {
                return this.getSingleColorCompressedTile(tileX, tileY);
            }
            if (ctype == 2) {
                return this.getJPEGCompressedTile(tileX, tileY);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addLPSTRProperty(String name, PropertySet ps, int id) {
        String s = ps.getLPSTR(id);
        if (s != null) {
            this.properties.put(name.toLowerCase(), s);
        }
    }

    private void addLPWSTRProperty(String name, PropertySet ps, int id) {
        String s = ps.getLPWSTR(id);
        if (s != null) {
            this.properties.put(name.toLowerCase(), s);
        }
    }

    private void addUI4Property(String name, PropertySet ps, int id) {
        if (ps.hasProperty(id)) {
            long i = ps.getUI4(id);
            this.properties.put(name.toLowerCase(), new Integer((int)i));
        }
    }

    private void getSummaryInformation() {
        SeekableStream summaryInformation = null;
        PropertySet sips = null;
        try {
            this.storage.changeDirectoryToRoot();
            summaryInformation = this.storage.getStream("\u0005SummaryInformation");
            sips = new PropertySet(summaryInformation);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.addLPSTRProperty("title", sips, 2);
        this.addLPSTRProperty("subject", sips, 3);
        this.addLPSTRProperty("author", sips, 4);
        this.addLPSTRProperty("keywords", sips, 5);
        this.addLPSTRProperty("comments", sips, 6);
        this.addLPSTRProperty("template", sips, 7);
        this.addLPSTRProperty("last saved by", sips, 8);
        this.addLPSTRProperty("revision number", sips, 9);
    }

    private void getImageInfo() {
        SeekableStream imageInfo = null;
        PropertySet iips = null;
        try {
            this.storage.changeDirectoryToRoot();
            imageInfo = this.storage.getStream("\u0005Image Info");
            if (imageInfo == null) {
                return;
            }
            iips = new PropertySet(imageInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.addUI4Property("file source", iips, 0x21000000);
        this.addUI4Property("scene type", iips, 0x21000001);
        this.addLPWSTRProperty("software name/manufacturer/release", iips, 553648131);
        this.addLPWSTRProperty("user defined id", iips, 553648132);
        this.addLPWSTRProperty("copyright message", iips, 0x22000000);
        this.addLPWSTRProperty("legal broker for the original image", iips, 0x22000001);
        this.addLPWSTRProperty("legal broker for the digital image", iips, 0x22000002);
        this.addLPWSTRProperty("authorship", iips, 0x22000003);
        this.addLPWSTRProperty("intellectual property notes", iips, 0x22000004);
    }

    private synchronized void getProperties() {
        if (this.properties != null) {
            return;
        }
        this.properties = new Hashtable();
        this.getSummaryInformation();
        this.getImageInfo();
        this.properties.put("max_resolution", new Integer(this.highestResolution));
    }

    public String[] getPropertyNames() {
        this.getProperties();
        int len = this.properties.size();
        String[] names = new String[len];
        Enumeration enumeration = this.properties.keys();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            names[count++] = (String)enumeration.nextElement();
        }
        return names;
    }

    public Object getProperty(String name) {
        this.getProperties();
        return this.properties.get(name.toLowerCase());
    }
}

