/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.util;

import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.util.ProgressObserver;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class IndexedTriangleArrayUtil {
    public static int getProgressTotalForCalculateReversedIndexOrder(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray.getTriangleCount();
    }

    public static int[] calculateReversedIndexOrder(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        int[] indices = indexedTriangleArray.getIndices();
        int[] result = null;
        if (indices != null) {
            result = new int[indices.length];
            int index = 0;
            int i = 0;
            while (i < indexedTriangleArray.getTriangleCount()) {
                result[index] = indices[index + 2];
                result[index + 1] = indices[index + 1];
                result[index + 2] = indices[index];
                index += 3;
                if (progressObserver != null) {
                    progressObserver.progressUpdateCurrent(i);
                }
                ++i;
            }
        }
        return result;
    }

    private static Vector3d getDirection(Vertex3d vertexA, Vertex3d vertexB, Vertex3d vertexC) {
        Vector3d ba = new Vector3d();
        Vector3d bc = new Vector3d();
        ba.sub((Tuple3d)vertexA.position, (Tuple3d)vertexB.position);
        bc.sub((Tuple3d)vertexC.position, (Tuple3d)vertexB.position);
        ba.normalize();
        bc.normalize();
        Vector3d result = new Vector3d();
        result.cross(bc, ba);
        return result;
    }

    public static int getProgressTotalForCalculateNormals(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray.getTriangleCount();
    }

    public static Vector3d[] calculateNormals(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        Vector3d[] result = null;
        int triangleCount = indexedTriangleArray.getTriangleCount();
        if (triangleCount > 0) {
            Vertex3d[] vertices = indexedTriangleArray.getVertices();
            result = new Vector3d[vertices.length];
            int[] counts = new int[vertices.length];
            int i = 0;
            while (i < counts.length) {
                counts[i] = 0;
                result[i] = new Vector3d();
                ++i;
            }
            int[] indices = indexedTriangleArray.getIndices();
            if (progressObserver != null) {
                progressObserver.progressUpdateTotal(triangleCount);
                progressObserver.progressUpdateCurrent(0);
            }
            int index = 0;
            int t = 0;
            while (t < triangleCount) {
                int a = indices[index++];
                int b = indices[index++];
                int c = indices[index++];
                Vector3d normal = IndexedTriangleArrayUtil.getDirection(vertices[a], vertices[b], vertices[c]);
                normal.normalize();
                result[a].add((Tuple3d)normal);
                result[b].add((Tuple3d)normal);
                result[c].add((Tuple3d)normal);
                int n = a;
                counts[n] = counts[n] + 1;
                int n2 = b;
                counts[n2] = counts[n2] + 1;
                int n3 = c;
                counts[n3] = counts[n3] + 1;
                if (progressObserver != null) {
                    progressObserver.progressUpdateCurrent(t);
                }
                ++t;
            }
            int i2 = 0;
            while (i2 < result.length) {
                result[i2].scale(1.0 / (double)counts[i2]);
                ++i2;
            }
        }
        return result;
    }

    public static int getProgressTotalForCalculateUnsharedVertices(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray.getIndexCount();
    }

    public static Object[] calculateUnsharedVertices(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        Vertex3d[] verticesResult = null;
        int[] indicesResult = null;
        if (indexedTriangleArray.getIndexCount() > 0) {
            Vertex3d[] oldVertices = indexedTriangleArray.getVertices();
            int[] indices = indexedTriangleArray.getIndices();
            verticesResult = new Vertex3d[indices.length];
            indicesResult = new int[indices.length];
            if (progressObserver != null) {
                progressObserver.progressUpdateCurrent(0);
                progressObserver.progressUpdateTotal(indices.length);
            }
            int i = 0;
            while (i < indices.length) {
                verticesResult[i] = (Vertex3d)oldVertices[indices[i]].clone();
                indicesResult[i] = i;
                if (progressObserver != null) {
                    progressObserver.progressUpdateCurrent(i + 1);
                }
                ++i;
            }
        }
        return new Object[]{verticesResult, indicesResult};
    }

    public static int getProgressTotalForCalculateSharedVertices(IndexedTriangleArray indexedTriangleArray) {
        int n = indexedTriangleArray.getVertexCount();
        return n * n;
    }

    /*
     * Unable to fully structure code
     */
    public static Object[] calculateSharedVertices(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        block10: {
            verticesResult = null;
            indicesResult = null;
            oldVertexCount = indexedTriangleArray.getVertexCount();
            if (oldVertexCount <= 0) break block10;
            oldVertices = indexedTriangleArray.getVertices();
            indices = indexedTriangleArray.getIndices();
            newVertexCount = 0;
            oldToNew = new int[oldVertexCount];
            i = 0;
            while (i < oldVertexCount) {
                oldToNew[i] = -1;
                ++i;
            }
            progress = 0;
            n = oldVertexCount;
            if (progressObserver != null) {
                progressObserver.progressUpdateCurrent(progress);
                progressObserver.progressUpdateTotal(n * n);
            }
            i = 0;
            while (i < oldVertexCount) {
                if (oldToNew[i] == -1) {
                    oldToNew[i] = newVertexCount++;
                    j = i + 1;
                    while (j < oldVertexCount) {
                        if (oldVertices[i].equals(oldVertices[j])) {
                            oldToNew[j] = oldToNew[i];
                        }
                        ++j;
                    }
                }
                progress += n;
                if (progressObserver != null) {
                    progressObserver.progressUpdateCurrent(progress);
                }
                ++i;
            }
            indicesResult = new int[indices.length];
            i = 0;
            while (i < indices.length) {
                indicesResult[i] = oldToNew[indices[i]];
                ++i;
            }
            verticesResult = new Vertex3d[newVertexCount];
            kOld = 0;
            kNew = 0;
            j = 0;
            i = 0;
            ** GOTO lbl51
            {
                ++kOld;
                do {
                    if (oldToNew[j++] != i) continue block4;
                    verticesResult[kNew++] = oldVertices[kOld++];
                    ++i;
lbl51:
                    // 2 sources

                } while (i < verticesResult.length);
            }
        }
        return new Object[]{verticesResult, indicesResult};
    }

    public static int getProgressTotalForCalculateSmoothedNormals(IndexedTriangleArray indexedTriangleArray) {
        int n = indexedTriangleArray.getVertexCount();
        return n * n;
    }

    public static Vector3d[] calculateSmoothedNormals(IndexedTriangleArray indexedTriangleArray, double threshold, ProgressObserver progressObserver) {
        Vector3d[] result = null;
        int triangleCount = indexedTriangleArray.getTriangleCount();
        if (triangleCount > 0) {
            Vertex3d[] vertices = indexedTriangleArray.getVertices();
            result = new Vector3d[vertices.length];
            int[] a = new int[vertices.length];
            int i = 0;
            while (i < a.length) {
                a[i] = -1;
                ++i;
            }
            int progress = 0;
            if (progressObserver != null) {
                progressObserver.progressUpdateTotal(triangleCount);
                progressObserver.progressUpdateCurrent(0);
            }
            int i2 = 0;
            while (i2 < vertices.length) {
                if (a[i2] == -1) {
                    a[i2] = i2;
                    Point3d posI = vertices[i2].position;
                    Vector3d normalI = vertices[i2].normal;
                    Vector3d sum = new Vector3d(normalI);
                    int j = i2 + 1;
                    while (j < vertices.length) {
                        double f;
                        Point3d posJ = vertices[j].position;
                        Vector3d normalJ = vertices[j].normal;
                        if (posI.equals((Tuple3d)posJ) && (f = -((normalI.dot(normalJ) - 1.0) * Math.PI * 0.5)) < threshold) {
                            sum.add((Tuple3d)normalJ);
                            a[j] = i2;
                        }
                        ++j;
                    }
                    sum.normalize();
                    j = i2;
                    while (j < vertices.length) {
                        if (a[j] == i2) {
                            result[j] = sum;
                        }
                        ++j;
                    }
                }
                progress += vertices.length;
                if (progressObserver != null) {
                    progressObserver.progressUpdateCurrent(progress);
                }
                ++i2;
            }
        }
        return result;
    }
}

