/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.LightweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ContainerProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.DisplayDriver;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.GeometryProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.HeavyweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderCanvas;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTargetAdapter;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.VisualProxy;
import javax.vecmath.Vector3d;

public abstract class Renderer
extends AbstractProxyRenderer {
    private int m_nativeInstance = 0;
    private edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver[] m_displayDrivers = null;

    static {
        System.loadLibrary("jawt");
    }

    protected abstract void createNativeInstance();

    protected abstract void releaseNativeInstance();

    protected abstract int getDisplayDriverCount();

    protected abstract int getDisplayDriverNativeInstanceAt(int var1);

    protected abstract void pick(ComponentProxy var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, boolean var20, boolean var21, int[] var22, boolean[] var23, int[] var24, double[] var25);

    protected abstract DisplayDriver createDisplayDriver(int var1);

    protected abstract RenderTargetAdapter createRenderTargetAdapter(RenderTarget var1);

    protected abstract RenderCanvas createRenderCanvas(HeavyweightOnscreenRenderTarget var1);

    protected abstract boolean requiresHierarchyAndAbsoluteTransformationListening();

    protected abstract boolean requiresBoundListening();

    public Renderer() {
        this.createNativeInstance();
    }

    public PickInfo pick(Component sgComponent, Vector3d v, double planeMinX, double planeMinY, double planeMaxX, double planeMaxY, double nearClippingPlaneDistance, double farClippingPlaneDistance, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        this.commitAnyPendingChanges();
        ComponentProxy componentProxy = (ComponentProxy)this.getProxyFor(sgComponent);
        int[] atVisual = new int[1];
        boolean[] atIsFrontFacing = new boolean[]{true};
        int[] atSubElement = new int[]{-1};
        double[] atZ = new double[]{Double.NaN};
        this.pick(componentProxy, v.x, v.y, v.z, planeMinX, planeMinY, planeMaxX, planeMaxY, nearClippingPlaneDistance, farClippingPlaneDistance, isSubElementRequired, isOnlyFrontMostRequired, atVisual, atIsFrontFacing, atSubElement, atZ);
        Visual[] sgVisuals = null;
        Geometry[] sgGeometries = null;
        int[] subElements = null;
        boolean[] isFrontFacings = null;
        VisualProxy visualProxy = VisualProxy.map(atVisual[0]);
        if (visualProxy != null) {
            sgVisuals = new Visual[]{(Visual)visualProxy.getSceneGraphElement()};
            sgGeometries = new Geometry[]{sgVisuals[0].getGeometry()};
            subElements = new int[]{atSubElement[0]};
            isFrontFacings = new boolean[]{atIsFrontFacing[0]};
        }
        return new PickInfo(null, null, -1, -1, sgVisuals, isFrontFacings, sgGeometries, subElements);
    }

    protected void dispatchAbsoluteTransformationChange(AbsoluteTransformationEvent absoluteTransformationEvent) {
        Component sgComponent = (Component)absoluteTransformationEvent.getSource();
        if (!sgComponent.isReleased()) {
            ComponentProxy componentProxy = (ComponentProxy)this.getProxyFor(sgComponent);
            componentProxy.onAbsoluteTransformationChange();
        }
    }

    protected void dispatchBoundChange(BoundEvent boundEvent) {
    }

    public void dispatchChildAdd(ChildrenEvent childrenEvent) {
        Container sgContainer = (Container)childrenEvent.getSource();
        Component sgChild = childrenEvent.getChild();
        if (!sgContainer.isReleased() && !sgChild.isReleased()) {
            ContainerProxy containerProxy = (ContainerProxy)this.getProxyFor(sgContainer);
            ComponentProxy childProxy = (ComponentProxy)this.getProxyFor(sgChild);
            containerProxy.onChildAdded(childProxy);
        }
    }

    public void dispatchChildRemove(ChildrenEvent childrenEvent) {
        Container sgContainer = (Container)childrenEvent.getSource();
        Component sgChild = childrenEvent.getChild();
        if (!sgContainer.isReleased() && !sgChild.isReleased()) {
            ContainerProxy containerProxy = (ContainerProxy)this.getProxyFor(sgContainer);
            ComponentProxy childProxy = (ComponentProxy)this.getProxyFor(sgChild);
            containerProxy.onChildRemoved(childProxy);
        }
    }

    protected void dispatchHierarchyChange(HierarchyEvent hierarchyEvent) {
        Component sgComponent = (Component)hierarchyEvent.getSource();
        if (!sgComponent.isReleased()) {
            ComponentProxy componentProxy = (ComponentProxy)this.getProxyFor(sgComponent);
            componentProxy.onHierarchyChange();
        }
    }

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver[] getDisplayDrivers() {
        if (this.m_displayDrivers == null) {
            int driverCount = this.getDisplayDriverCount();
            this.m_displayDrivers = new DisplayDriver[driverCount];
            int i = 0;
            while (i < driverCount) {
                int driverID = this.getDisplayDriverNativeInstanceAt(i);
                this.m_displayDrivers[i] = this.createDisplayDriver(driverID);
                ++i;
            }
        }
        return this.m_displayDrivers;
    }

    public void commitAnyPendingChanges() {
        super.commitAnyPendingChanges();
        ComponentProxy.updateAbsoluteTransformationChanges();
        GeometryProxy.updateBoundChanges();
    }

    protected void doFrame() {
        OnscreenRenderTarget[] onscreenRenderTargets;
        boolean atLeastOneRenderTargetHasUpdated = false;
        OnscreenRenderTarget[] onscreenRenderTargetArray = onscreenRenderTargets = this.getOnscreenRenderTargets();
        synchronized (onscreenRenderTargets) {
            java.awt.Component component;
            edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget onscreenRenderTarget;
            this.onIdle();
            int i = 0;
            while (i < onscreenRenderTargets.length) {
                if (onscreenRenderTargets[i] instanceof edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget && (onscreenRenderTarget = (edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget)onscreenRenderTargets[i]).getAWTComponent() != null) {
                    component = onscreenRenderTarget.getAWTComponent();
                    synchronized (component) {
                        if (onscreenRenderTarget.updateIsAutomatic()) {
                            onscreenRenderTarget.commitAnyPendingChanges();
                            if (onscreenRenderTarget.clearAndRenderOffscreenIsRequired()) {
                                onscreenRenderTarget.clearAndRenderOffscreen();
                            }
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < onscreenRenderTargets.length) {
                if (onscreenRenderTargets[i] instanceof edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget && (onscreenRenderTarget = (edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.OnscreenRenderTarget)onscreenRenderTargets[i]).getAWTComponent() != null) {
                    component = onscreenRenderTarget.getAWTComponent();
                    synchronized (component) {
                        if (onscreenRenderTarget.updateIsAutomatic() && onscreenRenderTarget.updateIsRequired()) {
                            onscreenRenderTarget.update();
                            if (!onscreenRenderTarget.updateIsRequired()) {
                                atLeastOneRenderTargetHasUpdated = true;
                            }
                        }
                    }
                }
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            try {
                if (onscreenRenderTargets.length > 0) {
                    if (atLeastOneRenderTargetHasUpdated) {
                        Thread.sleep(3L);
                    } else {
                        Thread.sleep(15L);
                    }
                } else {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    protected abstract AbstractProxy createProxyFor(Element var1);

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget createOffscreenRenderTarget() {
        return new OffscreenRenderTarget(this);
    }

    public edu.cmu.cs.stage3.alice.scenegraph.renderer.HeavyweightOnscreenRenderTarget createHeavyweightOnscreenRenderTarget() {
        return new HeavyweightOnscreenRenderTarget(this);
    }

    public LightweightOnscreenRenderTarget createLightweightOnscreenRenderTarget() {
        return new edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.LightweightOnscreenRenderTarget(this);
    }
}

