/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.math.Plane;
import edu.cmu.cs.stage3.math.Ray;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import java.awt.Rectangle;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class PickInfo {
    private RenderTarget m_renderTarget = null;
    private Camera m_camera = null;
    private int m_x = -1;
    private int m_y = -1;
    private Component m_source = null;
    private Matrix4d m_projection;
    private Visual[] m_visuals;
    private boolean[] m_isFrontFacings;
    private Geometry[] m_geometries;
    private int[] m_subElements;
    private double[] m_zs;

    public RenderTarget getRenderTarget() {
        return this.m_renderTarget;
    }

    public Camera getCamera() {
        return this.m_camera;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public PickInfo(RenderTarget renderTarget, Camera camera, int x, int y, Visual[] visuals, boolean[] isFrontFacings, Geometry[] geometries, int[] subElements) {
        this.m_renderTarget = renderTarget;
        this.m_camera = camera;
        this.m_source = camera;
        this.m_x = x;
        this.m_y = y;
        this.m_visuals = visuals;
        this.m_isFrontFacings = isFrontFacings;
        this.m_geometries = geometries;
        this.m_subElements = subElements;
    }

    public PickInfo(Component component, Matrix4d projection, Visual[] visuals, boolean[] isFrontFacings, Geometry[] geometries, int[] subElements, double[] zs) {
        this.m_source = component;
        this.m_projection = projection;
        this.m_visuals = visuals;
        this.m_isFrontFacings = isFrontFacings;
        this.m_geometries = geometries;
        this.m_subElements = subElements;
        this.m_zs = zs;
    }

    public Component getSource() {
        return this.m_source;
    }

    public Visual[] getVisuals() {
        return this.m_visuals;
    }

    public Geometry[] getGeometries() {
        return this.m_geometries;
    }

    public boolean[] isFrontFacings() {
        return this.m_isFrontFacings;
    }

    public int[] getSubElements() {
        return this.m_subElements;
    }

    public double[] getZs() {
        return this.m_zs;
    }

    public int getCount() {
        if (this.m_visuals != null) {
            return this.m_visuals.length;
        }
        return 0;
    }

    public Visual getVisual(int index) {
        return this.m_visuals[index];
    }

    public boolean isFrontFacing(int index) {
        return this.m_isFrontFacings[index];
    }

    public Geometry getGeometry(int index) {
        return this.m_geometries[index];
    }

    public int getSubElement(int index) {
        return this.m_subElements[index];
    }

    public double getZ(int index) {
        return this.m_zs[index];
    }

    public Vector3d getLocalPosition(int index) {
        if (this.m_source != null && this.m_zs != null) {
            Matrix4d componentInverseAbsolute = this.m_source.getInverseAbsoluteTransformation();
            Matrix4d visualAbsolute = this.getVisual(index).getAbsoluteTransformation();
            Vector4d xyzw = new Vector4d(0.0, 0.0, this.m_zs[index], 1.0);
            this.m_projection.transform((Tuple4d)xyzw);
            componentInverseAbsolute.transform((Tuple4d)xyzw);
            visualAbsolute.transform((Tuple4d)xyzw);
            return new Vector3d(xyzw.x / xyzw.w, xyzw.y / xyzw.w, xyzw.z / xyzw.w);
        }
        Visual visual = this.getVisual(index);
        Geometry geometry = this.getGeometry(index);
        int subElement = this.getSubElement(index);
        IndexedTriangleArray ita = (IndexedTriangleArray)geometry;
        Vertex3d[] vertices = ita.getVertices();
        int[] indices = ita.getIndices();
        int i0 = subElement * 3;
        Vector3 v0 = new Vector3((Tuple3d)vertices[indices[i0]].position);
        Vector3 v1 = new Vector3((Tuple3d)vertices[indices[i0 + 1]].position);
        Vector3 v2 = new Vector3((Tuple3d)vertices[indices[i0 + 2]].position);
        Matrix3d scale = visual.getScale();
        if (scale != null) {
            v0 = Vector3.multiply(scale, (Vector3d)v0);
            v1 = Vector3.multiply(scale, (Vector3d)v1);
            v2 = Vector3.multiply(scale, (Vector3d)v2);
        }
        Plane plane = new Plane(v0, v1, v2);
        Matrix4d inverseProjection = this.m_renderTarget.getProjectionMatrix(this.m_camera);
        inverseProjection.invert();
        Vector3 origin = new Vector3(inverseProjection.m20, inverseProjection.m21, inverseProjection.m22);
        origin.divide(inverseProjection.m23);
        Rectangle viewport = this.m_renderTarget.getActualViewport(this.m_camera);
        double halfWidth = (double)viewport.width / 2.0;
        double halfHeight = (double)viewport.height / 2.0;
        double x = ((double)this.m_x + 0.5 - halfWidth) / halfWidth;
        double y = -((double)this.m_y + 0.5 - halfHeight) / halfHeight;
        Vector4 qs = new Vector4(x, y, 0.0, 1.0);
        Vector4 qw = Vector4.multiply(qs, inverseProjection);
        Vector3 direction = new Vector3(qw.x * inverseProjection.m23 - qw.w * inverseProjection.m20, qw.y * inverseProjection.m23 - qw.w * inverseProjection.m21, qw.z * inverseProjection.m23 - qw.w * inverseProjection.m22);
        direction.normalize();
        Ray ray = new Ray(origin, direction);
        ReferenceFrame cameraFrame = (ReferenceFrame)this.m_camera.getParent();
        ray.transform(cameraFrame.getAbsoluteTransformation());
        ReferenceFrame visualFrame = (ReferenceFrame)visual.getParent();
        Matrix4d inverseVisual = visualFrame.getInverseAbsoluteTransformation();
        ray.transform(inverseVisual);
        double t = plane.intersect(ray);
        return ray.getPoint(t);
    }

    public String toString() {
        int i;
        int n;
        String s = "edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo[renderTarget=" + this.getRenderTarget() + ",camera=" + this.getCamera() + ",x=" + this.getX() + ",y=" + this.getY() + ",";
        s = String.valueOf(s) + "visuals={";
        if (this.m_visuals != null) {
            n = this.m_visuals.length;
            i = 0;
            while (i < n) {
                s = String.valueOf(s) + this.m_visuals[i];
                if (i < n - 1) {
                    s = String.valueOf(s) + ",";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "},isFrontFacings={";
        if (this.m_isFrontFacings != null) {
            n = this.m_isFrontFacings.length;
            i = 0;
            while (i < n) {
                s = String.valueOf(s) + this.m_isFrontFacings[i];
                if (i < n - 1) {
                    s = String.valueOf(s) + ",";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "},geometries={";
        if (this.m_geometries != null) {
            n = this.m_geometries.length;
            i = 0;
            while (i < n) {
                s = String.valueOf(s) + this.m_geometries[i];
                if (i < n - 1) {
                    s = String.valueOf(s) + ",";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "},subElements={";
        if (this.m_subElements != null) {
            n = this.m_subElements.length;
            i = 0;
            while (i < n) {
                s = String.valueOf(s) + this.m_subElements[i];
                if (i < n - 1) {
                    s = String.valueOf(s) + ",";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "}]";
        return s;
    }

    public PickInfo valueOf(String s) {
        return null;
    }
}

